/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Hashtable;
import jd.xml.util.SaxUtil;
import jd.xml.util.XmlSource;
import jd.xml.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class AssocStylesheetBuilder {
    private String title_;
    private String media_;
    private String charset_;

    public AssocStylesheetBuilder(String string, String string2, String string3) {
        this.title_ = string;
        this.media_ = string2;
        this.charset_ = string3;
    }

    public synchronized String getStylesheetString(XmlSource xmlSource) throws SAXException, IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">");
        printWriter.println();
        Handler handler = new Handler(printWriter);
        XMLReader xMLReader = this.getXmlReader(xmlSource);
        xMLReader.setContentHandler(handler);
        try {
            xMLReader.parse(xmlSource.getInputSource());
        }
        catch (DocElementException docElementException) {
            // empty catch block
        }
        printWriter.println();
        printWriter.println("</xsl:stylesheet>");
        printWriter.flush();
        return handler.getPiCount() > 0 ? stringWriter.getBuffer().toString() : null;
    }

    private XMLReader getXmlReader(XmlSource xmlSource) throws SAXException {
        if (xmlSource.getParser() instanceof XMLReader) {
            return (XMLReader)xmlSource.getParser();
        }
        return SaxUtil.createXmlReader();
    }

    public XmlSource getStylesheetSource(XmlSource xmlSource) throws SAXException, IOException {
        String string = this.getStylesheetString(xmlSource);
        if (string == null) {
            return null;
        }
        InputSource inputSource = new InputSource(xmlSource.getUri());
        inputSource.setCharacterStream(new StringReader(string));
        return new XmlSource(inputSource);
    }

    private static class DocElementException
    extends SAXException {
        public DocElementException() {
            super("");
        }
    }

    private class Handler
    extends DefaultHandler {
        private PrintWriter out_;
        private int piCount_;

        public Handler(PrintWriter printWriter) {
            this.out_ = printWriter;
        }

        @Override
        public void processingInstruction(String string, String string2) {
            if ("xml-stylesheet".equals(string)) {
                ++this.piCount_;
                Hashtable hashtable = XmlUtil.getPiPseudoAttributes(string2);
                String string3 = (String)hashtable.get("href");
                String string4 = (String)hashtable.get("type");
                String string5 = (String)hashtable.get("media");
                String string6 = (String)hashtable.get("title");
                String string7 = (String)hashtable.get("charset");
                if (string3 != null && string4 != null && (string4.equals("text/xsl") || string4.equals("application/xsl") || string4.equals("text/xml") || string4.equals("application/xml")) && (AssocStylesheetBuilder.this.media_ == null || AssocStylesheetBuilder.this.media_.equals(string5)) && (AssocStylesheetBuilder.this.title_ == null || AssocStylesheetBuilder.this.title_.equals(string6)) && (AssocStylesheetBuilder.this.charset_ == null || AssocStylesheetBuilder.this.charset_.equals(string7))) {
                    this.out_.print("<xsl:import href=\"");
                    this.out_.print(string3);
                    this.out_.println("\"/>");
                }
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            throw new DocElementException();
        }

        public int getPiCount() {
            return this.piCount_;
        }
    }
}

