/*
 * Decompiled with CFR 0.152.
 */
package com.avs.openviz3.cognos;

import com.avs.openviz3.cognos.OpenVizGraphics2D;
import com.avs.openviz3.fw.ArrayPointFloat3;
import com.avs.openviz3.fw.ArrayString;
import com.avs.openviz3.fw.PointFloat2;
import com.avs.openviz3.fw.PointFloat3;
import com.avs.openviz3.fw.util.Common;
import com.avs.openviz3.viewer.CullFaceEnum;
import com.avs.openviz3.viewer.renderer.RenderDataSourceEnum;
import com.avs.openviz3.viewer.renderer.paint.SurfaceAttribute;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;

class AWTPainter
extends com.avs.openviz3.viewer.renderer.paint.AWTPainter {
    private RenderDataSourceEnum _imageMapAreaSource = RenderDataSourceEnum.NONE;
    private ArrayString _imageMapAreas = null;
    private String _currentTag = null;
    private ArrayPointFloat3 _textureIndices = null;

    protected AWTPainter(boolean bl) {
        super(bl);
        this._minLineWidth = 0.0;
        this.fittingScale = 0.5f;
        this._drawLineStripAsSinglePath = false;
        this._forceDrawString = true;
    }

    public void resetArrays() {
        super.resetArrays();
        this._imageMapAreas = null;
        this._imageMapAreaSource = RenderDataSourceEnum.NONE;
        this._textureIndices = null;
    }

    public void setTextureIndexArray(ArrayPointFloat3 arrayPointFloat3) {
        this._textureIndices = arrayPointFloat3;
    }

    public void setImageMapAreaArray(ArrayString arrayString, RenderDataSourceEnum renderDataSourceEnum) {
        this._imageMapAreas = arrayString;
        this._imageMapAreaSource = renderDataSourceEnum;
    }

    private String getTagFromArray(int n) {
        int n2 = this._imageMapAreas == null ? 0 : this._imageMapAreas.getNumValues();
        String string = n < 0 || n >= n2 ? null : this._imageMapAreas.getValue(n);
        return string;
    }

    public void setObjectTag(int n, String string) {
        if (this._graphics instanceof OpenVizGraphics2D) {
            OpenVizGraphics2D openVizGraphics2D = (OpenVizGraphics2D)((Object)this._graphics);
            String string2 = this._imageMapAreaSource == RenderDataSourceEnum.CELL_SET ? this.getTagFromArray(0) : (this._imageMapAreaSource == RenderDataSourceEnum.CELL ? this.getTagFromArray(n) : string);
            if (string2 != null || this._currentTag != null) {
                this._currentTag = string2;
                openVizGraphics2D.setTag(string2);
            }
        }
    }

    protected boolean isTriangleDegenerate(PointFloat2[] pointFloat2Array) {
        PointFloat2 pointFloat2 = pointFloat2Array[0];
        PointFloat2 pointFloat22 = pointFloat2Array[1];
        PointFloat2 pointFloat23 = pointFloat2Array[2];
        float f = PointFloat2.crossProduct((PointFloat2)PointFloat2.subtract((PointFloat2)pointFloat22, (PointFloat2)pointFloat2), (PointFloat2)PointFloat2.subtract((PointFloat2)pointFloat23, (PointFloat2)pointFloat2));
        boolean bl = f == 0.0f;
        return bl;
    }

    private void _paintShadedTriangles(OpenVizGraphics2D openVizGraphics2D, ArrayPointFloat3 arrayPointFloat3) {
        boolean bl;
        int n = this._surfaceAttribute.getStippleIndex();
        boolean bl2 = n > 0;
        boolean bl3 = bl2 && this._surfaceAttribute.getShowStippleBackground();
        boolean bl4 = bl = bl2 && !bl3;
        if (bl) {
            super.paintTriangles(arrayPointFloat3);
            return;
        }
        int n2 = arrayPointFloat3.getNumValues() / 3;
        CullFaceEnum cullFaceEnum = this._surfaceAttribute.getCullFace();
        boolean bl5 = cullFaceEnum == CullFaceEnum.BACK || cullFaceEnum == CullFaceEnum.FRONT;
        PointFloat3[] pointFloat3Array = new PointFloat3[3];
        for (int i = 0; i < n2; ++i) {
            PointFloat2[] pointFloat2Array;
            boolean bl6;
            this.setObjectTag(i, this._surfaceAttribute == null ? null : this._surfaceAttribute.getImageMapArea());
            int n3 = 3 * i + 0;
            int n4 = 3 * i + 1;
            int n5 = 3 * i + 2;
            pointFloat3Array[0] = arrayPointFloat3.getValue(n3);
            pointFloat3Array[1] = arrayPointFloat3.getValue(n4);
            pointFloat3Array[2] = arrayPointFloat3.getValue(n5);
            if (bl5 && (bl6 = this.isTriangleCulled(pointFloat3Array, cullFaceEnum, this._currViewport.getViewportHorizontalDirection())) || this.isTriangleDegenerate(pointFloat2Array = this._convertNDCToDC(pointFloat3Array))) continue;
            Color[] colorArray = new Color[]{this._getColor(this._colors, n3), this._getColor(this._colors, n4), this._getColor(this._colors, n5)};
            colorArray[0] = this.generateTransparentColor(colorArray[0]);
            colorArray[1] = this.generateTransparentColor(colorArray[1]);
            colorArray[2] = this.generateTransparentColor(colorArray[2]);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(pointFloat2Array[0].getX(), pointFloat2Array[0].getY());
            generalPath.lineTo(pointFloat2Array[1].getX(), pointFloat2Array[1].getY());
            generalPath.lineTo(pointFloat2Array[2].getX(), pointFloat2Array[2].getY());
            generalPath.closePath();
            if (bl) {
                // empty if block
            }
            openVizGraphics2D.fillShaded(generalPath, colorArray);
            if (!(openVizGraphics2D instanceof Graphics2D) || !bl2 || !bl3) continue;
            Color color = this._surfaceAttribute.getStippleColor();
            Paint paint = this._getSurfaceStipplePaint(n, color);
            Graphics2D graphics2D = (Graphics2D)((Object)openVizGraphics2D);
            if (paint != null) {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(generalPath);
        }
    }

    private void _paintTexturedTriangles(OpenVizGraphics2D openVizGraphics2D, ArrayPointFloat3 arrayPointFloat3) {
        int n = arrayPointFloat3.getNumValues() / 3;
        PointFloat3[] pointFloat3Array = new PointFloat3[3];
        Color[] colorArray = null;
        Color[] colorArray2 = null;
        if (this._colorSource == RenderDataSourceEnum.NODE) {
            colorArray = new Color[]{Color.white, Color.white, Color.white};
            colorArray2 = new Color[]{Color.black, Color.black, Color.black};
        } else {
            colorArray = new Color[]{Color.white};
            colorArray2 = new Color[]{Color.black};
        }
        CullFaceEnum cullFaceEnum = this._surfaceAttribute.getCullFace();
        boolean bl = cullFaceEnum == CullFaceEnum.BACK || cullFaceEnum == CullFaceEnum.FRONT;
        PointFloat3[] pointFloat3Array2 = new PointFloat3[3];
        for (int i = 0; i < n; ++i) {
            PointFloat2[] pointFloat2Array;
            boolean bl2;
            this.setObjectTag(i, this._surfaceAttribute == null ? null : this._surfaceAttribute.getImageMapArea());
            int n2 = 3 * i + 0;
            int n3 = 3 * i + 1;
            int n4 = 3 * i + 2;
            pointFloat3Array[0] = this._textureIndices.getValue(3 * i + 0);
            pointFloat3Array[1] = this._textureIndices.getValue(3 * i + 1);
            pointFloat3Array[2] = this._textureIndices.getValue(3 * i + 2);
            if (this._colorSource == RenderDataSourceEnum.NODE) {
                colorArray[0] = this._diffuse.getValue(3 * i + 0);
                colorArray[1] = this._diffuse.getValue(3 * i + 1);
                colorArray[2] = this._diffuse.getValue(3 * i + 2);
                colorArray2[0] = this._specular.getValue(3 * i + 0);
                colorArray2[1] = this._specular.getValue(3 * i + 1);
                colorArray2[2] = this._specular.getValue(3 * i + 2);
            } else if (this._colorSource == RenderDataSourceEnum.CELL) {
                colorArray[0] = this._diffuse.getValue(i);
                colorArray2[0] = this._specular.getValue(i);
            }
            SurfaceAttribute.TextureMap textureMap = this._surfaceAttribute.getTexture();
            pointFloat3Array2[0] = arrayPointFloat3.getValue(n2);
            pointFloat3Array2[1] = arrayPointFloat3.getValue(n3);
            pointFloat3Array2[2] = arrayPointFloat3.getValue(n4);
            if (bl && (bl2 = this.isTriangleCulled(pointFloat3Array2, cullFaceEnum, this._currViewport.getViewportHorizontalDirection())) || this.isTriangleDegenerate(pointFloat2Array = this._convertNDCToDC(pointFloat3Array2))) continue;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(pointFloat2Array[0].getX(), pointFloat2Array[0].getY());
            generalPath.lineTo(pointFloat2Array[1].getX(), pointFloat2Array[1].getY());
            generalPath.lineTo(pointFloat2Array[2].getX(), pointFloat2Array[2].getY());
            generalPath.closePath();
            openVizGraphics2D.fillTexture(generalPath, pointFloat3Array, textureMap);
        }
    }

    public void paintTriangles(ArrayPointFloat3 arrayPointFloat3) {
        if (Common.isZero((double)this._surfaceAttribute.getOpacity())) {
            return;
        }
        if (this._graphics instanceof OpenVizGraphics2D) {
            OpenVizGraphics2D openVizGraphics2D = (OpenVizGraphics2D)((Object)this._graphics);
            if (this._surfaceAttribute.getTexture() != null && this._textureIndices != null) {
                this._paintTexturedTriangles(openVizGraphics2D, arrayPointFloat3);
            } else if (this._colorSource == RenderDataSourceEnum.NODE) {
                this._paintShadedTriangles(openVizGraphics2D, arrayPointFloat3);
            } else {
                super.paintTriangles(arrayPointFloat3);
            }
        } else {
            super.paintTriangles(arrayPointFloat3);
        }
    }
}

