/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rtsconfig;

import com.cognos.rtsconfig.RTSConfigCompile;
import com.cognos.rtsconfig.RTSConfigDataSorter;
import com.cognos.rtsconfig.RTSConfigMode;
import com.cognos.rtsconfig.RTSConfirmSave;
import com.cognos.rtsconfig.RTSConversionData;
import com.cognos.rtsconfig.RTSConversionTable;
import com.cognos.rtsconfig.RTSFileChooser;
import com.cognos.rtsconfig.RTSFind;
import com.cognos.rtsconfig.RTSFontChooser;
import com.cognos.rtsconfig.RTSHelp;
import com.cognos.rtsconfig.RTSLoadingDialog;
import com.cognos.rtsconfig.RTSLogger;
import com.cognos.rtsconfig.RTSTransliterationData;
import com.cognos.rtsconfig.RTSTransliterationTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class RTSConfig
extends JFrame {
    private static final long serialVersionUID = 2499689617563759704L;
    private static final ResourceBundle msgs = ResourceBundle.getBundle("rtsconfigmsgs", Locale.getDefault());
    private static final String bold = msgs.getString("FONT_STYLE_BOLD");
    private static final String plain = msgs.getString("FONT_STYLE_PLAIN");
    private static final String italic = msgs.getString("FONT_STYLE_ITALIC");
    private static final String language = Locale.getDefault().getLanguage();
    protected String dataFile = new String("shift-jis.xml");
    protected RTSConversionData model1 = new RTSConversionData();
    protected RTSTransliterationData model2 = new RTSTransliterationData();
    private Font systemFont = new Font(null);
    private String tmpDir = new String();
    private String browser = new String();
    private String fontDir = new String();
    private String fontName = new String("Arial");
    private String fontSize = new String();
    private String fontStyle = plain;
    private String showGlyphs = new String("false");
    private String configMode = new String("1");
    private RTSHelp helpSystem = null;
    private RTSFind findCodepoint = new RTSFind((Frame)this, true);
    private RTSConfigMode configModeDlg = null;
    private RTSFontChooser fontChooser = null;
    private RTSLoadingDialog loadingDlg = new RTSLoadingDialog((Frame)this, false);
    private RTSConfirmSave confirmSave = new RTSConfirmSave((Frame)this, true);
    private RTSFileChooser fileChooser = null;
    private RTSConfigCompile configCompile = new RTSConfigCompile((Frame)this, this.model1, this.model2);
    private RTSConfigDataSorter sorter1 = new RTSConfigDataSorter(this.model1);
    private RTSConfigDataSorter sorter2 = new RTSConfigDataSorter(this.model2);
    private JTabbedPane jTabbedPane1;
    private JTable jTable2;
    private JTable jTable1;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JMenu helpMenu;
    private JCheckBoxMenuItem glyphMenuItem;
    private JMenuBar menuBar;
    private JMenuItem contentsMenuItem;
    private JMenuItem configureMenuItem;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane1;
    private JMenu toolsMenu;
    private JMenu viewMenu;
    private JSeparator jSeparator1;
    private JMenuItem configureModeMenuItem;
    private JMenuItem fontMenuItem;
    private JMenuItem restoreDefaultsMenuItem;
    private JMenuItem findMenuItem;
    private JMenu fileMenu;
    private JMenuItem openMenuItem;

    private void restoreDefaults() {
        try {
            this.configCompile.performUpdate(this, false, true);
            this.jTable1.repaint();
            this.jTable2.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAppFont(Font font) {
        this.jTable1.setFont(font);
        this.jTable1.getTableHeader().setFont(font);
        this.jTable1.setRowHeight(this.getFontMetrics(font).getHeight());
        this.jTable2.setFont(font);
        this.jTable2.getTableHeader().setFont(font);
        this.jTable2.setRowHeight(this.getFontMetrics(font).getHeight());
        this.helpSystem.setFont(font);
        this.findCodepoint.setFont(font);
        this.configCompile.setFont(font);
        this.confirmSave.setFont(font);
        this.fontChooser.setFont(font);
        this.configModeDlg.setFont(font);
        this.fileChooser = new RTSFileChooser(".");
        this.fileChooser.setFont(font);
        Dimension dim = this.fileChooser.getLayout().preferredLayoutSize(this.fileChooser);
        dim.width += this.getFontMetrics(font).getHeight() * 9;
        this.fileChooser.setPreferredSize(dim);
        Font titleFont = font.deriveFont(font.getStyle() | 1);
        this.jTabbedPane1.setFont(titleFont);
        this.fileMenu.setFont(titleFont);
        this.openMenuItem.setFont(titleFont);
        this.saveMenuItem.setFont(titleFont);
        this.saveAsMenuItem.setFont(titleFont);
        this.exitMenuItem.setFont(titleFont);
        this.editMenu.setFont(titleFont);
        this.findMenuItem.setFont(titleFont);
        this.viewMenu.setFont(titleFont);
        this.glyphMenuItem.setFont(titleFont);
        this.fontMenuItem.setFont(titleFont);
        this.toolsMenu.setFont(titleFont);
        this.configureMenuItem.setFont(titleFont);
        this.configureModeMenuItem.setFont(titleFont);
        this.restoreDefaultsMenuItem.setFont(titleFont);
        this.helpMenu.setFont(titleFont);
        this.contentsMenuItem.setFont(titleFont);
    }

    public void save(boolean confirm) {
        boolean save = true;
        if (!this.model1.dataChanged() && !this.model2.dataChanged()) {
            return;
        }
        if (confirm) {
            save = this.confirmSave.response();
        }
        if (save) {
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(this.dataFile));
                out.write("<?xml version=\"1.0\"?>");
                out.newLine();
                out.write("<rtsconfig encoding=\"shift-jis\">");
                out.newLine();
                this.model1.save(out);
                this.model2.save(out);
                out.write("</rtsconfig>");
                out.newLine();
                out.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.model1.setDataChanged(false);
            this.model2.setDataChanged(false);
        } else {
            RTSLogger.getInstance();
            RTSLogger.reset();
        }
    }

    private String getfontStyle() {
        String value = new String();
        switch (this.systemFont.getStyle()) {
            case 0: {
                value = plain;
                break;
            }
            case 1: {
                value = bold;
                break;
            }
            case 2: {
                value = italic;
            }
        }
        return value;
    }

    private void loadProperties() {
        File file;
        String propFile = null;
        Properties properties = new Properties();
        if (propFile == null && language.length() > 0 && !(file = new File(propFile = "rtsconfig_" + language + ".properties")).exists()) {
            propFile = null;
        }
        if (propFile == null && !(file = new File(propFile = "rtsconfig.properties")).exists()) {
            propFile = null;
        }
        if (propFile != null) {
            try {
                FileInputStream in = new FileInputStream(new File(propFile));
                properties.load(in);
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.browser = properties.getProperty("browser", this.browser);
        this.fontDir = properties.getProperty("fontdir", this.fontDir);
        this.fontName = properties.getProperty("fontname", this.systemFont.getFamily());
        this.fontStyle = properties.getProperty("fontstyle", this.getfontStyle());
        this.fontSize = properties.getProperty("fontsize", Integer.toString(this.systemFont.getSize()));
        this.showGlyphs = properties.getProperty("showglyphs", this.showGlyphs);
        this.configMode = properties.getProperty("configMode", this.configMode);
        this.loadingDlg.setFont(new Font(this.fontName, 0, Integer.parseInt(this.fontSize)));
        this.loadingDlg.setVisible(true);
        this.configModeDlg = this.configMode.equalsIgnoreCase("0") ? new RTSConfigMode(0, this, true) : new RTSConfigMode(1, this, true);
        this.helpSystem = new RTSHelp((Frame)this, true, this.browser);
        this.fontChooser = new RTSFontChooser(this, this.fontDir, this.fontName, this.fontStyle, this.fontSize);
        this.loadingDlg.setVisible(false);
        this.loadingDlg.dispose();
    }

    private void saveProperties() {
        try {
            String propFile = null;
            Properties properties = new Properties();
            properties.clear();
            if (this.browser.length() > 0) {
                properties.setProperty("browser", this.browser);
            }
            if (this.fontDir.length() > 0) {
                properties.setProperty("fontdir", this.fontDir);
            }
            if (!this.fontName.equalsIgnoreCase(this.systemFont.getFamily())) {
                properties.setProperty("fontname", this.fontName);
            }
            if (!this.fontStyle.equalsIgnoreCase(this.getfontStyle())) {
                properties.setProperty("fontstyle", this.fontStyle);
            }
            if (!this.fontSize.equalsIgnoreCase(Integer.toString(this.systemFont.getSize()))) {
                properties.setProperty("fontsize", this.fontSize);
            }
            if (!this.showGlyphs.equalsIgnoreCase("false")) {
                properties.setProperty("showglyphs", this.showGlyphs);
            }
            if (!this.configMode.equalsIgnoreCase("1")) {
                properties.setProperty("configMode", this.configMode);
            }
            propFile = language.length() > 0 ? "rtsconfig_" + language + ".properties" : "rtsconfig.properties";
            FileOutputStream out = new FileOutputStream(new File(propFile));
            properties.store(out, "Round trip configuration utility properties");
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void init(String fileName) {
        this.loadProperties();
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(fileName);
            this.model1.load(document);
            this.model2.load(document);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setAppFont(this.fontChooser.getSelectedFont());
        if (this.showGlyphs.equals("true")) {
            this.glyphMenuItem.setState(true);
        }
    }

    private void shutdown() {
        this.save(true);
        this.saveProperties();
        File tmpfiles = new File(this.tmpDir);
        String[] files = tmpfiles.list();
        if (files != null) {
            for (int idx = 0; idx < files.length; ++idx) {
                String tmpfile = this.tmpDir + "/" + files[idx];
                File file = new File(tmpfile);
                file.delete();
            }
        }
        RTSLogger.getInstance();
        RTSLogger.sessionEnd();
        System.exit(0);
    }

    private void displayGlyphs(JTable table, boolean display) {
        if (table == this.jTable1) {
            this.model1.showGlyphs(display);
        } else {
            ((RTSTransliterationTable)this.jTable2).cancelEdit();
            this.model2.showGlyphs(display);
        }
        table.repaint();
    }

    public RTSConfig() {
        String userdir = System.getProperty("user.dir").replace('\\', '/');
        this.tmpDir = userdir + "/../temp/rtsconfig";
        File tmp = new File(this.tmpDir);
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        System.setProperty("java.io.tmpdir", this.tmpDir);
        this.initComponents();
        this.setTitle(msgs.getString("UTILITY_TITLE"));
        this.jTabbedPane1.setTitleAt(0, msgs.getString("CONVERSION_TAB"));
        this.jTabbedPane1.setTitleAt(1, msgs.getString("SUBSTITUTION_TAB"));
        this.init(this.dataFile);
        try {
            Thread.sleep(250L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new RTSConversionTable(this.model1);
        this.jScrollPane2 = new JScrollPane();
        this.jTable2 = new RTSTransliterationTable(this.model2);
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.findMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.glyphMenuItem = new JCheckBoxMenuItem();
        this.fontMenuItem = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.configureModeMenuItem = new JMenuItem();
        this.configureMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.restoreDefaultsMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RTSConfig.this.exitForm(evt);
            }
        });
        this.jTabbedPane1.setName("");
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RTSConfig.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jScrollPane1.setName("");
        this.jTable1.setEditingColumn(0);
        this.jTable1.setEditingRow(0);
        this.jTable1.setModel(this.sorter1);
        this.jTable1.setFont(new Font("Dialog", 0, 14));
        this.jTable1.setAutoResizeMode(4);
        this.jTable1.getTableHeader().setResizingAllowed(true);
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RTSConfig.this.jTable1PropertyChange(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTabbedPane1.addTab("", this.jScrollPane1);
        this.jTable2.setModel(this.sorter2);
        this.jTable2.setFont(new Font("Dialog", 0, 14));
        this.jTable2.setAutoResizeMode(4);
        this.jTable2.getTableHeader().setResizingAllowed(true);
        this.jTable2.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane2.setViewportView(this.jTable2);
        this.jTabbedPane1.addTab("", this.jScrollPane2);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.fileMenu.setText(msgs.getString("FILE"));
        this.openMenuItem.setText(msgs.getString("FILE_OPEN"));
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RTSConfig.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText(msgs.getString("FILE_SAVE"));
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RTSConfig.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText(msgs.getString("FILE_SAVE_AS"));
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RTSConfig.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.exitMenuItem.setText(msgs.getString("FILE_EXIT"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RTSConfig.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText(msgs.getString("EDIT"));
        this.findMenuItem.setText("Item");
        this.findMenuItem.setText(msgs.getString("FIND_CODEPOINT"));
        this.findMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RTSConfig.this.findMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.findMenuItem);
        this.menuBar.add(this.editMenu);
        this.viewMenu.setText(msgs.getString("VIEW"));
        this.glyphMenuItem.setText(msgs.getString("VIEW_GLYPHS"));
        this.glyphMenuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RTSConfig.this.glyphMenuItemItemStateChanged(evt);
            }
        });
        this.viewMenu.add(this.glyphMenuItem);
        this.fontMenuItem.setText(msgs.getString("VIEW_FONT"));
        this.fontMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RTSConfig.this.fontMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.fontMenuItem);
        this.menuBar.add(this.viewMenu);
        this.toolsMenu.setText(msgs.getString("TOOLS"));
        this.configureModeMenuItem.setText(msgs.getString("TOOLS_SET_MODE"));
        this.configureModeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RTSConfig.this.configureModeMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.configureModeMenuItem);
        this.configureMenuItem.setText(msgs.getString("TOOLS_CONFIGURE"));
        this.configureMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RTSConfig.this.configureMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.configureMenuItem);
        this.toolsMenu.add(this.jSeparator1);
        this.restoreDefaultsMenuItem.setText(msgs.getString("TOOLS_RESTORE_DEFAULTS"));
        this.restoreDefaultsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RTSConfig.this.restoreDefaultsMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.restoreDefaultsMenuItem);
        this.menuBar.add(this.toolsMenu);
        this.helpMenu.setText(msgs.getString("HELP"));
        this.contentsMenuItem.setText(msgs.getString("HELP_CONTENTS"));
        this.contentsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RTSConfig.this.contentsMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.contentsMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(800, 500));
        this.setLocation((screenSize.width - 800) / 2, (screenSize.height - 500) / 2);
    }

    private void restoreDefaultsMenuItemActionPerformed(ActionEvent evt) {
        this.restoreDefaults();
    }

    private void configureModeMenuItemActionPerformed(ActionEvent evt) {
        if (this.configModeDlg.showDialog()) {
            int mode = this.configModeDlg.getMode();
            this.configMode = mode == 0 ? "0" : "1";
            this.configCompile.setMode(mode);
        }
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            this.editMenu.setEnabled(true);
        } else {
            this.editMenu.setEnabled(false);
        }
    }

    private void findMenuItemActionPerformed(ActionEvent evt) {
        int row;
        RTSConfigDataSorter model;
        JTable table;
        if (this.jTabbedPane1.getSelectedIndex() == 0) {
            table = this.jTable1;
            model = (RTSConfigDataSorter)this.jTable1.getModel();
        } else {
            table = this.jTable2;
            model = (RTSConfigDataSorter)this.jTable2.getModel();
        }
        if (this.findCodepoint.showDialog() && (row = model.find(this.findCodepoint.getText())) != -1) {
            table.setRowSelectionInterval(row, row);
            table.scrollRectToVisible(table.getCellRect(row, 0, true));
        }
    }

    private void contentsMenuItemActionPerformed(ActionEvent evt) {
        try {
            this.helpSystem.displayHelp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void configureMenuItemActionPerformed(ActionEvent evt) {
        boolean dataChanged = this.configCompile.performUpdate(this, this.model1.dataChanged() || this.model2.dataChanged(), false);
        this.model1.setDataChanged(dataChanged);
        this.model2.setDataChanged(dataChanged);
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        this.save(false);
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        if (this.fileChooser.showSaveDialog(this) == 0) {
            this.dataFile = this.fileChooser.getSelectedFile().getAbsolutePath();
            if (!this.dataFile.endsWith(".xml")) {
                this.dataFile = this.dataFile + ".xml";
            }
            this.save(false);
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        this.save(true);
        if (this.fileChooser.showOpenDialog(this) == 0) {
            this.dataFile = this.fileChooser.getSelectedFile().getAbsolutePath();
            this.init(this.dataFile);
        }
    }

    private void fontMenuItemActionPerformed(ActionEvent evt) {
        if (this.fontChooser.showDialog()) {
            this.setAppFont(this.fontChooser.getSelectedFont());
            this.fontName = this.fontChooser.getFontName();
            this.fontStyle = this.fontChooser.getFontStyle();
            this.fontSize = this.fontChooser.getFontSize();
        }
    }

    private void glyphMenuItemItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.showGlyphs = "true";
            this.displayGlyphs(this.jTable1, true);
            this.displayGlyphs(this.jTable2, true);
        } else {
            this.showGlyphs = "false";
            this.displayGlyphs(this.jTable1, false);
            this.displayGlyphs(this.jTable2, false);
        }
    }

    private void jTable1PropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("tableCellEditor") && this.model1.dataChanged()) {
            this.jTable1.repaint();
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.shutdown();
    }

    private void exitForm(WindowEvent evt) {
        this.shutdown();
    }

    public static void main(String[] args) {
        RTSLogger.getInstance();
        RTSLogger.sessionStart();
        new RTSConfig().setVisible(true);
    }
}

