/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rtsconfig;

import com.cognos.rtsconfig.RTSLogger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class RTSConversionData
extends AbstractTableModel {
    private static final ResourceBundle msgs = ResourceBundle.getBundle("rtsconfigmsgs", Locale.getDefault());
    private int rowCount = 0;
    private int[] map = null;
    private Vector rows = new Vector();
    private Vector references = new Vector();
    private boolean showGlyphs = false;
    private boolean dataChanged = false;

    private String getDisplayValueAt(int row, int col, boolean useMap) {
        String text = null;
        if (useMap && this.map != null) {
            row = this.map[row];
        }
        Vector rowData = (Vector)this.rows.elementAt(row);
        if (col == 0) {
            text = (String)rowData.elementAt(0);
            int pos = text.indexOf(" ");
            if (this.showGlyphs) {
                if (pos == -1) {
                    Integer value = Integer.decode("0x" + text.substring(2));
                    text = text + "  ( " + (char)value.intValue() + " )";
                }
            } else if (pos > 0) {
                text = text.substring(0, pos);
            }
        } else {
            text = (String)rowData.elementAt(col * 2 - 1);
        }
        return text;
    }

    private void saveNativeEntry(BufferedWriter out, Vector row, int idx) throws IOException {
        String val = (String)row.elementAt(idx);
        if (val.length() == 0) {
            return;
        }
        out.write("\t\t\t<native");
        boolean use = (Boolean)row.elementAt(idx + 1);
        if (use) {
            out.write(" selected=\"true\"");
        }
        out.write(">" + (String)row.elementAt(idx) + "</native>");
        out.newLine();
    }

    RTSConversionData() {
    }

    public boolean containsGlyphs() {
        return this.showGlyphs;
    }

    public boolean dataChanged() {
        return this.dataChanged;
    }

    public int find(String findValue) {
        int row;
        boolean found = false;
        for (row = 0; row < this.rowCount; ++row) {
            for (int col = 0; col < 4; ++col) {
                String value = this.getDisplayValueAt(row, col, true);
                int pos = value.indexOf(" ");
                if (pos > 0) {
                    value = value.substring(0, pos);
                }
                if (value.length() <= 0 || !value.equalsIgnoreCase(findValue)) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found) {
            row = -1;
        }
        return row;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int col) {
        String name = null;
        switch (col) {
            case 0: {
                name = msgs.getString("UNICODE");
                break;
            }
            case 1: {
                name = msgs.getString("SHIFTJIS1");
                break;
            }
            case 2: {
                name = msgs.getString("SHIFTJIS2");
                break;
            }
            case 3: {
                name = msgs.getString("SHIFTJIS3");
            }
        }
        return name;
    }

    public Vector getReference(int row) {
        if (this.map != null) {
            row = this.map[row];
        }
        return (Vector)this.references.elementAt(row);
    }

    public Vector getRow(int row) {
        if (this.map != null) {
            row = this.map[row];
        }
        return (Vector)this.rows.elementAt(row);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Object getValueAt(int row, int col) {
        String val = null;
        if (this.map != null) {
            row = this.map[row];
        }
        Vector rowData = (Vector)this.rows.elementAt(row);
        if (col < 0) {
            String text;
            val = text = (String)rowData.elementAt(-col * 2 - 1);
        } else if (col == 0) {
            String text = (String)rowData.elementAt(col * 2);
            int pos = text.indexOf(" ");
            if (this.showGlyphs) {
                if (pos == -1) {
                    Integer value = Integer.decode("0x" + text.substring(2));
                    text = text + "  ( " + (char)value.intValue() + " )";
                }
            } else if (pos > 0) {
                text = text.substring(0, pos);
            }
            val = text;
        } else {
            val = (String)rowData.elementAt(col * 2);
        }
        return val;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean canEdit = false;
        if (this.map != null) {
            row = this.map[row];
        }
        switch (col) {
            case 1: {
                if (((Boolean)this.getValueAt(row, 1)).booleanValue()) break;
                canEdit = true;
                break;
            }
            case 2: {
                if (((Boolean)this.getValueAt(row, 2)).booleanValue()) break;
                canEdit = true;
                break;
            }
            case 3: {
                if (((String)this.getRow(row).elementAt(5)).length() <= 0) break;
                canEdit = true;
            }
        }
        return canEdit;
    }

    public void load(Document document) {
        try {
            this.rowCount = 0;
            this.dataChanged = false;
            this.rows.removeAllElements();
            Element entries = (Element)document.selectSingleNode("//rtsconfig/conversion");
            Iterator it = entries.elementIterator();
            while (it.hasNext()) {
                Element item;
                int idx;
                ++this.rowCount;
                Element entry = (Element)it.next();
                Vector<Object> row = new Vector<Object>();
                String val = entry.element("unicode").getText();
                row.addElement(val);
                List list = entry.selectNodes("./native");
                for (idx = 0; idx < list.size(); ++idx) {
                    item = (Element)list.get(idx);
                    val = item.getText();
                    if (val.equalsIgnoreCase("0x0000")) {
                        val = new String();
                    }
                    row.addElement(val);
                    Attribute selected = item.attribute("selected");
                    if (selected == null || selected.getValue().equalsIgnoreCase("false")) {
                        row.addElement(new Boolean("false"));
                        continue;
                    }
                    row.addElement(new Boolean("true"));
                }
                for (idx = list.size(); idx < 3; ++idx) {
                    row.addElement(new String());
                    row.addElement(new Boolean("false"));
                }
                this.rows.addElement(row);
                Vector<Integer> referenceList = new Vector<Integer>();
                item = entry.element("references");
                list = item.selectNodes("./reference");
                for (idx = 0; idx < list.size(); ++idx) {
                    item = (Element)list.get(idx);
                    referenceList.addElement(new Integer(item.getText()));
                }
                this.references.addElement(referenceList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save(BufferedWriter out) throws IOException {
        out.write("\t<conversion>");
        out.newLine();
        for (int idx = 0; idx < this.rowCount; ++idx) {
            out.write("\t\t<entry id=\"" + (idx + 1) + "\">");
            out.newLine();
            Vector row = (Vector)this.rows.elementAt(idx);
            String val = (String)row.elementAt(0);
            int pos = val.indexOf(" ");
            if (pos > 0) {
                val = val.substring(0, pos);
            }
            out.write("\t\t\t<unicode>" + val + "</unicode>");
            out.newLine();
            this.saveNativeEntry(out, row, 1);
            this.saveNativeEntry(out, row, 3);
            this.saveNativeEntry(out, row, 5);
            out.write("\t\t\t<references>");
            out.newLine();
            Vector referenceList = (Vector)this.references.elementAt(idx);
            for (int idx2 = 0; idx2 < referenceList.size(); ++idx2) {
                out.write("\t\t\t\t<reference>" + ((Integer)referenceList.elementAt(idx2)).toString() + "</reference>");
                out.newLine();
            }
            out.write("\t\t\t</references>");
            out.newLine();
            out.write("\t\t</entry>");
            out.newLine();
        }
        out.write("\t</conversion>");
        out.newLine();
    }

    public void setDataChanged(boolean dataChanged) {
        this.dataChanged = dataChanged;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String nativeValue = null;
        if (this.map != null) {
            row = this.map[row];
        }
        Vector rowData = (Vector)this.rows.elementAt(row);
        this.dataChanged = true;
        switch (col) {
            case 0: {
                rowData.setElementAt(value, 0);
                break;
            }
            case 1: {
                if (!((Boolean)value).booleanValue()) break;
                nativeValue = (String)rowData.elementAt(1);
                rowData.setElementAt(new Boolean(true), 2);
                rowData.setElementAt(new Boolean(false), 4);
                rowData.setElementAt(new Boolean(false), 6);
                break;
            }
            case 2: {
                if (!((Boolean)value).booleanValue()) break;
                nativeValue = (String)rowData.elementAt(3);
                rowData.setElementAt(new Boolean(false), 2);
                rowData.setElementAt(new Boolean(true), 4);
                rowData.setElementAt(new Boolean(false), 6);
                break;
            }
            case 3: {
                if (!((Boolean)value).booleanValue()) break;
                nativeValue = (String)rowData.elementAt(5);
                rowData.setElementAt(new Boolean(false), 2);
                rowData.setElementAt(new Boolean(false), 4);
                rowData.setElementAt(new Boolean(true), 6);
            }
        }
        RTSLogger.getInstance();
        RTSLogger.conversionDataChange((String)rowData.elementAt(0), nativeValue);
    }

    public void showGlyphs(boolean val) {
        this.showGlyphs = val;
    }

    public void sort(int column, boolean ascending) {
        int row;
        Object[] sortValues = new SortValue[this.rowCount];
        for (row = 0; row < this.rowCount; ++row) {
            sortValues[row] = new SortValue();
            ((SortValue)sortValues[row]).row = row;
            ((SortValue)sortValues[row]).ascending = ascending;
            ((SortValue)sortValues[row]).columnValue = this.getDisplayValueAt(row, column, false);
        }
        Arrays.sort(sortValues);
        this.map = new int[this.rowCount];
        for (row = 0; row < this.rowCount; ++row) {
            this.map[row] = ((SortValue)sortValues[row]).row;
        }
    }

    private class SortValue
    implements Comparable {
        int row;
        boolean ascending;
        String columnValue;

        private SortValue() {
        }

        public int compareTo(Object obj) {
            if (this.ascending) {
                return this.columnValue.compareTo(((SortValue)obj).columnValue);
            }
            return ((SortValue)obj).columnValue.compareTo(this.columnValue);
        }
    }
}

