/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rtsconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RTSFontChooser
extends JDialog {
    private static final ResourceBundle msgs = ResourceBundle.getBundle("rtsconfigmsgs", Locale.getDefault());
    private static final String bold = msgs.getString("FONT_STYLE_BOLD");
    private static final String plain = msgs.getString("FONT_STYLE_PLAIN");
    private static final String italic = msgs.getString("FONT_STYLE_ITALIC");
    private boolean selectionOk;
    private static int nameIdx = -1;
    private static int styleIdx = -1;
    private static int sizeIdx = -1;
    private static String defaultName;
    private static String defaultStyle;
    private static Integer defaultSize;
    private static HashMap fontMap;
    private String fontDir = new String();
    private Vector names = new Vector();
    private String[] styles = new String[3];
    private Integer[] sizes = new Integer[16];
    private JButton jButton2;
    private JButton jButton1;
    private JList jList3;
    private Panel panel2;
    private JList jList2;
    private JList jList1;
    private Panel panel1;
    private JScrollPane jScrollPane3;
    private JLabel jLabel3;
    private JScrollPane jScrollPane2;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JLabel jLabel1;
    private JPanel jPanel3;
    private JPanel jPanel2;
    private JPanel jPanel1;

    private void setFont(Container container, Font font) {
        Component[] components = container.getComponents();
        for (int idx = 0; idx < components.length; ++idx) {
            components[idx].setFont(font);
            if (!(components[idx] instanceof Container)) continue;
            this.setFont((Container)components[idx], font);
        }
    }

    private void loadFontData() {
        String name;
        int idx;
        Vector<String> fontNames = new Vector<String>();
        boolean foundDefault = false;
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (idx = 0; idx < fonts.length; ++idx) {
            name = fonts[idx].getFontName();
            fontMap.put(name, fonts[idx]);
            fontNames.addElement(name);
            if (!name.equalsIgnoreCase(defaultName)) continue;
            foundDefault = true;
        }
        if (this.fontDir.length() > 0) {
            try {
                File userFonts = new File(this.fontDir);
                String[] fontnames = userFonts.list();
                for (idx = 0; idx < fontnames.length; ++idx) {
                    try {
                        String fontname = fontnames[idx];
                        if (!fontname.endsWith(".ttf")) continue;
                        File file = new File(this.fontDir + "/" + fontname);
                        FileInputStream in = new FileInputStream(file);
                        Font font = Font.createFont(0, in);
                        in.close();
                        name = font.getFontName();
                        if (fontMap.get(name) != null) continue;
                        fontMap.put(name, font);
                        fontNames.addElement(name);
                        if (!name.equalsIgnoreCase(defaultName)) continue;
                        foundDefault = true;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception userFonts) {
                // empty catch block
            }
        }
        if (!foundDefault) {
            defaultName = new Font(null).getFamily();
        }
        Object[] nameList = fontNames.toArray();
        Arrays.sort(nameList);
        for (idx = 0; idx < nameList.length; ++idx) {
            name = (String)nameList[idx];
            if (name.equalsIgnoreCase(defaultName) || name.equalsIgnoreCase(defaultName + ".plain")) {
                nameIdx = idx;
            }
            this.names.addElement(name);
        }
        this.styles[0] = plain;
        this.styles[1] = bold;
        this.styles[2] = italic;
        for (idx = 0; idx < 3; ++idx) {
            if (!this.styles[idx].equals(defaultStyle)) continue;
            styleIdx = idx;
            break;
        }
        this.sizes[0] = new Integer("8");
        this.sizes[1] = new Integer("9");
        this.sizes[2] = new Integer("10");
        this.sizes[3] = new Integer("11");
        this.sizes[4] = new Integer("12");
        this.sizes[5] = new Integer("14");
        this.sizes[6] = new Integer("16");
        this.sizes[7] = new Integer("18");
        this.sizes[8] = new Integer("20");
        this.sizes[9] = new Integer("22");
        this.sizes[10] = new Integer("24");
        this.sizes[11] = new Integer("26");
        this.sizes[12] = new Integer("28");
        this.sizes[13] = new Integer("36");
        this.sizes[14] = new Integer("48");
        this.sizes[15] = new Integer("72");
        for (idx = 0; idx < 16; ++idx) {
            if (!this.sizes[idx].equals(defaultSize)) continue;
            sizeIdx = idx;
            break;
        }
        this.jList1.setListData(this.names);
        this.jList2.setListData(this.styles);
        this.jList3.setListData(this.sizes);
        this.jList1.setSelectedIndex(nameIdx);
        this.jList2.setSelectedIndex(styleIdx);
        this.jList3.setSelectedIndex(sizeIdx);
    }

    public RTSFontChooser(Frame parent, String fontDir, String fontname, String fontstyle, String fontsize) {
        super(parent, true);
        this.fontDir = fontDir;
        defaultName = fontname;
        defaultStyle = fontstyle;
        defaultSize = new Integer(fontsize);
        this.initComponents();
    }

    @Override
    public void setFont(Font font) {
        this.setFont(this, font);
        this.pack();
    }

    private void initComponents() {
        this.panel1 = new Panel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jList3 = new JList();
        this.panel2 = new Panel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setTitle("");
        this.setTitle(msgs.getString("FONT_TITLE"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RTSFontChooser.this.closeDialog(evt);
            }
        });
        this.panel1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (c == '\n') {
                    RTSFontChooser.this.selectionOk = true;
                    RTSFontChooser.this.setVisible(false);
                    RTSFontChooser.this.dispose();
                } else if (c == '\u001b') {
                    RTSFontChooser.this.setVisible(false);
                    RTSFontChooser.this.dispose();
                }
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel1.setText(msgs.getString("FONT_NAME"));
        this.jPanel1.add((Component)this.jLabel1, "North");
        this.jScrollPane1.setViewportView(this.jList1);
        this.jPanel1.add((Component)this.jScrollPane1, "South");
        this.panel1.add(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jLabel2.setText(msgs.getString("FONT_STYLE"));
        this.jPanel2.add((Component)this.jLabel2, "North");
        this.jScrollPane2.setViewportView(this.jList2);
        this.jPanel2.add((Component)this.jScrollPane2, "South");
        this.panel1.add(this.jPanel2);
        this.jPanel3.setLayout(new BorderLayout());
        this.jLabel3.setText(msgs.getString("FONT_SIZE"));
        this.jPanel3.add((Component)this.jLabel3, "North");
        this.jScrollPane3.setViewportView(this.jList3);
        this.jPanel3.add((Component)this.jScrollPane3, "South");
        this.panel1.add(this.jPanel3);
        this.getContentPane().add((Component)this.panel1, "North");
        this.panel2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (c == '\n') {
                    RTSFontChooser.this.selectionOk = true;
                    RTSFontChooser.this.setVisible(false);
                    RTSFontChooser.this.dispose();
                } else if (c == '\u001b') {
                    RTSFontChooser.this.setVisible(false);
                    RTSFontChooser.this.dispose();
                }
            }
        });
        this.loadFontData();
        this.jButton1.setText(msgs.getString("OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RTSFontChooser.this.jButton1ActionPerformed(evt);
            }
        });
        this.panel2.add(this.jButton1);
        this.jButton2.setText(msgs.getString("CANCEL"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RTSFontChooser.this.jButton2ActionPerformed(evt);
            }
        });
        this.panel2.add(this.jButton2);
        this.getContentPane().add((Component)this.panel2, "South");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.selectionOk = true;
        this.setVisible(false);
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public String getFontName() {
        return defaultName;
    }

    public String getFontStyle() {
        return defaultStyle;
    }

    public String getFontSize() {
        return defaultSize.toString();
    }

    public boolean showDialog() {
        this.selectionOk = false;
        this.jList1.setSelectedIndex(nameIdx);
        this.jList2.setSelectedIndex(styleIdx);
        this.jList3.setSelectedIndex(sizeIdx);
        this.jList1.ensureIndexIsVisible(nameIdx);
        this.jList2.ensureIndexIsVisible(styleIdx);
        this.jList3.ensureIndexIsVisible(sizeIdx);
        this.show();
        return this.selectionOk;
    }

    public Font getSelectedFont() {
        nameIdx = this.jList1.getSelectedIndex();
        styleIdx = this.jList2.getSelectedIndex();
        sizeIdx = this.jList3.getSelectedIndex();
        defaultName = (String)this.names.elementAt(nameIdx);
        defaultStyle = this.styles[styleIdx];
        int style = defaultStyle.equals(bold) ? 1 : (defaultStyle.equals(italic) ? 2 : 0);
        defaultSize = this.sizes[sizeIdx];
        return ((Font)fontMap.get(defaultName)).deriveFont(style, defaultSize.floatValue());
    }

    static {
        fontMap = new HashMap();
    }
}

