/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rtsconfig;

import com.cognos.rtsconfig.RTSTransliterationData;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class RTSTransliterationComboBox
extends JComboBox
implements ActionListener,
TableCellEditor {
    private static final ResourceBundle msgs = ResourceBundle.getBundle("rtsconfigmsgs", Locale.getDefault());
    private Font font = null;
    private RTSTransliterationData data = null;
    private CellEditorListener listener = null;

    private String prepareForDisplay(String val) {
        String text = null;
        int pos = val.indexOf(" ");
        if (this.data.showGlyphs) {
            if (pos == -1) {
                Integer value = Integer.decode("0x" + val.substring(2));
                text = val + "  ( " + (char)value.intValue() + " )";
            }
        } else {
            text = pos > 0 ? val.substring(0, pos) : val;
        }
        return text;
    }

    public RTSTransliterationComboBox(RTSTransliterationData data, Font font) {
        this.data = data;
        this.font = font;
        this.addActionListener(this);
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        this.listener = listener;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.setFont(this.font);
        this.setBackground(table.getBackground());
        Vector rowInfo = this.data.getRow(row);
        this.addItem("<" + msgs.getString("NO_SUBSTITUTION") + ">");
        int idx = 0;
        int pos = 1;
        while (idx < rowInfo.size() - 1) {
            String displayVal = this.prepareForDisplay((String)rowInfo.elementAt(idx));
            this.addItem(displayVal);
            if (displayVal.equalsIgnoreCase((String)value)) {
                this.setSelectedIndex(pos);
            }
            idx += 2;
            ++pos;
        }
        return this;
    }

    @Override
    public void cancelCellEditing() {
        this.listener.editingCanceled(new ChangeEvent(this));
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        this.listener = null;
    }

    @Override
    public Object getCellEditorValue() {
        return this.getSelectedItem();
    }

    @Override
    public boolean stopCellEditing() {
        if (this.listener != null) {
            this.listener.editingStopped(new ChangeEvent(this));
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.stopCellEditing();
    }
}

