/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax;

import com.ibm.xml.xlxp.api.stax.XMLStreamWriterBase;
import com.ibm.xml.xlxp.api.stax.msg.StAXMessageProvider;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

final class DOMStreamWriterImpl
extends XMLStreamWriterBase {
    protected Node fCurrentNode;
    protected Node fRootNode;
    protected Node fNextSibling;
    protected Document fDocumentNode;
    private boolean fIsDOMLevel3;
    private HashMap fStoredNamespaceDecls = new HashMap();

    public DOMStreamWriterImpl(Node node, Node node2, boolean bl) throws XMLStreamException {
        this.setNodes(node, node2, bl);
    }

    public void setNodes(Node node, Node node2, boolean bl) throws XMLStreamException {
        if (node instanceof Document || node instanceof DocumentFragment || node instanceof Element) {
            try {
                this.fCurrentNode = this.fRootNode = node;
                this.fNextSibling = node2;
                this.fDocumentNode = node instanceof Document ? (Document)this.fRootNode : this.fCurrentNode.getOwnerDocument();
                this.fIsDOMLevel3 = this.fDocumentNode.getImplementation().hasFeature("Core", "3.0");
            }
            catch (DOMException dOMException) {
                StAXMessageProvider.throwXMLStreamException(dOMException);
            }
        } else {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 38));
        }
        this.fStoredNamespaceDecls.clear();
        this.reset(bl);
    }

    private void addChild(Node node) {
        if (this.fCurrentNode == this.fRootNode && this.fNextSibling != null) {
            this.fCurrentNode.insertBefore(node, this.fNextSibling);
        } else {
            this.fCurrentNode.appendChild(node);
        }
    }

    public void writeStartDocument() throws XMLStreamException {
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        if (this.fIsDOMLevel3 && this.fRootNode == this.fDocumentNode) {
            try {
                this.fDocumentNode.setXmlVersion(string);
            }
            catch (DOMException dOMException) {
                StAXMessageProvider.throwXMLStreamException(dOMException);
            }
        }
    }

    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.writeStartDocument(string2);
    }

    protected void handleStartElement(String string, String string2, String string3) throws XMLStreamException {
        try {
            String string4 = string == "" ? string2 : string + ":" + string2;
            Element element = this.fDocumentNode.createElementNS(string3, string4);
            this.addChild(element);
            this.fCurrentNode = element;
        }
        catch (DOMException dOMException) {
            StAXMessageProvider.throwXMLStreamException(dOMException);
        }
    }

    protected void handleNamespace(String string, String string2) throws XMLStreamException {
        this.fStoredNamespaceDecls.put(string, string2);
    }

    protected void finishStartElement() throws XMLStreamException {
        Iterator iterator = this.fStoredNamespaceDecls.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.fStoredNamespaceDecls.get(string);
            try {
                String string3 = string == null || string.equals("") ? "xmlns" : "xmlns:" + string;
                Attr attr = this.fDocumentNode.createAttributeNS("http://www.w3.org/2000/xmlns/", string3);
                attr.setValue(string2);
                ((Element)this.fCurrentNode).setAttributeNodeNS(attr);
            }
            catch (DOMException dOMException) {
                StAXMessageProvider.throwXMLStreamException(dOMException);
            }
        }
        this.fStoredNamespaceDecls.clear();
    }

    protected boolean atRootContext() {
        return this.fCurrentNode == this.fRootNode;
    }

    protected void handleEndElement() throws XMLStreamException {
        if (this.atRootContext()) {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 39));
        }
        this.fCurrentNode = this.fCurrentNode.getParentNode();
    }

    public void close() throws XMLStreamException {
        super.close();
        this.fCurrentNode = null;
        this.fDocumentNode = null;
        this.fRootNode = null;
        this.fNextSibling = null;
        this.fPoolableHelper.returnToPool();
    }

    protected void handleAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        try {
            String string5 = string.equals("") ? string3 : string + ":" + string3;
            Attr attr = this.fDocumentNode.createAttributeNS(string2, string5);
            attr.setValue(string4);
            ((Element)this.fCurrentNode).setAttributeNodeNS(attr);
        }
        catch (DOMException dOMException) {
            StAXMessageProvider.throwXMLStreamException(dOMException);
        }
    }

    public void writeComment(String string) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            Comment comment = this.fDocumentNode.createComment(string);
            this.addChild(comment);
        }
        catch (DOMException dOMException) {
            StAXMessageProvider.throwXMLStreamException(dOMException);
        }
    }

    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        this.checkFinishStartElement();
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 49));
        }
        if (string2 == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 50));
        }
        try {
            ProcessingInstruction processingInstruction = this.fDocumentNode.createProcessingInstruction(string, string2);
            this.addChild(processingInstruction);
        }
        catch (DOMException dOMException) {
            StAXMessageProvider.throwXMLStreamException(dOMException);
        }
    }

    public void writeCData(String string) throws XMLStreamException {
        this.checkFinishStartElement();
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 48));
        }
        try {
            CDATASection cDATASection = this.fDocumentNode.createCDATASection(string);
            this.addChild(cDATASection);
        }
        catch (DOMException dOMException) {
            StAXMessageProvider.throwXMLStreamException(dOMException);
        }
    }

    public void writeDTD(String string) throws XMLStreamException {
        if (this.fDocumentNode == this.fRootNode) {
            super.parseDTD(string);
            if (this.fDTDRoot != null) {
                try {
                    DocumentType documentType = this.fDocumentNode.getImplementation().createDocumentType(this.fDTDRoot, this.fDTDPubId, this.fDTDSysId);
                    DocumentType documentType2 = this.fDocumentNode.getDoctype();
                    if (documentType2 != null) {
                        this.fDocumentNode.replaceChild(documentType, documentType2);
                    } else {
                        this.fDocumentNode.insertBefore(documentType, this.fDocumentNode.getFirstChild());
                    }
                }
                catch (DOMException dOMException) {
                    StAXMessageProvider.throwXMLStreamException(dOMException);
                }
            }
        }
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            EntityReference entityReference = this.fDocumentNode.createEntityReference(string);
            this.addChild(entityReference);
        }
        catch (DOMException dOMException) {
            StAXMessageProvider.throwXMLStreamException(dOMException);
        }
    }

    public void writeCharacters(String string) throws XMLStreamException {
        this.checkFinishStartElement();
        try {
            Text text = this.fDocumentNode.createTextNode(string);
            this.addChild(text);
        }
        catch (DOMException dOMException) {
            StAXMessageProvider.throwXMLStreamException(dOMException);
        }
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.writeCharacters(new String(cArray, n, n2));
    }
}

