/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.util.encoding;

import com.ibm.xml.xlxp.api.util.SimpleParsedEntityFactory;
import java.io.IOException;
import java.io.InputStream;

public final class RewindableInputStream
extends InputStream {
    private static final int INITIAL_BYTE_COUNT = 4096;
    private SimpleParsedEntityFactory fFactory;
    private InputStream fInputStream;
    private byte[] fData;
    private int fStartOffset;
    private int fEndOffset;
    private int fOffset;
    private int fLength;
    private int fMark;

    public RewindableInputStream(SimpleParsedEntityFactory simpleParsedEntityFactory, InputStream inputStream) {
        this.fFactory = simpleParsedEntityFactory;
        this.fInputStream = inputStream;
        this.fData = new byte[4096];
        this.fEndOffset = -1;
    }

    public void setStream(InputStream inputStream) {
        this.fInputStream = inputStream;
        this.fStartOffset = 0;
        this.fEndOffset = -1;
        this.fOffset = 0;
        this.fLength = 0;
        this.fMark = 0;
    }

    public void setStartOffset(int n) {
        this.fStartOffset = n;
    }

    public void rewind() {
        this.fOffset = this.fStartOffset;
    }

    public int read() throws IOException {
        if (this.fOffset < this.fLength) {
            return this.fData[this.fOffset++] & 0xFF;
        }
        if (this.fOffset == this.fEndOffset) {
            return -1;
        }
        return this.slowRead();
    }

    private int slowRead() throws IOException {
        int n;
        int n2;
        if (this.fOffset == this.fData.length) {
            byte[] byArray = new byte[this.fOffset << 1];
            System.arraycopy(this.fData, 0, byArray, 0, this.fOffset);
            this.fData = byArray;
        }
        if ((n2 = this.fInputStream.available()) == 0 || n2 >= this.fData.length - this.fOffset) {
            n2 = this.fData.length - this.fOffset;
        }
        if ((n = this.fInputStream.read(this.fData, this.fOffset, n2)) == -1) {
            this.fEndOffset = this.fOffset;
            return -1;
        }
        this.fLength += n;
        return this.fData[this.fOffset++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = this.fLength - this.fOffset;
        if (n4 == 0) {
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            return this.fInputStream.read(byArray, n, n2);
        }
        if (n2 < n4) {
            if (n2 <= 0) {
                return 0;
            }
            n3 = n2;
        } else {
            n3 = n4;
        }
        if (byArray != null) {
            System.arraycopy(this.fData, this.fOffset, byArray, n, n3);
        }
        this.fOffset += n3;
        if (n3 == n2 || this.fOffset == this.fEndOffset || this.fInputStream.available() == 0) {
            return n3;
        }
        int n5 = this.fInputStream.read(byArray, n += n3, n2 -= n3);
        if (n5 == -1) {
            this.fEndOffset = this.fOffset;
            return n3;
        }
        return n3 + n5;
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        int n = this.fLength - this.fOffset;
        if (n == 0) {
            if (this.fOffset == this.fEndOffset) {
                return 0L;
            }
            return this.fInputStream.skip(l);
        }
        if (l <= (long)n) {
            this.fOffset = (int)((long)this.fOffset + l);
            return l;
        }
        this.fOffset += n;
        if (this.fOffset == this.fEndOffset) {
            return n;
        }
        return this.fInputStream.skip(l -= (long)n) + (long)n;
    }

    public int available() throws IOException {
        int n = this.fLength - this.fOffset;
        if (n == 0) {
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            return this.fInputStream.available();
        }
        if (this.fLength == this.fEndOffset) {
            return n;
        }
        return this.fInputStream.available() + n;
    }

    public void mark(int n) {
        this.fMark = this.fOffset;
    }

    public void reset() {
        this.fOffset = this.fMark;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        if (this.fInputStream != null) {
            this.fInputStream.close();
            this.fInputStream = null;
        }
        this.fFactory.releaseRewindableInputStream(this);
    }
}

