/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.httpclient.ssl.X509HostnameVerifier;
import org.apache.commons.httpclient.util.Immutable;
import org.apache.commons.httpclient.util.InetAddressUtils;

public abstract class AbstractVerifier
implements X509HostnameVerifier,
Immutable {
    private static final String[] BAD_COUNTRY_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};
    static /* synthetic */ Class class$org$apache$commons$httpclient$ssl$AbstractVerifier;

    public final void verify(String host, SSLSocket ssl) throws IOException {
        if (host == null) {
            throw new NullPointerException("host to verify is null");
        }
        SSLSession session = ssl.getSession();
        if (session == null) {
            InputStream in = ssl.getInputStream();
            in.available();
            session = ssl.getSession();
            if (session == null) {
                ssl.startHandshake();
                session = ssl.getSession();
            }
        }
        Certificate[] certs = session.getPeerCertificates();
        X509Certificate x509 = (X509Certificate)certs[0];
        this.verify(host, x509);
    }

    public final boolean verify(String host, SSLSession session) {
        try {
            Certificate[] certs = session.getPeerCertificates();
            X509Certificate x509 = (X509Certificate)certs[0];
            this.verify(host, x509);
            return true;
        }
        catch (SSLException e) {
            return false;
        }
    }

    public final void verify(String host, X509Certificate cert) throws SSLException {
        String[] cns = AbstractVerifier.getCNs(cert);
        String[] subjectAlts = AbstractVerifier.getSubjectAlts(cert, host);
        this.verify(host, cns, subjectAlts);
    }

    public final void verify(String host, String[] cns, String[] subjectAlts, boolean strictWithSubDomains) throws SSLException {
        LinkedList<String> names = new LinkedList<String>();
        if (cns != null && cns.length > 0 && cns[0] != null) {
            names.add(cns[0]);
        }
        if (subjectAlts != null) {
            for (int sNdx = 0; sNdx < subjectAlts.length; ++sNdx) {
                String subjectAlt = subjectAlts[sNdx];
                if (subjectAlt == null) continue;
                names.add(subjectAlt);
            }
        }
        if (names.isEmpty()) {
            String msg = "Certificate for <" + host + "> doesn't contain CN or DNS subjectAlt";
            throw new SSLException(msg);
        }
        StringBuffer buf = new StringBuffer();
        String hostName = host.trim().toLowerCase(Locale.ENGLISH);
        boolean match = false;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String[] parts;
            boolean doWildcard;
            String cn = (String)it.next();
            cn = cn.toLowerCase(Locale.ENGLISH);
            buf.append(" <");
            buf.append(cn);
            buf.append('>');
            if (it.hasNext()) {
                buf.append(" OR");
            }
            boolean bl = doWildcard = (parts = cn.split("\\.")).length >= 3 && parts[0].endsWith("*") && AbstractVerifier.acceptableCountryWildcard(cn) && !AbstractVerifier.isIPAddress(host);
            if (doWildcard) {
                if (parts[0].length() > 1) {
                    String prefix = parts[0].substring(0, parts.length - 2);
                    String suffix = cn.substring(parts[0].length());
                    String hostSuffix = hostName.substring(prefix.length());
                    match = hostName.startsWith(prefix) && hostSuffix.endsWith(suffix);
                } else {
                    match = hostName.endsWith(cn.substring(1));
                }
                if (match && strictWithSubDomains) {
                    match = AbstractVerifier.countDots(hostName) == AbstractVerifier.countDots(cn);
                }
            } else {
                match = hostName.equals(cn);
            }
            if (!match) continue;
            break;
        }
        if (!match) {
            throw new SSLException("hostname in certificate didn't match: <" + host + "> !=" + buf);
        }
    }

    public static boolean acceptableCountryWildcard(String cn) {
        String[] parts = cn.split("\\.");
        if (parts.length != 3 || parts[2].length() != 2) {
            return true;
        }
        return Arrays.binarySearch(BAD_COUNTRY_2LDS, parts[1]) < 0;
    }

    public static String[] getCNs(X509Certificate cert) {
        try {
            String subjectPrincipal = cert.getSubjectX500Principal().getName("RFC2253");
            LinkedList<String> cnList = new LinkedList<String>();
            LdapName subjectDN = new LdapName(subjectPrincipal);
            List<Rdn> rdnList = subjectDN.getRdns();
            for (int i = 0; i < rdnList.size(); ++i) {
                Rdn rds = rdnList.get(i);
                Attributes attributes = rds.toAttributes();
                Attribute cn = attributes.get("cn");
                if (cn == null) continue;
                try {
                    Object value = cn.get();
                    if (value == null) continue;
                    cnList.add(value.toString());
                    continue;
                }
                catch (NoSuchElementException ignore) {
                    continue;
                }
                catch (NamingException ignore) {
                    // empty catch block
                }
            }
            if (!cnList.isEmpty()) {
                return cnList.toArray(new String[cnList.size()]);
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return null;
    }

    private static String[] getSubjectAlts(X509Certificate cert, String hostname) {
        int subjectType = AbstractVerifier.isIPAddress(hostname) ? 7 : 2;
        LinkedList<String> subjectAltList = new LinkedList<String>();
        Collection<List<?>> c = null;
        try {
            c = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException cpe) {
            Logger.getLogger((class$org$apache$commons$httpclient$ssl$AbstractVerifier == null ? (class$org$apache$commons$httpclient$ssl$AbstractVerifier = AbstractVerifier.class$("org.apache.commons.httpclient.ssl.AbstractVerifier")) : class$org$apache$commons$httpclient$ssl$AbstractVerifier).getName()).log(Level.FINE, "Error parsing certificate.", cpe);
        }
        if (c != null) {
            Iterator<List<?>> i = c.iterator();
            while (i.hasNext()) {
                List<?> list = i.next();
                int type = (Integer)list.get(0);
                if (type != subjectType) continue;
                String s = (String)list.get(1);
                subjectAltList.add(s);
            }
        }
        if (!subjectAltList.isEmpty()) {
            String[] subjectAlts = new String[subjectAltList.size()];
            subjectAltList.toArray(subjectAlts);
            return subjectAlts;
        }
        return null;
    }

    public static String[] getDNSSubjectAlts(X509Certificate cert) {
        return AbstractVerifier.getSubjectAlts(cert, null);
    }

    public static int countDots(String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }

    private static boolean isIPAddress(String hostname) {
        return hostname != null && (InetAddressUtils.isIPv4Address(hostname) || InetAddressUtils.isIPv6Address(hostname));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Arrays.sort(BAD_COUNTRY_2LDS);
    }
}

