/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.pdk.osgi.impl;

import com.cognos.pogo.config.XMLConfigurator;
import com.cognos.pogo.monitoring.jmx.utils.PogoMBeanRemover;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.PogoConfigException;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.services.DispatcherServices;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.pdk.osgi.DispatcherServicesProvider;
import com.ibm.cognos.pogo.pdk.osgi.XmlServiceProvider;
import java.io.InputStream;

public class XmlServiceHookup {
    private static final PogoLogger log = PogoLogger.getLogger();
    private PogoMBeanRemover pogoMBeanRemover = new PogoMBeanRemover();
    private DispatcherServicesProvider dispatcherServicesProvider;

    public void setDispatcherServicesProvider(DispatcherServicesProvider dispatcherServicesProvider) {
        this.dispatcherServicesProvider = dispatcherServicesProvider;
    }

    public void addXmlServiceProvider(XmlServiceProvider provider) {
        XMLConfigurator configurator = new XMLConfigurator(provider.getClassLoader());
        InputStream is = provider.getInputStream();
        String serviceDescriptionName = provider.getServiceDescriptionName();
        try {
            Service service = configurator.configureFile(this.getPogoEngine(), is, serviceDescriptionName);
            this.startservice(service);
            log.debug(new Object[]{"Starting service: ", service.getName()});
        }
        catch (PogoConfigException e) {
            log.error("Unable to start service " + provider.getServiceName(), (Throwable)e);
        }
    }

    private void startservice(Service service) {
        Configuration configuration = this.getConfiguration();
        this.getDispatcherServices().startInitialService(service, this.getPogoEngine(), configuration);
    }

    public void removeXmlServiceProvider(XmlServiceProvider provider) {
        String serviceName = provider.getServiceName();
        Service service = this.getDispatcherServices().getService(serviceName);
        this.stopservice(service);
        this.getPogoEngine().removeService(serviceName);
        this.removeMBeans(serviceName);
        log.debug(new Object[]{"Stopping service: ", service.getName()});
    }

    private void removeMBeans(String serviceName) {
        this.pogoMBeanRemover.removeService(serviceName);
    }

    private void stopservice(Service service) {
        service.stop();
    }

    private DispatcherServices getDispatcherServices() {
        return this.dispatcherServicesProvider.getDispatcherServices();
    }

    private PogoEngine getPogoEngine() {
        return this.dispatcherServicesProvider.getPogoEngine();
    }

    private Configuration getConfiguration() {
        return this.dispatcherServicesProvider.getConfiguration();
    }
}

