/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer;

import com.cognos.cps.common.io.CharArrayReaderWriter;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.CookieUtils;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.cps.common.utils.XMLUtils;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.helpers.WSDLLocatorImpl;
import com.cognos.cps.services.wsrp.v1.WSRPService;
import com.cognos.cps.services.wsrp.v1.intf.WSRP_v1_Markup_PortType;
import com.cognos.cps.services.wsrp.v1.intf.WSRP_v1_Registration_PortType;
import com.cognos.cps.services.wsrp.v1.intf.WSRP_v1_ServiceDescription_PortType;
import com.cognos.cps.services.wsrp.v1.types.BlockingInteractionResponse;
import com.cognos.cps.services.wsrp.v1.types.CacheControl;
import com.cognos.cps.services.wsrp.v1.types.ClientData;
import com.cognos.cps.services.wsrp.v1.types.CookieProtocol;
import com.cognos.cps.services.wsrp.v1.types.Extension;
import com.cognos.cps.services.wsrp.v1.types.GetMarkup;
import com.cognos.cps.services.wsrp.v1.types.GetServiceDescription;
import com.cognos.cps.services.wsrp.v1.types.InitCookie;
import com.cognos.cps.services.wsrp.v1.types.InteractionParams;
import com.cognos.cps.services.wsrp.v1.types.InvalidCookieFault;
import com.cognos.cps.services.wsrp.v1.types.MarkupContext;
import com.cognos.cps.services.wsrp.v1.types.MarkupParams;
import com.cognos.cps.services.wsrp.v1.types.MarkupResponse;
import com.cognos.cps.services.wsrp.v1.types.MarkupType;
import com.cognos.cps.services.wsrp.v1.types.PerformBlockingInteraction;
import com.cognos.cps.services.wsrp.v1.types.PortletContext;
import com.cognos.cps.services.wsrp.v1.types.PortletDescription;
import com.cognos.cps.services.wsrp.v1.types.RegistrationContext;
import com.cognos.cps.services.wsrp.v1.types.RegistrationData;
import com.cognos.cps.services.wsrp.v1.types.RuntimeContext;
import com.cognos.cps.services.wsrp.v1.types.ServiceDescription;
import com.cognos.cps.services.wsrp.v1.types.SessionContext;
import com.cognos.cps.services.wsrp.v1.types.StateChange;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import com.cognos.cps.services.wsrp.v1.types.UpdateResponse;
import com.cognos.cps.wsrp.consumer.CSSClassSubstituter;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionException;
import com.cognos.cps.wsrp.consumer.CacheHandler;
import com.cognos.cps.wsrp.consumer.CachedMarkup;
import com.cognos.cps.wsrp.consumer.ConsumerException;
import com.cognos.cps.wsrp.consumer.HttpSOAPConnection;
import com.cognos.cps.wsrp.consumer.ObjectHandler;
import com.cognos.cps.wsrp.consumer.PropylaealetSession;
import com.cognos.cps.wsrp.consumer.RequestContext;
import com.cognos.cps.wsrp.consumer.RequestContextDefault;
import com.cognos.cps.wsrp.consumer.URLRewriteException;
import com.cognos.cps.wsrp.consumer.URLRewriter;
import com.cognos.cps.wsrp.consumer.helpers.ExtensionHelper;
import com.cognos.cps.wsrp.consumer.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.wsdl.xml.WSDLLocator;
import org.w3c.dom.Element;

public class RequestHelper {
    private static final String PORTLET_SESSION_ID = "WSRP_PORTLET_SESSION_ID";
    private static final int REWRITE_BUFFER_SIZE = 2048;
    private final ServiceLogger m_logger;
    private final WSRPService m_service;
    private final String m_initialPortletHandle;
    private final String m_transientCookieKey;
    private final String m_portletContextHashkey;
    private CookieProtocol m_requiresInitCookie = null;
    private boolean m_supportCpsConfigMode = false;
    private String m_initCookieTrackingIdKey;
    private static RegistrationContext m_registrationContext = null;

    private RequestHelper() {
        this.m_service = null;
        this.m_logger = null;
        this.m_initialPortletHandle = null;
        this.m_transientCookieKey = null;
        this.m_initCookieTrackingIdKey = null;
        this.m_portletContextHashkey = null;
    }

    public RequestHelper(RequestContext requestContext, URL wsdlURL, String initialPortletHandle) throws ConsumerException, ServiceException {
        this.m_logger = requestContext.getLogger();
        try {
            this.m_service = new WSRPService((WSDLLocator)new WSDLLocatorImpl(requestContext.createHttpURLConnection(wsdlURL), this.m_logger), this.m_logger);
        }
        catch (IOException e) {
            throw new ConsumerException("cps.consumer.failedtocreatewsdlconnection", new String[]{wsdlURL.toExternalForm()}, e);
        }
        this.m_initialPortletHandle = initialPortletHandle;
        this.m_logger.debug("portlethandle is" + initialPortletHandle);
        String url = wsdlURL.toExternalForm();
        this.m_portletContextHashkey = url + this.m_initialPortletHandle;
        this.m_transientCookieKey = RequestHelper.createCookieKey(url);
        this.m_initCookieTrackingIdKey = url + "initCookieTrackingId";
        this.initialize(requestContext);
    }

    public static String createCookieKey(String key) {
        return key + "Cookies";
    }

    private void initialize(RequestContext requestContext) throws ConsumerException, ServiceException {
        this.m_logger.debug("in intialize");
        PortletDescription portlet = null;
        ServiceDescription serviceDescription = this.getServiceDescription(requestContext);
        PortletDescription[] portlets = serviceDescription.getOfferedPortlets();
        if (this.m_initialPortletHandle != null && portlets != null) {
            for (int p = 0; p < portlets.length; ++p) {
                if (!this.m_initialPortletHandle.equals(portlets[p].getPortletHandle())) continue;
                portlet = portlets[p];
                MarkupType[] markupTypes = portlet.getMarkupTypes();
                for (int mt = 0; mt < markupTypes.length; ++mt) {
                    String[] modes = markupTypes[mt].getModes();
                    if (modes == null) continue;
                    for (int m = 0; m < modes.length; ++m) {
                        if (!"cps:config".equals(modes[m])) continue;
                        this.m_supportCpsConfigMode = true;
                    }
                }
                break;
            }
        }
        if (portlet == null) {
            throw new ConsumerException("cps.consumer.portletdoesnotexist", new String[]{this.m_initialPortletHandle, this.m_service.getWSDLDocumentLocation()});
        }
        this.m_requiresInitCookie = serviceDescription.getRequiresInitCookie();
    }

    public ServiceDescription getServiceDescription(RequestContext requestContext) throws ConsumerException, ServiceException {
        RegistrationContext registrationContext = this.getRegistrationContext(requestContext);
        GetServiceDescription getServiceDescription = new GetServiceDescription();
        getServiceDescription.setRegistrationContext(registrationContext);
        WSRP_v1_ServiceDescription_PortType serviceDescriptionPortType = this.m_service.getServiceDescriptionPortType();
        HttpSOAPConnection httpSOAPConnection = requestContext.createHttpSOAPConnection();
        ((IContext)serviceDescriptionPortType).setProperty("SOAPConnection", (Object)httpSOAPConnection);
        try {
            return serviceDescriptionPortType.getServiceDescription(getServiceDescription);
        }
        catch (Exception e) {
            throw new ConsumerException("cps.consumer.servicedescriptioninterfaceopfailed", new String[]{"getServiceDescription"}, e);
        }
    }

    public MarkupResponse getMarkup(RequestContext requestContext) throws ConsumerException, ServiceException {
        this.m_logger.debug("[" + this.getClass().getName() + "]" + " getMarkup() called.");
        long start1 = 0L;
        if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
            start1 = System.currentTimeMillis();
        }
        ObjectHandler objectHandler = requestContext.getObjectHandler();
        PortletContext portletContext = objectHandler.getPortletContext(this.m_portletContextHashkey, this.m_initialPortletHandle);
        MarkupParams markupParams = this.createMarkupParams(requestContext);
        CacheHandler cacheHandler = requestContext.getCacheHandler();
        CachedMarkup cachedMarkup = cacheHandler.getCachedMarkup(this.generateHashKey(requestContext));
        if (cachedMarkup != null && cachedMarkup.getExpires() > System.currentTimeMillis()) {
            this.m_logger.debug("Cached markup has not yet expired, using cached markup.");
            long start = 0L;
            if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
                start = System.currentTimeMillis();
            }
            try {
                String cachedMarkupString = cachedMarkup.getMarkupString();
                this.rewriteMarkup(cachedMarkupString, requestContext);
            }
            catch (IOException e) {
                throw new ConsumerException("cps.consumer.writecachedmarkupfailed", e);
            }
            if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
                long end = System.currentTimeMillis();
                this.m_logger.info("write cached markup took: " + (end - start) + "ms.");
            }
            return null;
        }
        GetMarkup getMarkup = TypeFactory.newInstance().createGetMarkup();
        getMarkup.setMarkupParams(markupParams);
        getMarkup.setPortletContext(portletContext);
        getMarkup.setRegistrationContext(this.getRegistrationContext(requestContext));
        RuntimeContext runtimeContext = objectHandler.createRuntimeContext(this.m_portletContextHashkey);
        String sessionId = (String)requestContext.getSession().fetchPropertyByName(PORTLET_SESSION_ID);
        if (sessionId != null) {
            if (runtimeContext == null) {
                runtimeContext = TypeFactory.newInstance().createRuntimeContext();
            }
            runtimeContext.setSessionID(sessionId);
        }
        getMarkup.setRuntimeContext(runtimeContext);
        getMarkup.setUserContext(objectHandler.createUserContext(this.m_portletContextHashkey));
        if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
            long end1 = System.currentTimeMillis();
            this.m_logger.info("Create objects for getMarkup operation took: " + (end1 - start1) + "ms.");
        }
        if (cachedMarkup != null && cachedMarkup.getCacheControl() != null) {
            markupParams.setValidateTag(cachedMarkup.getCacheControl().getValidateTag());
        }
        WSRP_v1_Markup_PortType markupPortType = this.m_service.getMarkupPortType();
        HttpSOAPConnection httpSOAPConnection = requestContext.createHttpSOAPConnection();
        httpSOAPConnection.addRequestCookies(this.getTransientCookies(requestContext, false));
        ((IContext)markupPortType).setProperty("SOAPConnection", (Object)httpSOAPConnection);
        Extension executionState = null;
        MarkupResponse markupResponse = null;
        PropylaealetSession session = requestContext.getSession();
        try {
            long start = 0L;
            if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
                start = System.currentTimeMillis();
            }
            executionState = this.createApplicationStateExtension(session);
            getMarkup.getMarkupParams().addExtensions(executionState);
            markupResponse = markupPortType.getMarkup(getMarkup);
            if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
                long end = System.currentTimeMillis();
                this.m_logger.info("getMarkup operation took: " + (end - start) + "ms.");
            }
        }
        catch (InvalidCookieFault e) {
            this.m_logger.debug("InvalidCookieFault received, trying again.");
            httpSOAPConnection.setRequestCookies(this.getTransientCookies(requestContext, true));
            try {
                if (executionState != null) {
                    getMarkup.getMarkupParams().removeExtensions(executionState);
                }
                getMarkup.getMarkupParams().addExtensions(this.createApplicationStateExtension(session));
                markupResponse = markupPortType.getMarkup(getMarkup);
            }
            catch (Exception ee) {
                throw new ConsumerException("cps.consumer.markupinterfaceopfailed", new String[]{"getMarkup"}, ee);
            }
        }
        catch (Exception e) {
            throw new ConsumerException("cps.consumer.markupinterfaceopfailed", new String[]{"getMarkup"}, e);
        }
        if (markupResponse != null) {
            SessionContext sessionContext = markupResponse.getSessionContext();
            if (sessionContext != null && (sessionId = sessionContext.getSessionID()) != null) {
                requestContext.getSession().applyPropertyByName(PORTLET_SESSION_ID, sessionId);
            }
            this.processMarkupContext(requestContext, markupResponse.getMarkupContext());
        }
        return markupResponse;
    }

    private Extension createApplicationStateExtension(PropylaealetSession session) {
        String applicationCookieId = (String)session.fetchPropertyByNameAndScope(this.m_initCookieTrackingIdKey, 9);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<cps:applicationState xmlns:cps=\"http://developer.cognos.com/schemas/cps/asm/objects/1/\">");
        buffer.append("<cps:cookieSessionId>");
        EncodingUtils.xmlEncode((String)applicationCookieId, (StringBuffer)buffer);
        buffer.append("</cps:cookieSessionId>");
        buffer.append("</cps:applicationState>");
        return ExtensionHelper.createExtension(buffer.toString());
    }

    public BlockingInteractionResponse performBlockingInteraction(RequestContext requestContext) throws ConsumerException, ServiceException {
        UpdateResponse updateResponse;
        this.m_logger.debug("[" + this.getClass().getName() + "]" + " performBlockingInteraction() called.");
        ObjectHandler objectHandler = requestContext.getObjectHandler();
        PerformBlockingInteraction performBlockingInteraction = TypeFactory.newInstance().createPerformBlockingInteraction();
        performBlockingInteraction.setRegistrationContext(this.getRegistrationContext(requestContext));
        PortletContext portletContext = objectHandler.getPortletContext(this.m_portletContextHashkey, this.m_initialPortletHandle);
        performBlockingInteraction.setPortletContext(portletContext);
        RuntimeContext runtimeContext = objectHandler.createRuntimeContext(this.m_portletContextHashkey);
        String sessionId = (String)requestContext.getSession().fetchPropertyByName(PORTLET_SESSION_ID);
        if (sessionId != null) {
            if (runtimeContext == null) {
                runtimeContext = TypeFactory.newInstance().createRuntimeContext();
            }
            runtimeContext.setSessionID(sessionId);
        }
        performBlockingInteraction.setRuntimeContext(runtimeContext);
        MarkupParams markupParams = this.createMarkupParams(requestContext);
        performBlockingInteraction.setMarkupParams(markupParams);
        CacheHandler cacheHandler = requestContext.getCacheHandler();
        CachedMarkup cachedMarkup = cacheHandler.getCachedMarkup(RequestHelper.generateHashKey(portletContext, markupParams));
        if (cachedMarkup != null && cachedMarkup.getCacheControl() != null) {
            performBlockingInteraction.getMarkupParams().setValidateTag(cachedMarkup.getCacheControl().getValidateTag());
        }
        InteractionParams interactionParams = objectHandler.createInteractionParams(this.m_portletContextHashkey);
        performBlockingInteraction.setInteractionParams(interactionParams);
        WSRP_v1_Markup_PortType markupPortType = this.m_service.getMarkupPortType();
        HttpSOAPConnection httpSOAPConnection = requestContext.createHttpSOAPConnection();
        httpSOAPConnection.addRequestCookies(this.getTransientCookies(requestContext, false));
        ((IContext)markupPortType).setProperty("SOAPConnection", (Object)httpSOAPConnection);
        BlockingInteractionResponse blockingInteractionResponse = null;
        Extension executionState = null;
        PropylaealetSession session = requestContext.getSession();
        try {
            long start = 0L;
            if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
                start = System.currentTimeMillis();
            }
            executionState = this.createApplicationStateExtension(session);
            performBlockingInteraction.getMarkupParams().addExtensions(executionState);
            blockingInteractionResponse = markupPortType.performBlockingInteraction(performBlockingInteraction);
            if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
                long end = System.currentTimeMillis();
                this.m_logger.info("performBlockingInteraction operation took: " + (end - start) + "ms.");
            }
        }
        catch (InvalidCookieFault e) {
            this.m_logger.debug("InvalidCookieFault received, trying again.");
            httpSOAPConnection.setRequestCookies(this.getTransientCookies(requestContext, true));
            try {
                if (executionState != null) {
                    performBlockingInteraction.getMarkupParams().removeExtensions(executionState);
                }
                performBlockingInteraction.getMarkupParams().addExtensions(this.createApplicationStateExtension(session));
                blockingInteractionResponse = markupPortType.performBlockingInteraction(performBlockingInteraction);
            }
            catch (Exception ee) {
                throw new ConsumerException("cps.consumer.markupinterfaceopfailed", new String[]{"performBlockingInteraction"}, ee);
            }
        }
        catch (Exception e) {
            throw new ConsumerException("cps.consumer.markupinterfaceopfailed", new String[]{"performBlockingInteraction"}, e);
        }
        if (interactionParams.getPortletStateChange().equals(StateChange.READWRITE) && (updateResponse = blockingInteractionResponse.getUpdateResponse()) != null && updateResponse.getPortletContext() != null) {
            objectHandler.storePortletContext(this.m_portletContextHashkey, updateResponse.getPortletContext());
            this.m_logger.info("Invalidating cached markup.");
            requestContext.getCacheHandler().invalidateCachedMarkup();
        }
        return blockingInteractionResponse;
    }

    public void processMarkupContext(RequestContext requestContext, MarkupContext markupContext) throws ConsumerException {
        String hashkey = this.generateHashKey(requestContext);
        CacheHandler cacheHandler = requestContext.getCacheHandler();
        CachedMarkup cachedMarkup = cacheHandler.getCachedMarkup(hashkey);
        try {
            if (markupContext.getUseCachedMarkup()) {
                CacheControl cacheControl;
                this.m_logger.info("Producer request to use cached markup, using cached markup.");
                if (cachedMarkup == null) {
                    throw new ConsumerException("cps.wsrp.helper.nocachedmarkup");
                }
                long start = 0L;
                if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
                    start = System.currentTimeMillis();
                }
                this.rewriteMarkup(cachedMarkup.getMarkupString(), requestContext);
                if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
                    long end = System.currentTimeMillis();
                    this.m_logger.info("Write cached markup took: " + (end - start) + "ms.");
                }
                if ((cacheControl = markupContext.getCacheControl()) != null) {
                    cachedMarkup.setCacheControl(cacheControl);
                }
                cachedMarkup.updateExpires();
            } else {
                CacheControl cacheControl = markupContext.getCacheControl();
                if (cacheControl != null) {
                    this.m_logger.info("Saving cached markup.");
                    cachedMarkup = new CachedMarkup(cacheControl, markupContext.getMarkupString());
                    cacheHandler.putCachedMarkup(hashkey, cachedMarkup);
                }
                this.rewriteMarkup(markupContext.getMarkupString(), requestContext);
            }
        }
        catch (IOException e) {
            throw new ConsumerException("cps.consumer.processmarkupcontextfailed", e);
        }
    }

    public String generateHashKey(RequestContext requestContext) throws ConsumerException {
        ObjectHandler objectHandler = requestContext.getObjectHandler();
        PortletContext portletContext = objectHandler.getPortletContext(this.m_portletContextHashkey, this.m_initialPortletHandle);
        MarkupParams markupParams = this.createMarkupParams(requestContext);
        return RequestHelper.generateHashKey(portletContext, markupParams);
    }

    public void rewriteMarkup(String markupString, RequestContext requestContext) throws CSSClassSubstitutionException, URLRewriteException, IOException {
        this.rewriteMarkup(markupString, requestContext, requestContext.getResultWriter());
    }

    private void rewriteMarkup(String markupString, RequestContext requestContext, Writer output) throws CSSClassSubstitutionException, URLRewriteException, IOException {
        CSSClassSubstituter classSubstituter = new CSSClassSubstituter(requestContext.getCSSClassSubstitutionHandler(), requestContext.getLogger());
        URLRewriter urlRewriter = new URLRewriter(requestContext);
        CharArrayReaderWriter out = new CharArrayReaderWriter(2048);
        classSubstituter.substitute(markupString, (Writer)out);
        urlRewriter.rewrite(out.getBuf(), 0, out.getBufSize(), output);
    }

    private synchronized RegistrationContext getRegistrationContext(RequestContext requestContext) throws ServiceException, ConsumerException {
        if (m_registrationContext == null) {
            ObjectHandler objectHandler = requestContext.getObjectHandler();
            RegistrationData registrationData = objectHandler.createRegistrationData(null);
            WSRP_v1_Registration_PortType registrationPortType = this.m_service.getRegistrationPortType();
            HttpSOAPConnection httpSOAPConnection = requestContext.createHttpSOAPConnection();
            ((IContext)registrationPortType).setProperty("SOAPConnection", (Object)httpSOAPConnection);
            try {
                m_registrationContext = registrationPortType.register(registrationData);
            }
            catch (Exception e) {
                throw new ConsumerException("cps.consumer.registrationinterfaceopfailed", new String[]{"register"}, e);
            }
        } else {
            this.m_logger.debug("Found existing registration context: " + m_registrationContext.getRegistrationState().toString());
        }
        return m_registrationContext;
    }

    private Cookie[] getTransientCookies(RequestContext requestContext, boolean clean) throws ServiceException, ConsumerException {
        Cookie[] cookies;
        this.m_logger.debug("get transient cookies");
        PropylaealetSession session = requestContext.getSession();
        if (clean) {
            session.applyPropertyByNameAndScope(this.m_transientCookieKey, null, 9);
        }
        if ((cookies = (Cookie[])session.fetchPropertyByNameAndScope(this.m_transientCookieKey, 9)) == null && !CookieProtocol.NONE.equals(this.m_requiresInitCookie)) {
            session.applyPropertyByNameAndScope(this.m_initCookieTrackingIdKey, String.valueOf(System.currentTimeMillis()), 9);
            InitCookie initCookie = TypeFactory.newInstance().createInitCookie();
            initCookie.setRegistrationContext(this.getRegistrationContext(requestContext));
            WSRP_v1_Markup_PortType markupPortType = this.m_service.getMarkupPortType();
            HttpSOAPConnection httpSOAPConnection = requestContext.createHttpSOAPConnection();
            Cookie authCookie = requestContext.getAuthCookie();
            if (authCookie != null) {
                httpSOAPConnection.addRequestCookie(authCookie);
            }
            ((IContext)markupPortType).setProperty("SOAPConnection", (Object)httpSOAPConnection);
            long start = 0L;
            if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
                start = System.currentTimeMillis();
            }
            try {
                markupPortType.initCookie(initCookie);
            }
            catch (Exception e) {
                throw new ConsumerException("cps.consumer.markupinterfaceopfailed", new String[]{"initCookie"}, e);
            }
            if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
                long end = System.currentTimeMillis();
                this.m_logger.info("initCookie operation took: " + (end - start) + "ms.");
            }
            if ((cookies = httpSOAPConnection.getResponseCookies()) == null) {
                cookies = new Cookie[]{};
            }
            session.applyPropertyByNameAndScope(this.m_transientCookieKey, cookies, 9);
        }
        return cookies;
    }

    private static String generateHashKey(PortletContext portletContext, MarkupParams markupParams) {
        int i;
        Extension[] extensions;
        int i2;
        StringBuffer cacheKey = new StringBuffer(1024);
        cacheKey.append("portletHandle=");
        cacheKey.append(portletContext.getPortletHandle());
        cacheKey.append("secureClientCommunication=");
        cacheKey.append(markupParams.getSecureClientCommunication());
        cacheKey.append("locales=");
        String[] arrayObj = markupParams.getLocales();
        if (arrayObj != null) {
            for (i2 = 0; i2 < arrayObj.length; ++i2) {
                cacheKey.append(arrayObj[i2]);
                if (i2 >= arrayObj.length - 1) continue;
                cacheKey.append(",");
            }
        }
        cacheKey.append("mimeTypes=");
        arrayObj = markupParams.getMimeTypes();
        if (arrayObj != null) {
            for (i2 = 0; i2 < arrayObj.length; ++i2) {
                cacheKey.append(arrayObj[i2]);
                if (i2 >= arrayObj.length - 1) continue;
                cacheKey.append(",");
            }
        }
        cacheKey.append("mode=");
        cacheKey.append(markupParams.getMode());
        cacheKey.append("windowState=");
        cacheKey.append(markupParams.getWindowState());
        cacheKey.append("clientData[");
        ClientData clientData = markupParams.getClientData();
        if (clientData != null) {
            cacheKey.append("userAgent=");
            cacheKey.append(clientData.getUserAgent());
            cacheKey.append("extensions=");
            extensions = clientData.getExtensions();
            if (extensions != null) {
                for (i = 0; i < extensions.length; ++i) {
                    cacheKey.append(XMLUtils.asXML((Element)extensions[i].getAnyW3CElement()));
                    if (i >= extensions.length - 1) continue;
                    cacheKey.append(",");
                }
            }
        }
        cacheKey.append("]");
        cacheKey.append("navigationalState=");
        cacheKey.append(markupParams.getNavigationalState());
        cacheKey.append("markupCharacterSets=");
        arrayObj = markupParams.getMarkupCharacterSets();
        if (arrayObj != null) {
            for (int i3 = 0; i3 < arrayObj.length; ++i3) {
                cacheKey.append(arrayObj[i3]);
                if (i3 >= arrayObj.length - 1) continue;
                cacheKey.append(",");
            }
        }
        cacheKey.append("validNewModes=");
        arrayObj = markupParams.getValidNewModes();
        if (arrayObj != null) {
            for (int i4 = 0; i4 < arrayObj.length; ++i4) {
                cacheKey.append(arrayObj[i4]);
                if (i4 >= arrayObj.length - 1) continue;
                cacheKey.append(",");
            }
        }
        cacheKey.append("validNewWindowStates=");
        arrayObj = markupParams.getValidNewWindowStates();
        if (arrayObj != null) {
            for (int i5 = 0; i5 < arrayObj.length; ++i5) {
                cacheKey.append(arrayObj[i5]);
                if (i5 >= arrayObj.length - 1) continue;
                cacheKey.append(",");
            }
        }
        cacheKey.append("Extensions=");
        extensions = markupParams.getExtensions();
        if (extensions != null) {
            for (i = 0; i < extensions.length; ++i) {
                cacheKey.append(XMLUtils.asXML((Element)extensions[i].getAnyW3CElement()));
                if (i >= extensions.length - 1) continue;
                cacheKey.append(",");
            }
        }
        return cacheKey.toString();
    }

    private MarkupParams createMarkupParams(RequestContext requestContext) throws ConsumerException {
        MarkupParams markupParams = requestContext.getObjectHandler().createMarkupParams(this.m_portletContextHashkey);
        if ("cps:config".equals(markupParams.getMode()) && !this.m_supportCpsConfigMode) {
            markupParams.setMode("wsrp:edit");
            requestContext.setOverideMode("wsrp:edit", "cps:config");
        }
        return markupParams;
    }

    public void getResource(String urlString, RequestContext requestContext, HttpServletResponse servletResponse, boolean isPost, boolean rewrite) throws ConsumerException {
        HttpURLConnection connection = null;
        try {
            String method = null;
            String postString = null;
            if (isPost) {
                method = "POST";
                int index = urlString.indexOf(63);
                if (index != -1) {
                    postString = urlString.substring(index + 1);
                    urlString = urlString.substring(0, index);
                }
            } else {
                method = "GET";
            }
            URL url = new URL(urlString);
            String gatewayHost = requestContext.getGatewayHostValue();
            String currentHost = RequestContextDefault.getHostFromUrl(urlString);
            if (!currentHost.equalsIgnoreCase(gatewayHost)) {
                servletResponse.sendError(400, "Target not allowed");
                return;
            }
            connection = requestContext.createHttpURLConnection(url);
            CookieUtils.addCookies((HttpURLConnection)connection, (Cookie[])this.getTransientCookies(requestContext, false));
            connection.setRequestMethod(method);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(true);
            if (postString != null) {
                connection.setDoOutput(true);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream());
                outputStreamWriter.write(postString);
                outputStreamWriter.flush();
            }
            InputStream input = connection.getInputStream();
            servletResponse.setContentType(connection.getContentType());
            if (rewrite) {
                Writer writer = requestContext.getResultWriter();
                this.rewriteMarkup(IOUtils.readInputStream(input), requestContext, writer);
                writer.flush();
                writer.close();
            } else {
                ServletOutputStream output = servletResponse.getOutputStream();
                byte[] buf = new byte[4096];
                int bytesRead = input.read(buf, 0, 4096);
                while (bytesRead != -1) {
                    output.write(buf, 0, bytesRead);
                    bytesRead = input.read(buf, 0, 4096);
                }
                input.close();
                output.close();
            }
        }
        catch (IOException e) {
            throw new ConsumerException("cps.errorpage.preerrormsg", e);
        }
        catch (ServiceException e) {
            throw new ConsumerException("cps.errorpage.preerrormsg", e);
        }
        catch (ConsumerException e) {
            throw new ConsumerException("cps.errorpage.preerrormsg", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

