/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.websphere;

import com.cognos.cps.common.ExceptionExtension;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.wsrp.v1.types.BlockingInteractionResponse;
import com.cognos.cps.services.wsrp.v1.types.MarkupContext;
import com.cognos.cps.services.wsrp.v1.types.UpdateResponse;
import com.cognos.cps.wsrp.consumer.CSSClassSubstituter;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionException;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionHandler;
import com.cognos.cps.wsrp.consumer.ConsumerException;
import com.cognos.cps.wsrp.consumer.ErrorPage;
import com.cognos.cps.wsrp.consumer.FixHelper;
import com.cognos.cps.wsrp.consumer.RequestContext;
import com.cognos.cps.wsrp.consumer.RequestHelper;
import com.cognos.cps.wsrp.consumer.RequestHelperFactory;
import com.cognos.cps.wsrp.consumer.URLRewriteException;
import com.cognos.cps.wsrp.consumer.helpers.CSSClassSubstitutionHandlerImpl;
import com.cognos.cps.wsrp.consumer.impls.websphere.FixHelperImpl;
import com.cognos.cps.wsrp.consumer.impls.websphere.HttpSOAPConnectionImpl;
import com.cognos.cps.wsrp.consumer.impls.websphere.RequestContextImpl;
import com.cognos.cps.wsrp.consumer.impls.websphere.ServiceLoggerImpl;
import com.ibm.wps.portletservice.credentialvault.CredentialVaultService;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.jetspeed.portlet.PortletConfig;
import org.apache.jetspeed.portlet.PortletException;
import org.apache.jetspeed.portlet.PortletRequest;
import org.apache.jetspeed.portlet.PortletResponse;
import org.apache.jetspeed.portlet.PortletSession;
import org.apache.jetspeed.portlet.PortletSessionListener;
import org.apache.jetspeed.portlet.PortletSettings;
import org.apache.jetspeed.portlet.PortletWindow;
import org.apache.jetspeed.portlet.UnavailableException;
import org.apache.jetspeed.portlet.event.ActionEvent;
import org.apache.jetspeed.portlet.event.ActionListener;
import org.apache.jetspeed.portlet.service.PortletServiceNotFoundException;
import org.apache.jetspeed.portlet.service.PortletServiceUnavailableException;
import org.apache.jetspeed.portlets.AbstractPortlet;

public class Consumer
extends AbstractPortlet
implements PortletSessionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String BLOCKING_INTERACTION_RESPONSE = "BlockingInteractionResponse";
    public static final String EXCEPTION = "ConsumerException";
    public static final String PORTAL_VERSION = "PortalVersion";
    public static final String CONSUMER_REQUESTED_ENCODING = "UTF-8";
    public static final int WEBSPHERE_4_2 = 0;
    public static final int WEBSPHERE_5_0 = 1;
    public static final int WEBSPHERE_6_0 = 2;
    private static final String WEBSPHERE_4_2_IDENTIFIER = "IBM WebSphere Portal Server/4.2";
    private static final String WEBSPHERE_5_0_IDENTIFIER = "IBM WebSphere Portal/5.0";
    private static final String WEBSPHERE_6_0_IDENTIFIER = "IBM WebSphere Portal/6.0";
    private static final String CSS_MAPPINGS_FILE40 = "/WEB-INF/classes/cssmappings40.properties";
    private static final String CSS_MAPPINGS_FILE50 = "/WEB-INF/classes/cssmappings50.properties";
    private static final String CSS_MAPPINGS_FILE60 = "/WEB-INF/classes/cssmappings60.properties";
    static final String WSRP_WSDL_LOCATION = "IBM Cognos WSRP WSDL Location";
    static final String SHOW_ERROR_DETAIL = "showErrorDetail";
    private static final String PORTLET_HANDLE = "Portlet Handle";
    private ServiceLogger m_logger = null;
    private CSSClassSubstitutionHandler m_cssNameHandler = null;
    private Integer m_portalVersion;
    private CredentialVaultService m_vaultService = null;

    public void init(PortletConfig portletConfig) throws UnavailableException {
        super.init(portletConfig);
        this.m_logger = new ServiceLoggerImpl(this.getPortletLog(), "[" + portletConfig.getName() + "-" + System.currentTimeMillis() + "]");
        this.m_logger.debug("init() called.");
        String containerInfo = portletConfig.getContext().getContainerInfo();
        this.m_logger.info("Portal version: " + portletConfig.getContext().getContainerInfo());
        if (containerInfo.startsWith(WEBSPHERE_4_2_IDENTIFIER)) {
            this.m_portalVersion = new Integer(0);
        } else if (containerInfo.startsWith(WEBSPHERE_5_0_IDENTIFIER)) {
            this.m_portalVersion = new Integer(1);
        } else if (containerInfo.startsWith(WEBSPHERE_6_0_IDENTIFIER)) {
            this.m_portalVersion = new Integer(2);
        } else {
            this.m_logger.warn("The portal version '" + containerInfo + "' isn't recognized, defaulting to '" + WEBSPHERE_6_0_IDENTIFIER + "'.");
            this.m_portalVersion = new Integer(2);
        }
        try {
            this.m_vaultService = (CredentialVaultService)portletConfig.getContext().getService(CredentialVaultService.class);
        }
        catch (PortletServiceUnavailableException e) {
            this.m_logger.error("Exception occurred while retriving CredentialVaultService", (Throwable)e);
            throw new UnavailableException(MessagesManager.getInstance().getMessage(Locale.getDefault(), "cps.ws.portletserviceunavailable", new Object[]{CredentialVaultService.class.getName()}));
        }
        catch (PortletServiceNotFoundException e) {
            this.m_logger.error("Exception occurred while retriving CredentialVaultService", (Throwable)e);
            throw new UnavailableException(MessagesManager.getInstance().getMessage(Locale.getDefault(), "cps.ws.portletserviceunsupported", new Object[]{CredentialVaultService.class.getName()}));
        }
        HttpSOAPConnectionImpl.init(portletConfig, this.m_vaultService, this.m_logger);
        this.loadCSSMappings(portletConfig.getServletContext());
    }

    public void initConcrete(PortletSettings settings) throws UnavailableException {
        this.m_logger.debug("initConcrete() called.");
        String wsdlLocation = settings.getApplicationSettings().getAttribute(WSRP_WSDL_LOCATION);
        if (wsdlLocation == null) {
            throw new UnavailableException(MessagesManager.getInstance().getMessage(Locale.getDefault(), "cps.ws.missingapplicationparam", new Object[]{this.getConfig().getName(), WSRP_WSDL_LOCATION}));
        }
        if (wsdlLocation.length() == 0) {
            throw new UnavailableException(MessagesManager.getInstance().getMessage(Locale.getDefault(), "cps.ws.emptyapplicationparam", new Object[]{this.getConfig().getName(), WSRP_WSDL_LOCATION}));
        }
    }

    public void doView(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        this.m_logger.debug("doView() called.");
        this.handleMarkupRequest(request, response);
    }

    public void doEdit(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        this.m_logger.debug("doEdit() called.");
        this.handleMarkupRequest(request, response);
    }

    public void doConfigure(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        this.m_logger.debug("doConfigure() called.");
        this.handleMarkupRequest(request, response);
    }

    public void doHelp(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        this.m_logger.debug("doHelp() called.");
        this.handleMarkupRequest(request, response);
    }

    public void actionPerformed(ActionEvent event) throws PortletException {
        block4: {
            this.m_logger.debug("actionPerformed() called.");
            PortletRequest request = event.getRequest();
            request.setAttribute(PORTAL_VERSION, (Object)this.m_portalVersion);
            try {
                String actionString = event.getActionString();
                if (actionString == null || !actionString.equals("performBlockingInteraction")) break block4;
                RequestContextImpl requestContext = new RequestContextImpl(request, null, this.getPortletConfig(), this.m_logger, this.m_cssNameHandler, this.getWsdlUrlValue(request));
                RequestHelper requestHelper = this.getRequestHelper((RequestContext)requestContext, request);
                BlockingInteractionResponse blockingInteractionResponse = null;
                try {
                    blockingInteractionResponse = requestHelper.performBlockingInteraction((RequestContext)requestContext);
                }
                catch (Exception e) {
                    this.m_logger.error("Exception occurred while doing a performBlockingInteraction", (Throwable)e);
                    throw new ConsumerException("cps.consumer.wsrp.operationfailed", new Object[]{"performBlockingInteraction"}, (Throwable)e);
                }
                request.setAttribute(BLOCKING_INTERACTION_RESPONSE, (Object)blockingInteractionResponse);
            }
            catch (Throwable e) {
                this.m_logger.error("Exception occurred in actionPerformed()", e);
                request.setAttribute(EXCEPTION, (Object)new ConsumerException("cps.ws.savestatefailed", e));
            }
        }
    }

    public void login(PortletRequest request) throws PortletException {
        this.m_logger.debug("login() called.");
    }

    public void logout(PortletSession session) throws PortletException {
        this.m_logger.debug("logout() called.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMarkupRequest(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        this.m_logger.debug("handleMarkupRequest() called1.");
        long start = 0L;
        if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
            start = System.currentTimeMillis();
        }
        request.setAttribute(PORTAL_VERSION, (Object)this.m_portalVersion);
        if (request.getAttribute(EXCEPTION) != null) {
            this.renderErrorPage((ConsumerException)request.getAttribute(EXCEPTION), request, response);
            return;
        }
        if (request.getWindow() != null && request.getWindow().getWindowState() != null && request.getWindow().getWindowState().equals(PortletWindow.State.MINIMIZED)) {
            response.getWriter().write("<!-- minimized state -->");
            return;
        }
        try {
            MarkupContext markupContext;
            UpdateResponse updateResponse;
            RequestContextImpl requestContext = new RequestContextImpl(request, response, this.getPortletConfig(), this.m_logger, this.m_cssNameHandler, this.getWsdlUrlValue(request));
            RequestHelper requestHelper = this.getRequestHelper((RequestContext)requestContext, request);
            BlockingInteractionResponse blockingInteractionResponse = (BlockingInteractionResponse)request.getAttribute(BLOCKING_INTERACTION_RESPONSE);
            boolean urlTypeIndicated = false;
            String urlType = request.getParameter("wsrp-urlType");
            if (urlType != null && urlType.equals("blockingAction")) {
                urlTypeIndicated = true;
            }
            if (blockingInteractionResponse == null && urlTypeIndicated) {
                try {
                    blockingInteractionResponse = requestHelper.performBlockingInteraction((RequestContext)requestContext);
                }
                catch (Exception e) {
                    this.m_logger.error("Exception occurred while doing a performBlockingInteraction (from handleMarkupRequest)", (Throwable)e);
                    throw new ConsumerException("cps.consumer.wsrp.operationfailed", new Object[]{"performBlockingInteraction"}, (Throwable)e);
                }
                request.setAttribute(BLOCKING_INTERACTION_RESPONSE, (Object)blockingInteractionResponse);
            }
            if (blockingInteractionResponse != null && (updateResponse = blockingInteractionResponse.getUpdateResponse()) != null && (markupContext = updateResponse.getMarkupContext()) != null) {
                requestHelper.processMarkupContext((RequestContext)requestContext, markupContext);
                String navigationalState = updateResponse.getNavigationalState();
                request.getSession(true).setAttribute("NavigationalState", (Object)navigationalState);
                return;
            }
            requestHelper.getMarkup((RequestContext)new RequestContextImpl(request, response, this.getPortletConfig(), this.m_logger, this.m_cssNameHandler, this.getWsdlUrlValue(request)));
        }
        catch (CSSClassSubstitutionException e) {
            this.m_logger.error("Exception occurred while handling markup request.", (Throwable)e);
            this.renderErrorPage(new ConsumerException("cps.consumer.cssclasssubstitution", null, (Throwable)e), request, response);
        }
        catch (URLRewriteException e) {
            this.m_logger.error("Exception occurred while handling markup request.", (Throwable)e);
            this.renderErrorPage(new ConsumerException("cps.consumer.rewritefailed", null, (Throwable)e), request, response);
        }
        catch (Throwable e) {
            this.m_logger.error("Exception occurred while handling markup request.", e);
            this.renderErrorPage(new ConsumerException("cps.consumer.wsrp.operationfailed", new Object[]{"getMarkup"}, e), request, response);
        }
        finally {
            if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
                long end = System.currentTimeMillis();
                this.m_logger.info("handleMarkupRequest for Portlet mode '" + request.getMode().toString() + "' took: " + (end - start) + "ms.");
            }
        }
    }

    private void loadCSSMappings(ServletContext servletContext) throws UnavailableException {
        this.m_logger.debug("loadCSSMappings() called.");
        String mappingFile = null;
        mappingFile = this.m_portalVersion == 0 ? CSS_MAPPINGS_FILE40 : (this.m_portalVersion == 1 ? CSS_MAPPINGS_FILE50 : CSS_MAPPINGS_FILE60);
        InputStream in = servletContext.getResourceAsStream(mappingFile);
        if (in == null) {
            throw new UnavailableException(MessagesManager.getInstance().getMessage(Locale.getDefault(), "cps.ws.loadcssmappingsfailed", new Object[]{mappingFile}));
        }
        Properties cssMappings = new Properties();
        try {
            cssMappings.load(in);
        }
        catch (IOException e) {
            this.m_logger.error("Exception occurred while loading CSS mappings.", (Throwable)e);
            throw new UnavailableException(MessagesManager.getInstance().getMessage(Locale.getDefault(), "cps.ws.readcssmappingsfailed", new Object[]{mappingFile, e.getMessage()}));
        }
        this.m_cssNameHandler = new CSSClassSubstitutionHandlerImpl(cssMappings);
    }

    private RequestHelper getRequestHelper(RequestContext requestContext, PortletRequest request) throws IOException, ConsumerException, ServiceException {
        this.m_logger.debug("getRequestHelper() called.");
        String wsdlLocation = this.getWsdlUrlValue(request);
        if (wsdlLocation == null || wsdlLocation.length() == 0) {
            throw new ConsumerException(MessagesManager.getInstance().getMessage(request.getLocale(), "cps.ws.missingapplicationparam", new Object[]{this.getConfig().getName(), WSRP_WSDL_LOCATION}));
        }
        String portletHandle = request.getPortletSettings().getAttribute(PORTLET_HANDLE);
        if (portletHandle == null || portletHandle.length() == 0) {
            throw new ConsumerException(MessagesManager.getInstance().getMessage(request.getLocale(), "cps.ws.missingconfigparam", new Object[]{this.getConfig().getName(), PORTLET_HANDLE}));
        }
        return RequestHelperFactory.newInstance().createRequestHelper(requestContext, new URL(wsdlLocation), portletHandle);
    }

    private String getWsdlUrlValue(PortletRequest request) {
        String wsdlLocation = request.getPortletSettings().getApplicationSettings().getAttribute(WSRP_WSDL_LOCATION);
        return wsdlLocation;
    }

    private void renderErrorPage(ConsumerException exception, PortletRequest request, PortletResponse response) throws IOException, PortletException {
        this.m_logger.error("Exception encountered, rendering error page", (Throwable)exception);
        try {
            FixHelperImpl fixHelper = null;
            if ("true".equalsIgnoreCase(request.getPortletSettings().getApplicationSettings().getAttribute(SHOW_ERROR_DETAIL))) {
                fixHelper = new FixHelperImpl(request.getPortletSettings());
            }
            CSSClassSubstituter classSubstituter = new CSSClassSubstituter(this.m_cssNameHandler, this.m_logger);
            classSubstituter.substitute(ErrorPage.render((ExceptionExtension)exception, (Locale)request.getLocale(), (String)response.encodeURL(""), (FixHelper)fixHelper), (Writer)response.getWriter());
        }
        catch (Throwable e) {
            this.m_logger.error("Failed to render CPS error page.", e);
            throw new PortletException(MessagesManager.getInstance().getMessage(request.getLocale(), "cps.ws.requestfailed", new Object[]{this.getConfig().getName()}), (Throwable)exception);
        }
    }

    static {
        ArrayList<String> msgFileList = new ArrayList<String>();
        msgFileList.add("cpsconsumermsgs");
        msgFileList.add("cpsservicemsgs");
        msgFileList.add("cpssoapmsgs");
        MessagesManager.getInstance().initialize(msgFileList);
    }
}

