/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.websphere;

import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.cps.wsrp.consumer.RequestHelper;
import com.cognos.cps.wsrp.consumer.URLRewriteException;
import com.cognos.cps.wsrp.consumer.URLRewriteHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import org.apache.jetspeed.portlet.Portlet;
import org.apache.jetspeed.portlet.PortletRequest;
import org.apache.jetspeed.portlet.PortletResponse;
import org.apache.jetspeed.portlet.PortletURI;
import org.apache.jetspeed.portlet.PortletWindow;

public class URLRewriterImpl
implements URLRewriteHandler {
    public static final String PORTLET_ACTION_BLOCKINGINTERACTION = "performBlockingInteraction";
    private PortletResponse response = null;
    private PortletRequest request = null;
    private int portalVersion;
    private String cookieKey = null;
    private String gatewayHostKey = null;
    private String credentialType;

    private URLRewriterImpl() {
    }

    public URLRewriterImpl(PortletRequest request, PortletResponse response, String gatewayHostKey) {
        this.request = request;
        this.response = response;
        this.cookieKey = RequestHelper.createCookieKey((String)request.getPortletSettings().getApplicationSettings().getAttribute("IBM Cognos WSRP WSDL Location"));
        this.portalVersion = (Integer)request.getAttribute("PortalVersion");
        this.credentialType = request.getPortletSettings().getApplicationSettings().getAttribute("Active Credential Type");
        this.gatewayHostKey = gatewayHostKey;
    }

    public void generateURL(Map urlParams, Writer result, String rewriteFlags) throws URLRewriteException {
        PortletURI portletURI = null;
        String urlType = (String)urlParams.get("wsrp-urlType");
        if ("resource".equals(urlType)) {
            this.writeResourceUrl(urlParams, result);
        } else {
            if (urlParams.size() == 0) {
                portletURI = this.response.createReturnURI();
            } else {
                String windowState;
                String mode = (String)urlParams.get("wsrp-mode");
                portletURI = this.request.getMode() != Portlet.Mode.VIEW && (mode == null || mode.equals("wsrp:view")) ? this.response.createReturnURI() : ((windowState = (String)urlParams.get("wsrp-windowState")) != null && windowState.length() > 0 ? this.response.createURI(this.getWSWindowState(windowState)) : this.response.createURI());
            }
            if (urlType != null && urlType.equals("blockingAction")) {
                portletURI.addAction(PORTLET_ACTION_BLOCKINGINTERACTION);
            }
            Map.Entry pair2 = null;
            for (Map.Entry pair2 : urlParams.entrySet()) {
                String value = this.decodeParamValue((String)pair2.getValue());
                portletURI.addParameter((String)pair2.getKey(), value);
            }
            try {
                result.write(portletURI.toString());
            }
            catch (IOException e) {
                throw new URLRewriteException("cps.consumer.rewritefailed", (Throwable)e);
            }
        }
    }

    private String decodeParamValue(String value) throws URLRewriteException {
        if (this.portalVersion != 0 && value != null && value.indexOf(37) > -1) {
            try {
                return EncodingUtils.urlDecode((String)value, (String)"UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new URLRewriteException("cps.consumer.rewritefailed", (Throwable)e);
            }
        }
        return value;
    }

    private void writeResourceUrl(Map urlParams, Writer result) throws URLRewriteException {
        try {
            result.write(this.request.getScheme());
            result.write("://");
            result.write(this.request.getServerName());
            result.write(":");
            result.write(String.valueOf(this.request.getServerPort()));
            result.write(this.request.getContextPath());
            result.write("/resource");
            result.write("?");
            String targetUrl = this.decodeParamValue((String)urlParams.get("wsrp-url"));
            if (targetUrl != null) {
                result.write("cps.target");
                result.write("=");
                result.write(EncodingUtils.urlEncode((String)targetUrl, (String)"UTF-8", (boolean)false));
                result.write("&");
            }
            result.write("cps.ckey");
            result.write("=");
            result.write(EncodingUtils.urlEncode((String)this.cookieKey, (String)"UTF-8", (boolean)false));
            result.write("&");
            result.write("cps.gkey");
            result.write("=");
            result.write(EncodingUtils.urlEncode((String)this.gatewayHostKey, (String)"UTF-8", (boolean)false));
            if (this.credentialType != null) {
                result.write("&");
                result.write("cps.actype");
                result.write("=");
                result.write(EncodingUtils.urlEncode((String)this.credentialType, (String)"UTF-8", (boolean)false));
            }
        }
        catch (IOException e) {
            throw new URLRewriteException("cps.consumer.rewritefailed", (Throwable)e);
        }
    }

    public void generateUniquePortletId(Writer result) throws URLRewriteException {
        try {
            result.write("p" + Integer.toString(this.hashCode()).replace("-", "_"));
        }
        catch (IOException e) {
            throw new URLRewriteException("cps.consumer.rewritefailed", (Throwable)e);
        }
    }

    PortletWindow.State getWSWindowState(String wsrpWindowState) throws URLRewriteException {
        PortletWindow.State state = null;
        if (wsrpWindowState.equals("wsrp:normal")) {
            state = PortletWindow.State.NORMAL;
        } else if (wsrpWindowState.equals("wsrp:maximized")) {
            state = PortletWindow.State.MAXIMIZED;
        } else if (wsrpWindowState.equals("wsrp:minimized")) {
            state = PortletWindow.State.MINIMIZED;
        } else if (wsrpWindowState.equals("wsrp:solo")) {
            state = PortletWindow.State.forIdentifier((String)"Solo");
            if (state == null) {
                state = PortletWindow.State.DETACHED;
            }
        } else {
            Object[] args = new String[]{wsrpWindowState};
            throw new URLRewriteException("cps.ws.invalidwindowstate", args);
        }
        return state;
    }
}

