/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.session;

import com.cognos.cps.common.ExceptionExtension;
import com.cognos.cps.common.message.MessagesManager;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Locale;

public class SessionException
extends Exception
implements ExceptionExtension {
    protected String m_key = null;
    protected Object[] m_args = null;
    protected Throwable m_rootCause = null;

    public SessionException(String key) {
        super(key);
        this.m_key = key;
    }

    public SessionException(String key, Throwable rootCause) {
        super(key);
        this.m_key = key;
        this.m_rootCause = rootCause;
    }

    public SessionException(String key, Object[] args) {
        super(key);
        this.m_key = key;
        this.m_args = args;
    }

    public SessionException(String key, Object[] args, Throwable rootCause) {
        super(key);
        this.m_key = key;
        this.m_args = args;
        this.m_rootCause = rootCause;
    }

    @Override
    public String getKey() {
        return this.m_key;
    }

    public Object[] copyArgs() {
        if (this.m_args != null) {
            Object[] theCopy = new Object[this.m_args.length];
            System.arraycopy(this.m_args, 0, theCopy, 0, this.m_args.length);
            return theCopy;
        }
        return null;
    }

    @Override
    public Throwable getRootCause() {
        return this.m_rootCause;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMsgString(Locale.getDefault());
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this.m_rootCause != null) {
            this.m_rootCause.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.m_rootCause != null) {
            this.m_rootCause.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.m_rootCause != null) {
            this.m_rootCause.printStackTrace(s);
        }
    }

    @Override
    public String getLocalizedMsgString(Locale locale) {
        if (this.m_key == null) {
            return "";
        }
        if (this.m_args == null) {
            return MessagesManager.getInstance().getMessage(locale, this.m_key);
        }
        return MessagesManager.getInstance().getMessage(locale, this.m_key, this.m_args);
    }
}

