/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;
import org.exolab.castor.util.Messages;

public final class MaxKeyGenerator
implements KeyGenerator {
    private static Log _log = LogFactory.getFactory().getInstance(MaxKeyGenerator.class);
    private static final BigDecimal ONE = new BigDecimal(1);
    private final int _sqlType;
    private final PersistenceFactory _factory;

    public MaxKeyGenerator(PersistenceFactory factory, int sqlType) throws MappingException {
        this._factory = factory;
        this._sqlType = sqlType;
        if (sqlType != 4 && sqlType != 2 && sqlType != 3 && sqlType != -5) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(sqlType)));
        }
    }

    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        Statement stmt = null;
        Number identity = null;
        try {
            BigDecimal max;
            String sql;
            QueryExpression query = this._factory.getQueryExpression();
            if (this._factory.getFactoryName().equals("mysql")) {
                query.addSelect("MAX(" + this._factory.quoteName(primKeyName) + ")");
                query.addTable(tableName);
                sql = query.getStatement(false);
            } else {
                query.addColumn(tableName, primKeyName);
                query.addCondition(tableName, primKeyName, "=", "(SELECT MAX(t1." + this._factory.quoteName(primKeyName) + ") FROM " + this._factory.quoteName(tableName) + " t1)");
                sql = query.getStatement(true);
            }
            stmt = conn.prepareStatement(sql);
            ResultSet rs = stmt.executeQuery();
            identity = rs.next() ? (Number)(this._sqlType == 4 ? (Number)new Integer(rs.getInt(1) + 1) : (Number)(this._sqlType == -5 ? new Long(rs.getLong(1) + 1L) : ((max = rs.getBigDecimal(1)) == null ? ONE : max.add(ONE)))) : (Number)(this._sqlType == 4 ? (Number)new Integer(1) : (Number)(this._sqlType == -5 ? new Long(1L) : ONE));
        }
        catch (SQLException ex) {
            throw new PersistenceException(Messages.format("persist.keyGenSQL", ex.toString()), ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    _log.warn((Object)Messages.message("persist.stClosingFailed"), (Throwable)ex);
                }
            }
        }
        if (identity == null) {
            throw new PersistenceException(Messages.format("persist.keyGenOverflow", this.getClass().getName()));
        }
        return identity;
    }

    public final byte getStyle() {
        return -1;
    }

    public final String patchSQL(String insert, String primKeyName) throws MappingException {
        return insert;
    }

    public boolean isInSameConnection() {
        return true;
    }
}

