/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.mapping.AbstractFieldHandler;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.FieldHandlerFactory;
import org.exolab.castor.mapping.GeneralizedFieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.util.List;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.IntrospectedXMLClassDescriptor;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.descriptors.CoreDescriptors;
import org.exolab.castor.xml.handlers.ContainerFieldHandler;
import org.exolab.castor.xml.handlers.DateFieldHandler;
import org.exolab.castor.xml.handlers.DefaultFieldHandlerFactory;
import org.exolab.castor.xml.util.XMLClassDescriptorImpl;
import org.exolab.castor.xml.util.XMLFieldDescriptorImpl;

public final class Introspector {
    public static final String WRAP_COLLECTIONS_PROPERTY = "org.exolab.castor.xml.introspector.wrapCollections";
    private static final String ADD = "add";
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String SET = "set";
    private static final String CREATE = "create";
    private FieldHandlerFactory DEFAULT_HANDLER_FACTORY = new DefaultFieldHandlerFactory();
    private static final Class[] EMPTY_CLASS_ARGS = new Class[0];
    private static final String LIST = "java.util.List";
    private static final String MAP = "java.util.Map";
    private static final String SET_COLLECTION = "java.util.Set";
    private static final String COLLECTION_WRAPPER_PREFIX = "##container_for_";
    private static final boolean WRAP_COLLECTIONS_DEFAULT = false;
    private static final Class[] _collections = Introspector.loadCollections();
    private static XMLNaming _defaultNaming = null;
    private XMLNaming _naming = null;
    private NodeType _primitiveNodeType = null;
    private boolean _wrapCollectionsInContainer = false;
    private Vector _handlerFactoryList = null;
    private Hashtable _handlerFactoryMap = null;
    private boolean _saveMapKeys = true;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$org$exolab$castor$xml$util$ContainerElement;
    static /* synthetic */ Class class$java$sql$Date;

    public Introspector() {
        this.init();
    }

    private void init() {
        String saveKeys;
        LocalConfiguration config = LocalConfiguration.getInstance();
        if (_defaultNaming == null) {
            _defaultNaming = config.getXMLNaming();
        }
        this._naming = _defaultNaming;
        this.setPrimitiveNodeType(config.getPrimitiveNodeType());
        String wrap = config.getProperty(WRAP_COLLECTIONS_PROPERTY, null);
        if (wrap != null) {
            this._wrapCollectionsInContainer = Boolean.valueOf(wrap);
        }
        if ((saveKeys = config.getProperty("org.exolab.castor.xml.saveMapKeys", null)) != null && ("false".equals(saveKeys) || "off".equals(saveKeys))) {
            this._saveMapKeys = false;
        }
    }

    public synchronized void addFieldHandlerFactory(FieldHandlerFactory factory) {
        if (factory == null) {
            String err = "The argument 'factory' must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (this._handlerFactoryList == null) {
            this._handlerFactoryList = new Vector();
        }
        this._handlerFactoryList.addElement(factory);
        this.registerHandlerFactory(factory);
    }

    public NodeType getPrimitiveNodeType() {
        return this._primitiveNodeType;
    }

    public XMLClassDescriptor generateClassDescriptor(Class c) throws MarshalException {
        return this.generateClassDescriptor(c, null);
    }

    public XMLClassDescriptor generateClassDescriptor(Class c, PrintWriter errorWriter) throws MarshalException {
        if (c == null) {
            return null;
        }
        if (c.isArray()) {
            return null;
        }
        if (c == Void.class || c == Class.class || c == Object.class) {
            throw new MarshalException("The marshaller cannot marshal/unmarshal types of Void.class, Class.class or Object.class");
        }
        XMLClassDescriptor coreDesc = CoreDescriptors.getDescriptor(c);
        if (coreDesc != null) {
            return coreDesc;
        }
        IntrospectedXMLClassDescriptor classDesc = new IntrospectedXMLClassDescriptor(c);
        Method[] methods = c.getMethods();
        List dateDescriptors = new List(3);
        Hashtable<String, MethodSet> methodSets = new Hashtable<String, MethodSet>();
        int methodCount = 0;
        Class superClass = c.getSuperclass();
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> type;
            MethodSet methodSet;
            MethodSet methodSet2;
            String fieldName;
            Method method = methods[i];
            Class<?> owner = method.getDeclaringClass();
            if (owner != c) {
                if (!owner.isInterface()) continue;
                if (interfaces.length > 0) {
                    boolean found = false;
                    for (int count = 0; count < interfaces.length; ++count) {
                        if (interfaces[count] != owner) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        continue;
                    }
                }
            } else if (superClass != null) {
                Class<?>[] args = method.getParameterTypes();
                String name = method.getName();
                Method tmpMethod = null;
                try {
                    tmpMethod = superClass.getMethod(name, args);
                }
                catch (NoSuchMethodException nsme) {
                    // empty catch block
                }
                if (tmpMethod != null) continue;
            }
            if ((method.getModifiers() & 8) != 0) continue;
            String methodName = method.getName();
            if (methodName.startsWith(GET)) {
                if (method.getParameterTypes().length != 0) continue;
                ++methodCount;
                Class<?> type2 = method.getReturnType();
                if (type2 == null || !Introspector.isDescriptable(type2)) continue;
                fieldName = methodName.substring(3);
                methodSet2 = (MethodSet)methodSets.get(fieldName = JavaNaming.toJavaMemberName(fieldName));
                if (methodSet2 == null) {
                    methodSet2 = new MethodSet(fieldName);
                    methodSets.put(fieldName, methodSet2);
                }
                methodSet2.get = method;
                continue;
            }
            if (methodName.startsWith(IS)) {
                Class<?> type3;
                if (method.getParameterTypes().length != 0 || (type3 = method.getReturnType()) == null || (type3.isPrimitive() ? type3 != Boolean.TYPE : type3 != (class$java$lang$Boolean == null ? Introspector.class$("java.lang.Boolean") : class$java$lang$Boolean))) continue;
                ++methodCount;
                fieldName = methodName.substring(IS.length());
                methodSet2 = (MethodSet)methodSets.get(fieldName = JavaNaming.toJavaMemberName(fieldName));
                if (methodSet2 == null) {
                    methodSet2 = new MethodSet(fieldName);
                    methodSets.put(fieldName, methodSet2);
                }
                methodSet2.get = method;
                continue;
            }
            if (methodName.startsWith(ADD)) {
                if (method.getParameterTypes().length != 1) continue;
                ++methodCount;
                if (!Introspector.isDescriptable(method.getParameterTypes()[0])) continue;
                String fieldName2 = methodName.substring(3);
                methodSet = (MethodSet)methodSets.get(fieldName2 = JavaNaming.toJavaMemberName(fieldName2));
                if (methodSet == null) {
                    methodSet = new MethodSet(fieldName2);
                    methodSets.put(fieldName2, methodSet);
                }
                methodSet.add = method;
                continue;
            }
            if (methodName.startsWith(SET)) {
                if (method.getParameterTypes().length != 1) continue;
                ++methodCount;
                if (!Introspector.isDescriptable(method.getParameterTypes()[0])) continue;
                String fieldName3 = methodName.substring(3);
                methodSet = (MethodSet)methodSets.get(fieldName3 = JavaNaming.toJavaMemberName(fieldName3));
                if (methodSet == null) {
                    methodSet = new MethodSet(fieldName3);
                    methodSets.put(fieldName3, methodSet);
                }
                methodSet.set = method;
                continue;
            }
            if (!methodName.startsWith(CREATE) || method.getParameterTypes().length != 0 || !Introspector.isDescriptable(type = method.getReturnType())) continue;
            fieldName = methodName.substring(CREATE.length());
            methodSet2 = (MethodSet)methodSets.get(fieldName = JavaNaming.toJavaMemberName(fieldName));
            if (methodSet2 == null) {
                methodSet2 = new MethodSet(fieldName);
                methodSets.put(fieldName, methodSet2);
            }
            methodSet2.create = method;
        }
        Enumeration theEnum = methodSets.elements();
        while (theEnum.hasMoreElements()) {
            MethodSet methodSet = (MethodSet)theEnum.nextElement();
            String xmlName = this._naming.toXMLName(methodSet.fieldName);
            boolean isCollection = false;
            Class type = null;
            if (methodSet.add != null) {
                type = methodSet.add.getParameterTypes()[0];
                isCollection = true;
            }
            if (type == null) {
                if (methodSet.get != null) {
                    type = methodSet.get.getReturnType();
                } else {
                    if (methodSet.set == null) continue;
                    type = methodSet.set.getParameterTypes()[0];
                }
            }
            isCollection = isCollection || Introspector.isCollection(type);
            TypeInfo typeInfo = null;
            CollectionHandler colHandler = null;
            if (isCollection && methodSet.add == null) {
                try {
                    colHandler = CollectionHandlers.getHandler(type);
                }
                catch (MappingException mx) {
                    // empty catch block
                }
                if (type.isArray()) {
                    if (type.getComponentType() == Byte.TYPE) {
                        colHandler = null;
                    } else {
                        type = type.getComponentType();
                    }
                }
            }
            typeInfo = new TypeInfo(type, null, null, false, null, colHandler);
            AbstractFieldHandler handler = null;
            boolean customHandler = false;
            try {
                GeneralizedFieldHandler gfh;
                FieldHandlerFactory factory;
                handler = new FieldHandlerImpl(methodSet.fieldName, null, null, methodSet.get, methodSet.set, typeInfo);
                if (methodSet.add != null) {
                    handler.setAddMethod(methodSet.add);
                }
                if (methodSet.create != null) {
                    handler.setCreateMethod(methodSet.create);
                }
                if (isCollection && this._saveMapKeys && Introspector.isMapCollection(type)) {
                    handler.setConvertFrom(new IdentityConvertor());
                }
                if ((factory = this.getHandlerFactory(type)) != null && (gfh = factory.createFieldHandler(type)) != null) {
                    gfh.setFieldHandler(handler);
                    handler = gfh;
                    customHandler = true;
                    if (gfh.getFieldType() != null) {
                        type = gfh.getFieldType();
                    }
                }
            }
            catch (MappingException mx) {
                throw new MarshalException(mx);
            }
            XMLFieldDescriptorImpl fieldDesc = this.createFieldDescriptor(type, methodSet.fieldName, xmlName);
            if (isCollection) {
                fieldDesc.setMultivalued(true);
                fieldDesc.setNodeType(NodeType.Element);
            }
            if ((class$java$util$Date == null ? Introspector.class$("java.util.Date") : class$java$util$Date).isAssignableFrom(type) && !customHandler) {
                dateDescriptors.add(fieldDesc);
            }
            fieldDesc.setHandler(handler);
            if (isCollection && this._wrapCollectionsInContainer) {
                String fieldName = COLLECTION_WRAPPER_PREFIX + methodSet.fieldName;
                Class cType = class$org$exolab$castor$xml$util$ContainerElement == null ? Introspector.class$("org.exolab.castor.xml.util.ContainerElement") : class$org$exolab$castor$xml$util$ContainerElement;
                XMLClassDescriptorImpl containerClassDesc = new XMLClassDescriptorImpl(cType);
                containerClassDesc.addFieldDescriptor(fieldDesc);
                fieldDesc.setXMLName(null);
                fieldDesc.setMatches("*");
                ContainerFieldHandler cHandler = new ContainerFieldHandler(handler);
                fieldDesc.setHandler(cHandler);
                fieldDesc = this.createFieldDescriptor(cType, fieldName, xmlName);
                fieldDesc.setClassDescriptor(containerClassDesc);
                fieldDesc.setHandler(cHandler);
            }
            classDesc.addFieldDescriptor(fieldDesc);
        }
        if (methodCount == 0) {
            Field[] fields = c.getFields();
            Hashtable<String, XMLFieldDescriptorImpl> descriptors = new Hashtable<String, XMLFieldDescriptorImpl>();
            for (int i = 0; i < fields.length; ++i) {
                Class type;
                int modifiers;
                Field field = fields[i];
                Class<?> owner = field.getDeclaringClass();
                if (owner != c) {
                    if (!owner.isInterface()) continue;
                    if (interfaces.length > 0) {
                        boolean found = false;
                        for (int count = 0; count < interfaces.length; ++count) {
                            if (interfaces[count] != owner) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                }
                if (Modifier.isTransient(modifiers = field.getModifiers()) || Modifier.isFinal(modifiers) && Modifier.isStatic(modifiers) || !Introspector.isDescriptable(type = field.getType())) continue;
                boolean isCollection = Introspector.isCollection(type);
                TypeInfo typeInfo = null;
                CollectionHandler colHandler = null;
                if (isCollection) {
                    try {
                        colHandler = CollectionHandlers.getHandler(type);
                    }
                    catch (MappingException mx) {
                        // empty catch block
                    }
                    if (type.isArray()) {
                        if (type.getComponentType() == Byte.TYPE) {
                            colHandler = null;
                        } else {
                            type = type.getComponentType();
                        }
                    }
                }
                String fieldName = field.getName();
                String xmlName = this._naming.toXMLName(fieldName);
                typeInfo = new TypeInfo(type, null, null, false, null, colHandler);
                AbstractFieldHandler handler = null;
                boolean customHandler = false;
                try {
                    GeneralizedFieldHandler gfh;
                    FieldHandlerFactory factory;
                    handler = new FieldHandlerImpl(field, typeInfo);
                    if (isCollection && this._saveMapKeys && Introspector.isMapCollection(type)) {
                        handler.setConvertFrom(new IdentityConvertor());
                    }
                    if ((factory = this.getHandlerFactory(type)) != null && (gfh = factory.createFieldHandler(type)) != null) {
                        gfh.setFieldHandler(handler);
                        handler = gfh;
                        customHandler = true;
                        if (gfh.getFieldType() != null) {
                            type = gfh.getFieldType();
                        }
                    }
                }
                catch (MappingException mx) {
                    throw new MarshalException(mx);
                }
                XMLFieldDescriptorImpl fieldDesc = this.createFieldDescriptor(type, fieldName, xmlName);
                if (isCollection) {
                    fieldDesc.setNodeType(NodeType.Element);
                    fieldDesc.setMultivalued(true);
                }
                descriptors.put(xmlName, fieldDesc);
                classDesc.addFieldDescriptor(fieldDesc);
                fieldDesc.setHandler(handler);
                if (!(class$java$util$Date == null ? Introspector.class$("java.util.Date") : class$java$util$Date).isAssignableFrom(type) || customHandler) continue;
                dateDescriptors.add(fieldDesc);
            }
        }
        if (dateDescriptors != null) {
            for (int i = 0; i < dateDescriptors.size(); ++i) {
                XMLFieldDescriptorImpl fieldDesc = (XMLFieldDescriptorImpl)dateDescriptors.get(i);
                FieldHandler handler = fieldDesc.getHandler();
                fieldDesc.setImmutable(true);
                DateFieldHandler dfh = new DateFieldHandler(handler);
                Class type = fieldDesc.getFieldType();
                if ((class$java$sql$Date == null ? Introspector.class$("java.sql.Date") : class$java$sql$Date).isAssignableFrom(type)) {
                    dfh.setUseSQLDate(true);
                }
                fieldDesc.setHandler(dfh);
            }
        }
        if (superClass != null && superClass != Void.class && superClass != Object.class && superClass != Class.class) {
            try {
                XMLClassDescriptor parent = this.generateClassDescriptor(superClass, errorWriter);
                if (parent != null) {
                    classDesc.setExtends(parent);
                }
            }
            catch (MarshalException mx) {
                // empty catch block
            }
        }
        return classDesc;
    }

    public synchronized boolean removeFieldHandlerFactory(FieldHandlerFactory factory) {
        if (factory == null) {
            String err = "The argument 'factory' must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (this._handlerFactoryList == null) {
            return false;
        }
        if (this._handlerFactoryList.removeElement(factory)) {
            this._handlerFactoryMap.clear();
            for (int i = 0; i < this._handlerFactoryList.size(); ++i) {
                FieldHandlerFactory tmp = (FieldHandlerFactory)this._handlerFactoryList.elementAt(i);
                this.registerHandlerFactory(tmp);
            }
            return true;
        }
        return false;
    }

    public void setWrapCollections(boolean wrapCollections) {
        this._wrapCollectionsInContainer = wrapCollections;
    }

    public static boolean introspected(XMLClassDescriptor descriptor) {
        return descriptor instanceof IntrospectedXMLClassDescriptor;
    }

    public static boolean marshallable(Class type) {
        if (type == Void.class || type == Class.class) {
            return false;
        }
        if (!(type.isInterface() && type != Object.class || Introspector.isPrimitive(type) || type.isArray())) {
            try {
                type.getConstructor(EMPTY_CLASS_ARGS);
            }
            catch (NoSuchMethodException e) {
                return CoreDescriptors.getDescriptor(type) != null;
            }
        }
        return true;
    }

    public void setNaming(XMLNaming naming) {
        this._naming = naming == null ? _defaultNaming : naming;
    }

    public void setPrimitiveNodeType(NodeType nodeType) {
        this._primitiveNodeType = nodeType == NodeType.Element ? nodeType : NodeType.Attribute;
    }

    public void setSaveMapKeys(boolean saveMapKeys) {
        this._saveMapKeys = saveMapKeys;
    }

    public static String toJavaName(String name, boolean upperFirst) {
        int size = name.length();
        char[] ncChars = name.toCharArray();
        int next = 0;
        boolean uppercase = upperFirst;
        block3: for (int i = 0; i < size; ++i) {
            char ch = ncChars[i];
            switch (ch) {
                case '-': 
                case ':': {
                    uppercase = true;
                    continue block3;
                }
                default: {
                    if (uppercase) {
                        ncChars[next] = Character.toUpperCase(ch);
                        uppercase = false;
                    } else {
                        ncChars[next] = ch;
                    }
                    ++next;
                }
            }
        }
        return new String(ncChars, 0, next);
    }

    private XMLFieldDescriptorImpl createFieldDescriptor(Class type, String fieldName, String xmlName) {
        XMLFieldDescriptorImpl fieldDesc = new XMLFieldDescriptorImpl(type, fieldName, xmlName, null);
        if (type.isArray()) {
            fieldDesc.setNodeType(NodeType.Element);
        } else if (type.isPrimitive()) {
            fieldDesc.setNodeType(this._primitiveNodeType);
        } else {
            fieldDesc.setNodeType(NodeType.Element);
        }
        if (type == Object.class) {
            fieldDesc.setMatches(xmlName + " *");
        }
        return fieldDesc;
    }

    private FieldHandlerFactory getHandlerFactory(Class type) {
        if (this._handlerFactoryMap != null) {
            for (Class tmp = type; tmp != null; tmp = tmp.getSuperclass()) {
                Object obj = this._handlerFactoryMap.get(tmp);
                if (obj == null) continue;
                return (FieldHandlerFactory)obj;
            }
        }
        if (this.DEFAULT_HANDLER_FACTORY.isSupportedType(type)) {
            return this.DEFAULT_HANDLER_FACTORY;
        }
        return null;
    }

    private void registerHandlerFactory(FieldHandlerFactory factory) {
        if (this._handlerFactoryMap == null) {
            this._handlerFactoryMap = new Hashtable();
        }
        Class[] types = factory.getSupportedTypes();
        for (int i = 0; i < types.length; ++i) {
            this._handlerFactoryMap.put(types[i], factory);
        }
    }

    public static boolean isCollection(Class clazz) {
        if (clazz.isArray()) {
            return true;
        }
        for (int i = 0; i < _collections.length; ++i) {
            if (clazz != _collections[i] && !_collections[i].isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMapCollection(Class clazz) {
        if (clazz.isArray()) {
            return false;
        }
        for (int i = 0; i < _collections.length; ++i) {
            if (clazz != _collections[i] && !_collections[i].isAssignableFrom(clazz)) continue;
            if (_collections[i] == (class$java$util$Hashtable == null ? Introspector.class$("java.util.Hashtable") : class$java$util$Hashtable)) {
                return true;
            }
            if (!_collections[i].getName().equals(MAP)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDescriptable(Class type) {
        if (type == Void.class || type == Class.class) {
            return false;
        }
        if (!(type.isInterface() || type == Object.class || Introspector.isPrimitive(type) || type.isArray())) {
            try {
                type.getConstructor(EMPTY_CLASS_ARGS);
            }
            catch (NoSuchMethodException e) {
                return CoreDescriptors.getDescriptor(type) != null;
            }
        }
        return true;
    }

    private static boolean isPrimitive(Class type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type == Boolean.class || type == Character.class) {
            return true;
        }
        return type.getSuperclass() == Number.class;
    }

    private static Class[] loadCollections() {
        Vector collections = new Vector(6);
        collections.addElement(Vector.class);
        collections.addElement(Enumeration.class);
        collections.addElement(Hashtable.class);
        ClassLoader loader = Vector.class.getClassLoader();
        Class<?> clazz = null;
        try {
            clazz = loader != null ? loader.loadClass(LIST) : Class.forName(LIST);
        }
        catch (ClassNotFoundException cnfx) {
            // empty catch block
        }
        if (clazz != null) {
            collections.addElement(clazz);
            clazz = null;
            try {
                clazz = loader != null ? loader.loadClass(MAP) : Class.forName(MAP);
                if (clazz != null) {
                    collections.addElement(clazz);
                }
                if ((clazz = loader != null ? loader.loadClass(SET_COLLECTION) : Class.forName(SET_COLLECTION)) != null) {
                    collections.addElement(clazz);
                }
            }
            catch (ClassNotFoundException cnfx) {
                // empty catch block
            }
        }
        Object[] classes = new Class[collections.size()];
        collections.copyInto(classes);
        return classes;
    }

    class MethodSet {
        Method add = null;
        Method create = null;
        Method get = null;
        Method set = null;
        String fieldName = null;

        MethodSet(String fieldName) {
            this.fieldName = fieldName;
        }
    }

    class IdentityConvertor
    implements TypeConvertor {
        IdentityConvertor() {
        }

        public Object convert(Object object, String param) throws ClassCastException {
            return object;
        }
    }
}

