/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer;

import java.util.Arrays;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CAMDetailHandler
extends DefaultHandler {
    private static final String BUS_NAMESPACE = "http://developer.cognos.com/schemas/bibus/3/";
    private final int[] errorcode;
    private boolean inerrorcode = false;
    private final List<String> messages;
    private boolean inmessage = false;
    private boolean inCAM = false;

    public CAMDetailHandler(int[] errorcode, List<String> messages) {
        this.errorcode = errorcode;
        this.messages = messages;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inmessage) {
            this.messages.add(new String(Arrays.copyOfRange(ch, start, start + length)));
        } else if (this.inerrorcode) {
            this.errorcode[0] = Integer.decode(new String(Arrays.copyOfRange(ch, start, start + length)));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.inerrorcode = false;
        this.inmessage = false;
        if (localName.equals("CAM")) {
            this.inCAM = false;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (BUS_NAMESPACE.equals(uri) || "".equals(uri)) {
            if (this.inCAM) {
                if (localName.equals("messageString")) {
                    this.inmessage = true;
                } else if (localName.equals("errorCode")) {
                    this.inerrorcode = true;
                }
            } else if (localName.equals("CAM")) {
                this.inCAM = true;
            }
        }
    }
}

