/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.cps.common.utils.HmacSHA;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionHandler;
import com.cognos.cps.wsrp.consumer.CacheHandler;
import com.cognos.cps.wsrp.consumer.ObjectHandler;
import com.cognos.cps.wsrp.consumer.ObjectHandlerDefault;
import com.cognos.cps.wsrp.consumer.RequestContext;
import com.cognos.cps.wsrp.consumer.URLRewriteHandler;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javax.servlet.http.Cookie;

public abstract class RequestContextDefault
implements RequestContext {
    private String m_fromMode;
    private String m_toMode;
    protected ServiceLogger m_logger;
    protected ObjectHandler m_objectHandler;
    protected CacheHandler m_cacheHandler;
    protected CSSClassSubstitutionHandler m_cssClassSubstitutionHandler;
    protected URLRewriteHandler m_urlRewriteHandler;
    protected String m_wsdlUrl;

    public String getGatewayUrlPropertyName() {
        return ObjectHandlerDefault.getPropertyGatewayUrl_Static();
    }

    @Override
    public String getGatewayHostValue() {
        String gatewayValue = this.getObjectHandler().getConfigProperty(this.getGatewayUrlPropertyName());
        String server = RequestContextDefault.getHostFromUrl(gatewayValue);
        if (server == null) {
            server = RequestContextDefault.getHostFromUrl(this.m_wsdlUrl);
        }
        return server;
    }

    public static String getHostFromUrl(String url) {
        int end;
        int index;
        int start;
        String host = null;
        if (url != null && (start = url.indexOf("://")) != -1 && (index = (host = (end = url.indexOf("/", start + 3)) != -1 ? url.substring(start + 3, end) : url.substring(start + 3)).indexOf(":")) != -1) {
            host = host.substring(0, index);
        }
        return host;
    }

    @Override
    public void setOverideMode(String mode, String replaceToMode) {
        this.m_fromMode = mode;
        this.m_toMode = replaceToMode;
    }

    @Override
    public String getOverideMode(String mode) {
        if (mode != null && mode.equals(this.m_fromMode)) {
            return this.m_toMode;
        }
        return null;
    }

    @Override
    public ServiceLogger getLogger() {
        return this.m_logger;
    }

    @Override
    public CSSClassSubstitutionHandler getCSSClassSubstitutionHandler() {
        return this.m_cssClassSubstitutionHandler;
    }

    protected Cookie getAuthCookie(String username, String secret, String cookieName) {
        String authCookie;
        block9: {
            authCookie = null;
            if (secret == null || secret.length() == 0) {
                authCookie = username;
            } else {
                String currentTime = String.valueOf(new Date().getTime());
                String hmac_text = new StringBuffer(username).append(" ").append(currentTime).toString();
                try {
                    String hmac = HmacSHA.create((String)hmac_text, (String)secret);
                    authCookie = new StringBuffer(hmac_text).append(" ").append(hmac).toString();
                }
                catch (InvalidKeyException e) {
                    this.m_logger.error("Exception while creating authentication Cookie", (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    this.m_logger.error("Exception while creating authentication Cookie", (Throwable)e);
                }
            }
            try {
                authCookie = EncodingUtils.urlEncode((String)authCookie, (String)"UTF-8", (boolean)false);
            }
            catch (NullPointerException e) {
                if (this.m_logger.isErrorEnabled()) {
                    this.m_logger.error("Error while encoding the authorization cookie '" + authCookie + "'", (Throwable)e);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (!this.m_logger.isErrorEnabled()) break block9;
                this.m_logger.error("Error while encoding the authorization cookie '" + authCookie + "'", (Throwable)e);
            }
        }
        return new Cookie(cookieName, authCookie);
    }
}

