/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SelectiveXMLDiff {
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String SCHEMA_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String MARKUP = "markup";
    private static final String MARKUPSTRING = "markupString";
    private SAXParserFactory m_parserFactory = SAXParserFactory.newInstance();
    private ArrayList ignoreTagList;

    public SelectiveXMLDiff() {
        this.m_parserFactory.setNamespaceAware(true);
        this.ignoreTagList = new ArrayList();
        this.addIgnoreTag(MARKUP);
        this.addIgnoreTag(MARKUPSTRING);
        try {
            this.m_parserFactory.setFeature(NAMESPACE_FEATURE, true);
            this.m_parserFactory.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void addIgnoreTag(String aTagName) {
        this.ignoreTagList.add(aTagName);
    }

    public static boolean areEqual(String input1, String input2) {
        SelectiveXMLDiff xmldiff = new SelectiveXMLDiff();
        try {
            return xmldiff.areEqual(new StringReader(input1), new StringReader(input2));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private String readerToString(Reader reader) throws IOException {
        int read;
        StringBuffer buffer = new StringBuffer();
        char[] buff = new char[1024];
        while ((read = reader.read(buff)) != -1) {
            buffer.append(buff, 0, read);
        }
        return buffer.toString();
    }

    public boolean areEqual(Reader input1, Reader input2) throws IOException {
        try {
            boolean areEqual;
            String xml1 = this.readerToString(input1);
            input1 = new StringReader(xml1);
            String xml2 = this.readerToString(input2);
            input2 = new StringReader(xml2);
            String normalizedInput1 = this.normalize(input1);
            String normalizedInput2 = this.normalize(input2);
            int i = 0;
            for (i = 0; i < normalizedInput1.length() && normalizedInput1.charAt(i) == normalizedInput2.charAt(i); ++i) {
            }
            boolean bl = areEqual = i == normalizedInput1.length() && normalizedInput1.length() == normalizedInput1.length();
            if (!areEqual) {
                System.out.println("*****************************");
                System.out.println("*****************************");
                System.out.println("XML INPUT1: ");
                System.out.println(xml1);
                System.out.println("XML INPUT2: ");
                System.out.println(xml2);
                System.out.println("*****************************");
                System.out.println("*****************************");
            }
            return areEqual;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String normalize(Reader input) throws SAXException, IOException {
        XMLReader reader = null;
        try {
            SAXParser parser = null;
            SAXParserFactory sAXParserFactory = this.m_parserFactory;
            synchronized (sAXParserFactory) {
                parser = this.m_parserFactory.newSAXParser();
            }
            reader = parser.getXMLReader();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        XMLNormalizerContentHandler xmlNormalizer = new XMLNormalizerContentHandler();
        reader.setContentHandler(xmlNormalizer);
        reader.parse(new InputSource(input));
        return xmlNormalizer.getResult();
    }

    private class XMLNormalizerContentHandler
    extends DefaultHandler {
        private StringBuffer m_normalizedNonXML = new StringBuffer();
        private Stack m_inScopeNamespaces = new Stack();
        private boolean isIgnored = false;
        private boolean ignorePrefixing = false;

        public String getResult() {
            return this.m_normalizedNonXML.toString();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.isIgnored) {
                return;
            }
            block5: for (int i = start; i < start + length; ++i) {
                switch (ch[i]) {
                    case '\n': {
                        continue block5;
                    }
                    case '\t': {
                        continue block5;
                    }
                    case ' ': {
                        continue block5;
                    }
                    default: {
                        this.m_normalizedNonXML.append(ch[i]);
                    }
                }
            }
        }

        private boolean isIgnoreableTag(String tagName) {
            return SelectiveXMLDiff.this.ignoreTagList.contains(tagName);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            if (this.isIgnored || this.isIgnoreableTag(localName)) {
                this.isIgnored = true;
                return;
            }
            this.m_normalizedNonXML.append('|');
            this.m_normalizedNonXML.append(uri);
            this.m_normalizedNonXML.append('|');
            this.m_normalizedNonXML.append(localName);
            this.m_normalizedNonXML.append('|');
            if (atts.getLength() > 0) {
                TreeMap<String, String> sortedAtts = new TreeMap<String, String>();
                int attlen = atts.getLength();
                for (int i = 0; i < attlen; ++i) {
                    boolean added = false;
                    if (atts.getValue(i).indexOf(58) != -1) {
                        int colonPos = atts.getValue(i).indexOf(58);
                        String prefix = atts.getValue(i).substring(0, colonPos);
                        Object[] mapping2 = null;
                        for (Object[] mapping2 : this.m_inScopeNamespaces) {
                            if (!prefix.equals(mapping2[0])) continue;
                            sortedAtts.put(atts.getURI(i) + atts.getLocalName(i), mapping2[1] + atts.getValue(i).substring(colonPos + 1));
                            added = true;
                            break;
                        }
                    }
                    if (added || atts.getURI(i).equals(SelectiveXMLDiff.SCHEMA_NAMESPACE_URI)) continue;
                    sortedAtts.put(atts.getURI(i) + atts.getLocalName(i), atts.getValue(i));
                }
                Iterator it = sortedAtts.entrySet().iterator();
                Map.Entry entry = null;
                while (it.hasNext()) {
                    entry = it.next();
                    this.m_normalizedNonXML.append(entry.getKey());
                    this.m_normalizedNonXML.append('|');
                    this.m_normalizedNonXML.append(entry.getValue());
                    this.m_normalizedNonXML.append('|');
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.isIgnored) {
                this.isIgnored = false;
                return;
            }
            this.m_normalizedNonXML.append("/");
            this.m_normalizedNonXML.append(uri);
            this.m_normalizedNonXML.append('|');
            this.m_normalizedNonXML.append(localName);
            this.m_normalizedNonXML.append('|');
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            if (this.isIgnored) {
                this.ignorePrefixing = true;
                return;
            }
            this.m_inScopeNamespaces.push(new Object[]{prefix, uri});
        }

        @Override
        public void endPrefixMapping(String prefix) {
            if (this.ignorePrefixing) {
                this.ignorePrefixing = false;
                return;
            }
            this.m_inScopeNamespaces.pop();
        }
    }
}

