/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.soap.helpers;

import com.cognos.cps.common.io.EnhancedIOException;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.sax.EnhancedSAXException;
import com.cognos.cps.soap.SOAPConnection;
import com.cognos.cps.soap.SOAPEnvelopeContentHandler;
import com.cognos.cps.soap.SOAPFault;
import com.cognos.cps.soap.SOAPMessage;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.cps.soap.helpers.SOAPLoggerImpl;
import com.cognos.cps.soap.helpers.SOAPObjectHandlerImpl;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SOAPConnectionImpl
implements ErrorHandler,
SOAPConnection {
    public static final String XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
    public static final String SOAP_ENV_OPEN = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
    public static final String SOAP_ENV_CLOSE = "</SOAP-ENV:Envelope>";
    public static final String SOAP_BODY_OPEN = "<SOAP-ENV:Body>";
    public static final String SOAP_BODY_CLOSE = "</SOAP-ENV:Body>";
    public static final String SOAP_HEADER_OPEN = "<SOAP-ENV:Header>";
    public static final String SOAP_HEADER_CLOSE = "</SOAP-ENV:Header>";
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    private static SAXParserFactory m_parserFactory = null;
    protected HttpURLConnection m_connection;
    protected SOAPObjectHandler m_soapObjectHandler;
    protected SOAPObjectHandler m_soapHeaderHandler;
    protected ServiceLogger m_logger;

    public SOAPConnectionImpl() {
        this.m_soapObjectHandler = new SOAPObjectHandlerImpl();
        this.m_logger = new SOAPLoggerImpl();
    }

    public SOAPConnectionImpl(SOAPObjectHandler soapObjectHandler, ServiceLogger logger) {
        this.m_soapObjectHandler = soapObjectHandler;
        this.m_soapHeaderHandler = new SOAPObjectHandlerImpl();
        this.m_logger = logger;
    }

    public SOAPConnectionImpl(SOAPObjectHandler soapObjectHandler, SOAPObjectHandler soapHeaderHandler, ServiceLogger logger) {
        this.m_soapObjectHandler = soapObjectHandler;
        this.m_soapHeaderHandler = soapHeaderHandler;
        this.m_logger = logger;
    }

    @Override
    public SOAPMessage call(SOAPMessage requestMsg, String url) throws MalformedURLException, IOException, SOAPFault, SAXException {
        InputStream input;
        block9: {
            this.m_connection = this.openConnection(url != null ? new URL(url) : null);
            this.m_connection.setRequestMethod("POST");
            this.m_connection.setUseCaches(true);
            this.m_connection.setDoOutput(true);
            this.m_connection.setDoInput(true);
            this.m_connection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            QName bodyRootElemName = requestMsg.getBodyRootElemName();
            if (bodyRootElemName != null) {
                String soapAction = bodyRootElemName.getLocalPart();
                if (bodyRootElemName.getNamespaceURI() != null && bodyRootElemName.getNamespaceURI().length() > 0) {
                    soapAction = bodyRootElemName.getNamespaceURI().startsWith("http://") ? bodyRootElemName.getNamespaceURI() + "#" + soapAction : bodyRootElemName.getNamespaceURI() + ":" + soapAction;
                }
                this.m_connection.setRequestProperty("SOAPAction", soapAction);
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug("SOAPAction: " + soapAction);
                }
            }
            this.sendRequest(requestMsg);
            input = null;
            try {
                input = new BufferedInputStream(this.m_connection.getInputStream());
            }
            catch (IOException e) {
                if (this.m_logger.isErrorEnabled()) {
                    this.m_logger.error("Errow while attempting to retrieve InputStream from connection, trying ErrorStream.", e);
                }
                if ((input = this.m_connection.getErrorStream()) != null) break block9;
                if (this.m_logger.isErrorEnabled()) {
                    this.m_logger.error("Failed to retrieve ErrorStream.");
                }
                throw e;
            }
        }
        if (this.m_connection.getResponseCode() >= 400 && this.m_connection.getResponseCode() != 500) {
            if (this.m_logger.isErrorEnabled()) {
                this.m_logger.error("HTTP error response code '" + this.m_connection.getResponseCode() + "' received: " + this.m_connection.getResponseMessage());
            }
            throw new EnhancedIOException("cps.soap.httperrorreturned", new String[]{new String(this.m_connection.getResponseCode() + " : " + this.m_connection.getResponseMessage()), this.m_connection.getResponseMessage()});
        }
        return this.readResponse(input);
    }

    protected boolean isDebug() {
        return this.m_logger.isDebugEnabled();
    }

    private void sendRequest(SOAPMessage requestMsg) throws IOException, UnsupportedEncodingException {
        OutputStream output = this.m_connection.getOutputStream();
        if (this.isDebug()) {
            Writer writerOutput = new CharArrayWriter();
            this.writeRequest(requestMsg, writerOutput, true);
            char[] request = ((CharArrayWriter)writerOutput).toCharArray();
            this.writeRequestLog(request);
            writerOutput = new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
            writerOutput.write(request);
            writerOutput.flush();
        } else {
            BufferedWriter writerOutput = new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
            this.writeRequest(requestMsg, writerOutput, true);
            ((Writer)writerOutput).flush();
        }
        output.close();
    }

    protected void writeRequestLog(char[] request) {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("SOAP Request: " + new String(request));
        }
    }

    @Override
    public void disconnect() {
        this.m_connection.disconnect();
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        if (url != null) {
            return (HttpURLConnection)url.openConnection();
        }
        return null;
    }

    protected void writeRequest(SOAPMessage requestMsg, Writer output, boolean includeXmlProlog) throws IOException {
        long start = 0L;
        if (this.m_logger.isInfoEnabled()) {
            start = System.currentTimeMillis();
        }
        if (includeXmlProlog) {
            output.write(XML_PROLOG);
        }
        output.write(SOAP_ENV_OPEN);
        output.write(SOAP_HEADER_OPEN);
        if (this.m_soapObjectHandler != null) {
            Object[] headers = requestMsg.getHeaders();
            for (int i = 0; i < headers.length; ++i) {
                Object header = headers[i];
                this.m_soapHeaderHandler.serialize(header, output);
            }
        }
        output.write(SOAP_HEADER_CLOSE);
        output.write(SOAP_BODY_OPEN);
        if (this.m_soapObjectHandler != null) {
            this.m_soapObjectHandler.serialize(requestMsg.getBody(), output, requestMsg.getBodyRootElemName());
        }
        output.write(SOAP_BODY_CLOSE);
        output.write(SOAP_ENV_CLOSE);
        output.flush();
        if (this.m_logger.isInfoEnabled()) {
            long end = System.currentTimeMillis();
            this.m_logger.info("Serialize request took: " + (end - start) + "ms.");
        }
    }

    protected SOAPMessage readResponse(InputStream in) throws IOException, SOAPFault, SAXException {
        in = this.logResponse(in);
        long start = 0L;
        if (this.m_logger.isInfoEnabled()) {
            start = System.currentTimeMillis();
        }
        SOAPMessage response = new SOAPMessage();
        try {
            XMLReader reader = SOAPConnectionImpl.createXMLReader();
            reader.setContentHandler(new SOAPEnvelopeContentHandler(this.m_soapObjectHandler, this.m_soapHeaderHandler, response));
            reader.parse(new InputSource(in));
        }
        catch (SAXException e) {
            Exception rootCause = e.getException();
            if (rootCause instanceof SOAPFault) {
                throw (SOAPFault)rootCause;
            }
            throw e;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace(System.err);
            throw new IOException(e.getMessage());
        }
        if (this.m_logger.isInfoEnabled()) {
            long end = System.currentTimeMillis();
            this.m_logger.info("Deserialize request took: " + (end - start) + "ms.");
        }
        return response;
    }

    private InputStream logResponse(InputStream in) throws IOException {
        if (this.isDebug()) {
            ByteArrayOutputStream bio = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int bytesRead = in.read(buf, 0, 4096);
            while (bytesRead != -1) {
                bio.write(buf, 0, bytesRead);
                bytesRead = in.read(buf, 0, 4096);
            }
            byte[] response = bio.toByteArray();
            this.writeResponseLog(response);
            in = new ByteArrayInputStream(response);
        }
        return in;
    }

    protected void writeResponseLog(byte[] response) {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("SOAP Response: " + new String(response));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static XMLReader createXMLReader() throws SAXException, ParserConfigurationException {
        SAXParser parser = null;
        SAXParserFactory sAXParserFactory = m_parserFactory;
        synchronized (sAXParserFactory) {
            parser = m_parserFactory.newSAXParser();
        }
        return parser.getXMLReader();
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw new EnhancedSAXException("cps.soap.parseresponsefailed", new String[]{String.valueOf(e.getLineNumber())}, e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw new EnhancedSAXException("cps.soap.parseresponsefailed", new String[]{String.valueOf(e.getLineNumber())}, e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
    }

    static {
        m_parserFactory = SAXParserFactory.newInstance();
        try {
            m_parserFactory.setFeature(NAMESPACE_FEATURE, true);
            m_parserFactory.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
            m_parserFactory.setFeature(VALIDATION_FEATURE, false);
        }
        catch (SAXNotRecognizedException e) {
            m_parserFactory.setNamespaceAware(true);
        }
        catch (SAXNotSupportedException e) {
            m_parserFactory.setNamespaceAware(true);
        }
        catch (ParserConfigurationException e) {
            m_parserFactory.setNamespaceAware(true);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
    }
}

