/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public abstract class XSType {
    public static final String STRING_NAME = "string";
    public static final String BOOLEAN_NAME = "boolean";
    public static final String FLOAT_NAME = "float";
    public static final String DOUBLE_NAME = "double";
    public static final String DECIMAL_NAME = "decimal";
    public static final String DURATION_NAME = "duration";
    public static final String DATETIME_NAME = "dateTime";
    public static final String TIME_NAME = "time";
    public static final String DATE_NAME = "date";
    public static final String GYEARMONTH_NAME = "gYearMonth";
    public static final String GYEAR_NAME = "gYear";
    public static final String GMONTHDAY_NAME = "gMonthDay";
    public static final String GDAY_NAME = "gDay";
    public static final String GMONTH_NAME = "gMonth";
    public static final String HEXBINARY_NAME = "hexBinary";
    public static final String BASE64BINARY_NAME = "base64Binary";
    public static final String ANYURI_NAME = "anyURI";
    public static final String QNAME_NAME = "QName";
    public static final String NOTATION_NAME = "NOTATION";
    public static final String NORMALIZEDSTRING_NAME = "normalizedString";
    public static final String TOKEN_NAME = "token";
    public static final String LANGUAGE_NAME = "language";
    public static final String IDREFS_NAME = "IDREFS";
    public static final String NMTOKEN_NAME = "NMTOKEN";
    public static String NMTOKENS_NAME = "NMTOKENS";
    public static final String NAME_NAME = "Name";
    public static final String NCNAME_NAME = "NCName";
    public static final String ID_NAME = "ID";
    public static final String IDREF_NAME = "IDREF";
    public static final String INTEGER_NAME = "integer";
    public static final String NON_NEGATIVE_INTEGER_NAME = "nonNegativeInteger";
    public static final String NON_POSITIVE_INTEGER_NAME = "nonPositiveInteger";
    public static final String NEGATIVE_INTEGER_NAME = "negativeInteger";
    public static final String LONG_NAME = "long";
    public static final String INT_NAME = "int";
    public static final String SHORT_NAME = "short";
    public static final String BYTE_NAME = "byte";
    public static final String POSITIVE_INTEGER_NAME = "positiveInteger";
    public static final short NULL = -1;
    public static final short CLASS = 0;
    public static final short STRING_TYPE = 1;
    public static final short DURATION_TYPE = 2;
    public static final short DATETIME_TYPE = 3;
    public static final short TIME_TYPE = 4;
    public static final short DATE_TYPE = 5;
    public static final short GYEARMONTH_TYPE = 6;
    public static final short GYEAR_TYPE = 7;
    public static final short GMONTHDAY_TYPE = 8;
    public static final short GDAY_TYPE = 9;
    public static final short GMONTH_TYPE = 10;
    public static final short BOOLEAN_TYPE = 11;
    public static final short BASE64BINARY_TYPE = 12;
    public static final short HEXBINARY_TYPE = 13;
    public static final short FLOAT_TYPE = 14;
    public static final short DOUBLE_TYPE = 15;
    public static final short DECIMAL_TYPE = 16;
    public static final short ANYURI_TYPE = 17;
    public static final short QNAME_TYPE = 18;
    public static final short NOTATION_TYPE = 19;
    public static final short NORMALIZEDSTRING_TYPE = 20;
    public static final short TOKEN_TYPE = 21;
    public static final short LANGUAGE_TYPE = 22;
    public static final short NAME_TYPE = 23;
    public static final short NCNAME_TYPE = 24;
    public static final short ID_TYPE = 25;
    public static final short IDREF_TYPE = 26;
    public static final short IDREFS_TYPE = 27;
    public static final short ENTITY = 28;
    public static final short ENTITIES = 29;
    public static final short NMTOKEN_TYPE = 30;
    public static final short NMTOKENS_TYPE = 31;
    public static final short INTEGER_TYPE = 32;
    public static final short NON_POSITIVE_INTEGER_TYPE = 33;
    public static final short NEGATIVE_INTEGER_TYPE = 34;
    public static final short LONG_TYPE = 35;
    public static final short INT_TYPE = 36;
    public static final short SHORT_TYPE = 37;
    public static final short BYTE_TYPE = 38;
    public static final short NON_NEGATIVE_INTEGER_TYPE = 39;
    public static final short POSITIVE_INTEGER_TYPE = 44;
    public static final short COLLECTION = 45;
    private short type = (short)-1;
    private boolean enumerated = false;

    protected XSType(short type) {
        this.type = type;
    }

    public abstract JType getJType();

    public abstract void setFacets(SimpleType var1);

    public short getType() {
        return this.type;
    }

    protected static Enumeration getFacets(SimpleType simpleType) {
        Hashtable<String, Facet> hashTable = new Hashtable<String, Facet>();
        Enumeration theEnum = simpleType.getFacets();
        while (theEnum.hasMoreElements()) {
            Facet facet = (Facet)theEnum.nextElement();
            String name = facet.getName();
            hashTable.put(name, facet);
        }
        return hashTable.elements();
    }

    public String createToJavaObjectCode(String variableName) {
        return variableName;
    }

    public String newInstanceCode() {
        return "new " + this.getJType().getName() + "();";
    }

    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer();
        JType jType = this.getJType();
        if (jType != null) {
            sb.append('(');
            sb.append(jType.toString());
            sb.append(") ");
        }
        sb.append(variableName);
        return sb.toString();
    }

    public boolean isEnumerated() {
        return this.enumerated;
    }

    public boolean isPrimitive() {
        switch (this.type) {
            case 11: 
            case 14: 
            case 15: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: {
                return true;
            }
        }
        return false;
    }

    public boolean isDateTime() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public String getName() {
        switch (this.type) {
            case 1: {
                return STRING_NAME;
            }
            case 2: {
                return DURATION_NAME;
            }
            case 3: {
                return DATETIME_NAME;
            }
            case 4: {
                return TIME_NAME;
            }
            case 5: {
                return DATE_NAME;
            }
            case 6: {
                return GYEARMONTH_NAME;
            }
            case 7: {
                return GYEAR_NAME;
            }
            case 8: {
                return GMONTHDAY_NAME;
            }
            case 9: {
                return GDAY_NAME;
            }
            case 10: {
                return GMONTH_NAME;
            }
            case 11: {
                return BOOLEAN_NAME;
            }
            case 12: {
                return BASE64BINARY_NAME;
            }
            case 13: {
                return HEXBINARY_NAME;
            }
            case 14: {
                return FLOAT_NAME;
            }
            case 15: {
                return DOUBLE_NAME;
            }
            case 16: {
                return DECIMAL_NAME;
            }
            case 17: {
                return ANYURI_NAME;
            }
            case 18: {
                return QNAME_NAME;
            }
            case 20: {
                return NORMALIZEDSTRING_NAME;
            }
            case 21: {
                return TOKEN_NAME;
            }
            case 22: {
                return LANGUAGE_NAME;
            }
            case 23: {
                return NAME_NAME;
            }
            case 24: {
                return NCNAME_NAME;
            }
            case 25: {
                return ID_NAME;
            }
            case 26: {
                return IDREF_NAME;
            }
            case 27: {
                return IDREFS_NAME;
            }
            case 31: {
                return NMTOKENS_NAME;
            }
            case 30: {
                return NMTOKEN_NAME;
            }
            case 32: {
                return INTEGER_NAME;
            }
            case 33: {
                return NON_POSITIVE_INTEGER_NAME;
            }
            case 34: {
                return NEGATIVE_INTEGER_NAME;
            }
            case 35: {
                return LONG_NAME;
            }
            case 36: {
                return INTEGER_NAME;
            }
            case 37: {
                return SHORT_NAME;
            }
            case 38: {
                return BYTE_NAME;
            }
            case 39: {
                return NON_NEGATIVE_INTEGER_NAME;
            }
            case 44: {
                return POSITIVE_INTEGER_NAME;
            }
            case 45: {
                short type = ((XSList)this).getContentType().getType();
                if (type == 30) {
                    return NMTOKENS_NAME;
                }
                if (type != 26) break;
                return IDREFS_NAME;
            }
        }
        return null;
    }

    public void setAsEnumerated(boolean enumerated) {
        this.enumerated = enumerated;
    }

    public abstract void validationCode(JSourceCode var1, String var2, String var3);

    protected static String escapePattern(String str) {
        if (str == null) {
            return str;
        }
        if (str.indexOf(92) < 0 && str.indexOf(34) < 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch == '\\') {
                sb.append(ch);
            }
            if (ch == '\"') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

