/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml.mozilla;

import java.util.Enumeration;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchResults;
import org.exolab.castor.dsml.Consumer;
import org.exolab.castor.dsml.Exporter;
import org.exolab.castor.dsml.ImportExportException;
import org.exolab.castor.dsml.mozilla.MozillaConsumer;
import org.exolab.castor.dsml.mozilla.MozillaProducer;
import org.exolab.castor.util.Messages;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class MozillaExporter
extends Exporter {
    private LDAPConnection _conn;

    public MozillaExporter(LDAPConnection conn) {
        this._conn = conn;
    }

    protected Consumer createConsumer() {
        return new MozillaConsumer();
    }

    public void export(DocumentHandler docHandler, boolean serverSchema, boolean importPolicy) throws ImportExportException {
        LDAPSearchResults theEnum;
        if (this.getSearchDescriptor() == null) {
            throw new IllegalStateException(Messages.message("dsml.searchDescriptorRequired"));
        }
        String[] attrs = this.getSearchDescriptor().getReturnAttrs();
        try {
            int scope = this.getSearchDescriptor().getScope();
            switch (scope) {
                case 0: {
                    scope = 1;
                    break;
                }
                case 1: {
                    scope = 0;
                    break;
                }
                case 3: {
                    scope = 2;
                }
            }
            theEnum = this._conn.search(this.getSearchDescriptor().getBaseDN(), scope, this.getSearchDescriptor().getFilter(), attrs, false);
        }
        catch (LDAPException except) {
            if (except.getLDAPResultCode() != 32) {
                throw new ImportExportException((Exception)((Object)except));
            }
            theEnum = null;
        }
        try {
            MozillaProducer producer = new MozillaProducer(docHandler, false);
            producer.startDocument();
            if (serverSchema) {
                LDAPSchema schema = new LDAPSchema();
                schema.fetchSchema(this._conn);
                producer.produce(schema);
            }
            if (theEnum != null) {
                producer.produce((Enumeration)theEnum);
            }
            if (importPolicy && this.getImportDescriptor() != null) {
                producer.produce(this.getImportDescriptor());
            }
            producer.endDocument();
        }
        catch (SAXException except) {
            throw new ImportExportException(except);
        }
        catch (LDAPException except) {
            throw new ImportExportException((Exception)((Object)except));
        }
    }
}

