/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.KeyGeneratorFactoryRegistry;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.KeyGeneratorFactory;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Logger;
import org.exolab.castor.util.Messages;

final class KeyGeneratorRegistry {
    private static Log _log = LogFactory.getFactory().getInstance(KeyGeneratorRegistry.class);
    private Hashtable _keyGens = new Hashtable();

    KeyGeneratorRegistry() {
    }

    public KeyGenerator getKeyGenerator(PersistenceFactory factory, KeyGeneratorDescriptor desc, int sqlType) throws MappingException {
        String keyGenName = desc.getName() + " " + sqlType;
        KeyGenerator keyGen = (KeyGenerator)this._keyGens.get(keyGenName);
        if (keyGen == null) {
            KeyGeneratorFactory keyGenFactory = KeyGeneratorFactoryRegistry.getKeyGeneratorFactory(desc.getKeyGeneratorFactoryName());
            if (keyGenFactory != null && (keyGen = keyGenFactory.getKeyGenerator(factory, desc.getParams(), sqlType)) != null && _log.isDebugEnabled()) {
                _log.debug((Object)("Key generator " + desc.getKeyGeneratorFactoryName() + " has been instantiated, parameters: " + desc.getParams()));
            }
            if (keyGen == null) {
                Logger.getSystemLogger().println(Messages.format("mapping.noKeyGen", desc.getKeyGeneratorFactoryName()));
                return null;
            }
            this._keyGens.put(keyGenName, keyGen);
        }
        return keyGen;
    }
}

