/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.transactionmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.exolab.castor.jdo.conf.Param;
import org.exolab.castor.jdo.conf.TransactionDemarcation;
import org.exolab.castor.jdo.conf.TransactionManager;
import org.exolab.castor.jdo.engine.JDOConfLoader;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerAcquireException;
import org.exolab.castor.jdo.transactionmanager.TransactionManagerFactory;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.Logger;
import org.exolab.castor.util.Messages;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class TransactionManagerFactoryRegistry {
    private static final String TransactionManagerFactoriesProperty = "org.exolab.castor.jdo.spi.transactionManagerFactories";
    private static Hashtable _factories;
    static /* synthetic */ Class class$org$exolab$castor$jdo$transactionmanager$TransactionManagerFactoryRegistry;

    public static TransactionManagerFactory getTransactionManagerFactory(String name) {
        TransactionManagerFactoryRegistry.load();
        return (TransactionManagerFactory)_factories.get(name);
    }

    public static String[] getTransactionManagerFactoryNames() {
        TransactionManagerFactoryRegistry.load();
        String[] names = new String[_factories.size()];
        Enumeration theEnum = _factories.keys();
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)theEnum.nextElement();
        }
        return names;
    }

    public static Collection getTransactionManagerFactories() {
        TransactionManagerFactoryRegistry.load();
        return Collections.unmodifiableCollection(_factories.keySet());
    }

    public static void load(InputSource source, EntityResolver resolver) throws TransactionManagerAcquireException {
        TransactionManagerFactoryRegistry.load();
        try {
            TransactionDemarcation transactionDemarcation = JDOConfLoader.getTransactionDemarcation(source, resolver);
            if (transactionDemarcation == null) {
                throw new TransactionManagerAcquireException("Problem obtaining transaction manager demarcation configuration");
            }
            String demarcationMode = transactionDemarcation.getMode();
            TransactionManager transactionManager = transactionDemarcation.getTransactionManager();
            if (transactionManager == null) {
                if (!demarcationMode.equals("local")) {
                    throw new TransactionManagerAcquireException("Problem obtaining required transaction manager configuration.");
                }
            } else {
                String mode = transactionManager.getName();
                if (mode == null) {
                    throw new TransactionManagerAcquireException("Attribute MODE for <transaction-manager> required");
                }
                TransactionManagerFactory factory = TransactionManagerFactoryRegistry.getTransactionManagerFactory(mode);
                if (factory == null) {
                    throw new TransactionManagerAcquireException("Invalid value for MODE. Transaction manager factory with MODE = " + mode + "does not exist");
                }
                Properties properties = new Properties();
                Enumeration parameters = transactionManager.enumerateParam();
                while (parameters.hasMoreElements()) {
                    Param param = (Param)parameters.nextElement();
                    properties.put(param.getName(), param.getValue());
                }
                factory.setParams(properties);
            }
        }
        catch (MappingException e) {
            throw new TransactionManagerAcquireException("Problem obtaining JDO configuration", e);
        }
    }

    private static synchronized void load() {
        if (_factories == null) {
            _factories = new Hashtable();
            String prop = LocalConfiguration.getInstance().getProperty(TransactionManagerFactoriesProperty, "");
            StringTokenizer tokenizer = new StringTokenizer(prop, ", ");
            while (tokenizer.hasMoreTokens()) {
                prop = tokenizer.nextToken();
                try {
                    Class<?> cls = (class$org$exolab$castor$jdo$transactionmanager$TransactionManagerFactoryRegistry == null ? TransactionManagerFactoryRegistry.class$("org.exolab.castor.jdo.transactionmanager.TransactionManagerFactoryRegistry") : class$org$exolab$castor$jdo$transactionmanager$TransactionManagerFactoryRegistry).getClassLoader().loadClass(prop);
                    TransactionManagerFactory factory = (TransactionManagerFactory)cls.newInstance();
                    _factories.put(factory.getName(), factory);
                }
                catch (Exception except) {
                    Logger.getSystemLogger().println(Messages.format("transactionManager.missingTransactionManagerFactory", prop));
                }
            }
        }
    }
}

