/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;

public class SimpleTypeValidator
implements TypeValidator {
    private int minOccurs = 0;
    private int maxOccurs = -1;
    private TypeValidator validator = null;

    public SimpleTypeValidator() {
    }

    public SimpleTypeValidator(TypeValidator validator) {
        this.validator = validator;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public void setValidator(TypeValidator validator) {
        this.validator = validator;
    }

    public void validate(Object object, ValidationContext context) throws ValidationException {
        boolean required;
        boolean bl = required = this.minOccurs > 0;
        if (object == null && required) {
            String err = "This field is required and cannot be null.";
            throw new ValidationException(err);
        }
        if (object != null) {
            Class<?> type = object.getClass();
            int size = 1;
            boolean byteArray = false;
            if (type.isArray()) {
                boolean bl2 = byteArray = type.getComponentType() == Byte.TYPE;
                if (!byteArray) {
                    size = Array.getLength(object);
                }
            }
            if (size < this.minOccurs) {
                String err = "A minimum of " + this.minOccurs + " instance(s) of this field are required.";
                throw new ValidationException(err);
            }
            if (this.maxOccurs >= 0 && size > this.maxOccurs) {
                String err = "A maximum of " + this.maxOccurs + " instance(s) of this field are required.";
                throw new ValidationException(err);
            }
            if (this.validator == null) {
                return;
            }
            if (this.isPrimitive(type) || type == String.class) {
                this.validator.validate(object, context);
            } else if (!byteArray) {
                if (type.isArray()) {
                    size = Array.getLength(object);
                    for (int i = 0; i < size; ++i) {
                        this.validator.validate(Array.get(object, i), context);
                    }
                } else if (object instanceof Enumeration) {
                    Enumeration theEnum = (Enumeration)object;
                    while (theEnum.hasMoreElements()) {
                        this.validator.validate(theEnum.nextElement(), context);
                    }
                } else if (object instanceof Vector) {
                    Vector vector = (Vector)object;
                    for (int i = 0; i < vector.size(); ++i) {
                        this.validator.validate(vector.elementAt(i), context);
                    }
                } else {
                    this.validator.validate(object, context);
                }
            }
        }
    }

    private boolean isPrimitive(Class type) {
        if (type.isPrimitive()) {
            return true;
        }
        return type == Boolean.class || type == Byte.class || type == Character.class || type == Double.class || type == Float.class || type == Integer.class || type == Long.class || type == Short.class;
    }
}

