/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.SimpleTypeReference;
import org.exolab.castor.xml.schema.Structure;

public final class AttributeDecl
extends Annotated {
    public static final String USE_OPTIONAL = "optional";
    public static final String USE_PROHIBITED = "prohibited";
    public static final String USE_REQUIRED = "required";
    private static final short OPTIONAL = 3;
    private static final short PROHIBITED = 4;
    private static final short REQUIRED = 5;
    private static String NULL_ARGUMENT = "A null argument was passed to the constructor of " + AttributeDecl.class.getName();
    private Form _form = null;
    private String _id = null;
    private String _name = null;
    private Structure _parent = null;
    private Schema _schema = null;
    private SimpleType _simpleType = null;
    private short _useFlag = (short)3;
    private String _fixed = null;
    private String _default = null;
    private String _attributeRef = null;

    public AttributeDecl(Schema schema, String name) {
        if (schema == null) {
            String err = NULL_ARGUMENT + "; 'schema' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._schema = schema;
        this.setName(name);
    }

    public AttributeDecl(Schema schema) {
        if (schema == null) {
            String err = NULL_ARGUMENT + "; 'schema' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._schema = schema;
    }

    public Form getForm() {
        return this._form;
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean ignoreRef) {
        if (this.isReference() && !ignoreRef) {
            String ncname = this._attributeRef;
            int idx = ncname.indexOf(58);
            if (idx > 0) {
                ncname = ncname.substring(idx + 1);
            }
            return ncname;
        }
        return this._name;
    }

    public Structure getParent() {
        return this._parent;
    }

    public SimpleType getSimpleType() {
        if (this.isReference()) {
            AttributeDecl attribute = this.getReference();
            if (attribute != null) {
                return attribute.getSimpleType();
            }
            return null;
        }
        if (this._simpleType == null) {
            return null;
        }
        return (SimpleType)this._simpleType.getType();
    }

    public AttributeDecl getReference() {
        AttributeDecl result = null;
        if (this._attributeRef != null && (result = this._schema.getAttribute(this._attributeRef)) == null) {
            String err = "Unable to find attribute referenced :\" ";
            err = err + this._attributeRef;
            err = err + "\"";
            throw new IllegalStateException(err);
        }
        return result;
    }

    public String getReferenceName() {
        return this._attributeRef;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String getUse() {
        switch (this._useFlag) {
            case 4: {
                return USE_PROHIBITED;
            }
            case 5: {
                return USE_REQUIRED;
            }
        }
        return USE_OPTIONAL;
    }

    public String getDefaultValue() {
        return this._default;
    }

    public String getFixedValue() {
        return this._fixed;
    }

    public boolean isDefault() {
        return this._default != null && this._default.length() > 0;
    }

    public boolean isFixed() {
        return this._fixed != null && this._fixed.length() > 0;
    }

    public boolean isOptional() {
        String use = this.getUse();
        return use.equals(USE_OPTIONAL);
    }

    public boolean isProhibited() {
        String use = this.getUse();
        return use.equals(USE_PROHIBITED);
    }

    public boolean isRequired() {
        String use = this.getUse();
        return use.equals(USE_REQUIRED);
    }

    public boolean isReference() {
        return this._attributeRef != null;
    }

    public void setForm(Form form) {
        this._form = form;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setName(String name) {
        if (name == null) {
            String err = "AttributeDecl#setName: 'name' must not be null.";
            throw new IllegalArgumentException(err);
        }
        int idx = name.indexOf(58);
        if (idx >= 0) {
            String nsPrefix = name.substring(0, idx);
            name = name.substring(idx + 1);
        }
        if (name.length() == 0) {
            String err = "AttributeDecl#setName: 'name' must not be zero-length.";
            throw new IllegalArgumentException(err);
        }
        this._name = name;
    }

    protected void setParent(Structure parent) {
        if (parent != null) {
            switch (parent.getStructureType()) {
                case 4: 
                case 6: 
                case 19: {
                    break;
                }
                default: {
                    String error = "Invalid parent for group";
                    throw new IllegalArgumentException(error);
                }
            }
        }
        this._parent = parent;
    }

    public void setReference(AttributeDecl reference) {
        this._attributeRef = reference == null ? null : reference.getName();
    }

    public void setReference(String reference) {
        this._attributeRef = reference;
    }

    public void setSimpleType(SimpleType simpleType) {
        this._simpleType = simpleType;
        if (simpleType != null) {
            simpleType.setParent(this);
        }
    }

    public void setSimpleTypeReference(String name) {
        SimpleTypeReference reference = new SimpleTypeReference(this._schema, name);
        this.setSimpleType(reference);
    }

    public void setUse(String value) {
        if (value == null) {
            this._useFlag = (short)3;
            return;
        }
        if (value.equals(USE_REQUIRED)) {
            this._useFlag = (short)5;
        } else if (value.equals(USE_OPTIONAL)) {
            this._useFlag = (short)3;
        } else if (value.equals(USE_PROHIBITED)) {
            this._useFlag = (short)4;
        } else {
            throw new IllegalArgumentException("Invalid value for 'use': " + value);
        }
    }

    public void setDefaultValue(String value) {
        if (this._fixed != null && this._fixed.length() > 0) {
            throw new IllegalStateException("'default' and 'fixed' must not be both present.");
        }
        this._default = value;
    }

    public void setFixedValue(String value) {
        if (this._default != null && this._default.length() > 0) {
            throw new IllegalStateException("'default' and 'fixed' must not be both present.");
        }
        this._fixed = value;
    }

    public short getStructureType() {
        return 3;
    }

    public void validate() throws ValidationException {
        if (this._attributeRef == null && this._name == null) {
            String err = "<attribute> is missing required 'name' attribute.";
            throw new ValidationException(err);
        }
        if (this._attributeRef != null) {
            if (this._schema.getAttribute(this._attributeRef) == null) {
                String err = "<attribute ref=\"" + this._attributeRef + "\"> " + "is not resolvable.";
                throw new ValidationException(err);
            }
            return;
        }
    }
}

