/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.Messages;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.schema.DeferredSimpleType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.SimpleTypesFactoryException;
import org.exolab.castor.xml.schema.simpletypes.AtomicType;
import org.exolab.castor.xml.schema.simpletypes.ListType;
import org.exolab.castor.xml.schema.simpletypes.RealType;
import org.exolab.castor.xml.schema.simpletypes.UrType;
import org.exolab.castor.xml.schema.simpletypes.factory.Type;
import org.exolab.castor.xml.schema.simpletypes.factory.TypeList;
import org.exolab.castor.xml.schema.simpletypes.factory.TypeProperty;
import org.xml.sax.InputSource;

public class SimpleTypesFactory {
    public static final int INVALID_TYPE = -1;
    public static final int USER_TYPE = 0;
    public static final int STRING_TYPE = 1;
    public static final int DURATION_TYPE = 2;
    public static final int DATETIME_TYPE = 3;
    public static final int TIME_TYPE = 4;
    public static final int DATE_TYPE = 5;
    public static final int GYEARMONTH_TYPE = 6;
    public static final int GYEAR_TYPE = 7;
    public static final int GMONTHDAY_TYPE = 8;
    public static final int GDAY_TYPE = 9;
    public static final int GMONTH_TYPE = 10;
    public static final int BOOLEAN_TYPE = 11;
    public static final int BASE64BINARY_TYPE = 12;
    public static final int HEXBINARY_TYPE = 13;
    public static final int FLOAT_TYPE = 14;
    public static final int DOUBLE_TYPE = 15;
    public static final int DECIMAL_TYPE = 16;
    public static final int ANYURI_TYPE = 17;
    public static final int QNAME_TYPE = 18;
    public static final int NOTATION_TYPE = 19;
    public static final int NORMALIZEDSTRING_TYPE = 20;
    public static final int TOKEN_TYPE = 21;
    public static final int LANGUAGE_TYPE = 22;
    public static final int NAME_TYPE = 23;
    public static final int NCNAME_TYPE = 24;
    public static final int ID_TYPE = 25;
    public static final int IDREF_TYPE = 26;
    public static final int IDREFS_TYPE = 27;
    public static final int ENTITY_TYPE = 28;
    public static final int ENTITIES_TYPE = 29;
    public static final int NMTOKEN_TYPE = 30;
    public static final int NMTOKENS_TYPE = 31;
    public static final int INTEGER_TYPE = 32;
    public static final int NON_POSITIVE_INTEGER_TYPE = 33;
    public static final int NEGATIVE_INTEGER_TYPE = 34;
    public static final int LONG_TYPE = 35;
    public static final int INT_TYPE = 36;
    public static final int SHORT_TYPE = 37;
    public static final int BYTE_TYPE = 38;
    public static final int NON_NEGATIVE_INTEGER_TYPE = 39;
    public static final int UNSIGNED_LONG_TYPE = 40;
    public static final int UNSIGNED_INT_TYPE = 41;
    public static final int UNSIGNED_SHORT_TYPE = 42;
    public static final int UNSIGNED_BYTE_TYPE = 43;
    public static final int POSITIVE_INTEGER_TYPE = 44;
    public static final int ANYSIMPLETYPE_TYPE = 100;
    static final String RESOURCE_LOCATION = "/org/exolab/castor/util/resources/";
    static final String TYPE_MAPPINGS = "/org/exolab/castor/util/resources/SimpleTypesMapping.properties";
    static final String TYPE_DEFINITIONS = "/org/exolab/castor/util/resources/SimpleTypes.properties";
    private static Hashtable _typesByName;
    private static Hashtable _typesByCode;
    private static PrintWriter _logWriter;
    private static final Schema _builtInSchema;

    public static boolean isBuiltInType(int codeType) {
        return 0 < codeType;
    }

    public static boolean isPrimitiveType(int codeType) {
        return 1 <= codeType && codeType <= 19;
    }

    public SimpleType getBuiltInType(String typeName) {
        Type type = this.getType(typeName);
        if (type == null) {
            return null;
        }
        return type.getSimpleType();
    }

    public String getBuiltInTypeName(int builtInTypeCode) {
        Type type = this.getType(builtInTypeCode);
        if (type == null) {
            return null;
        }
        return type.getName();
    }

    SimpleType createUserSimpleType(Schema schema, String name, String baseName, String derivation, boolean createDeferredSimpleType) {
        if (baseName == null || baseName.length() == 0) {
            this.sendToLog(Messages.format("schema.noBaseType", name));
            return null;
        }
        SimpleType baseType = schema.getSimpleType(baseName);
        if (baseType == null) {
            if (createDeferredSimpleType) {
                DeferredSimpleType result = new DeferredSimpleType();
                result.setSchema(schema);
                result.setName(name);
                result.setBaseTypeName(baseName);
                result.setDerivationMethod(derivation);
                result.setTypeCode(0);
                return result;
            }
            return null;
        }
        return this.createUserSimpleType(schema, name, baseType, derivation);
    }

    SimpleType createUserSimpleType(Schema schema, String name, SimpleType baseType, String derivation) {
        String internalName = name;
        if (name == null) {
            internalName = "anonymous-simple-type";
        }
        if (baseType == null) {
            this.sendToLog(Messages.format("schema.noBaseType", internalName));
            return null;
        }
        SimpleType result = null;
        if (derivation != null && derivation.equals("list")) {
            try {
                result = new ListType(schema);
            }
            catch (SchemaException sx) {
                this.sendToLog(Messages.format("schema.deriveByListError", internalName, baseType.getName()));
                return null;
            }
            ((ListType)result).setItemType(baseType);
        } else {
            SimpleType builtInBase = baseType.getBuiltInBaseType();
            if (builtInBase == null) {
                this.sendToLog(Messages.format("schema.noBuiltInParent", internalName));
                return null;
            }
            result = this.createInstance(schema, builtInBase.getName());
            if (result == null) {
                throw new SimpleTypesFactoryException(Messages.message("schema.cantLoadBuiltInTypes"));
            }
        }
        result.setSchema(schema);
        result.setName(name);
        result.setBaseType(baseType);
        result.setDerivationMethod(derivation);
        result.setTypeCode(0);
        return result;
    }

    private PrintWriter getLogWriter() {
        return _logWriter;
    }

    private void sendToLog(String message) {
        PrintWriter logger = this.getLogWriter();
        if (logger != null) {
            logger.println(message);
            logger.flush();
        }
    }

    private Type getType(String typeName) {
        if (_typesByName == null) {
            this.loadTypesDefinitions();
        }
        return (Type)_typesByName.get(typeName);
    }

    private Type getType(int typeCode) {
        if (_typesByCode == null) {
            this.loadTypesDefinitions();
        }
        return (Type)_typesByCode.get(new Integer(typeCode));
    }

    private synchronized void loadTypesDefinitions() {
        if (_typesByName == null && _typesByCode == null) {
            InputStream is = null;
            try {
                Mapping mapping = new Mapping(this.getClass().getClassLoader());
                mapping.setLogWriter(this.getLogWriter());
                is = this.getClass().getResourceAsStream(TYPE_MAPPINGS);
                mapping.loadMapping(new InputSource(is));
                Unmarshaller unmarshaller = new Unmarshaller(TypeList.class);
                unmarshaller.setMapping(mapping);
                unmarshaller.setValidation(false);
                is = this.getClass().getResourceAsStream(TYPE_DEFINITIONS);
                TypeList typeList = (TypeList)unmarshaller.unmarshal(new InputSource(is));
                LocalConfiguration config = LocalConfiguration.getInstance();
                if (config.debug() && this.getLogWriter() != null) {
                    typeList.Print(this.getLogWriter());
                }
                Vector types = typeList.getTypes();
                _typesByName = new Hashtable();
                _typesByCode = new Hashtable();
                for (int index = 0; index < types.size(); ++index) {
                    Type type = (Type)types.elementAt(index);
                    _typesByName.put(type.getName(), type);
                    type.setSimpleType(this.createSimpleType(_builtInSchema, type));
                    _typesByCode.put(new Integer(type.getSimpleType().getTypeCode()), type);
                }
            }
            catch (Exception except) {
                String err = Messages.message("schema.cantLoadBuiltInTypes") + "; " + except;
                throw new SimpleTypesFactoryException(except, err);
            }
        }
    }

    private SimpleType createSimpleType(Schema schema, Type type) {
        int intCode;
        SimpleType result = this.createInstance(schema, type.getName());
        if (result == null) {
            String err = Messages.message("schema.cantLoadBuiltInTypes");
            throw new SimpleTypesFactoryException(err);
        }
        result.setName(type.getName());
        try {
            intCode = this.getClass().getDeclaredField(type.getCode()).getInt(null);
        }
        catch (Exception ex) {
            String error = Messages.message("schema.cantLoadBuiltInTypes") + ex;
            throw new SimpleTypesFactoryException(ex, error);
        }
        result.setTypeCode(intCode);
        if (type.getBase() != null) {
            result.setBaseType(this.getType(type.getBase()).getSimpleType());
        }
        Vector facets = type.getFacet();
        for (int index = 0; index < facets.size(); ++index) {
            TypeProperty prop = (TypeProperty)facets.elementAt(index);
            if (!prop.getPseudo()) {
                result.addFacet(new Facet(prop.getName(), prop.getValue()));
                continue;
            }
            if (!new RealType().getClass().isInstance(result)) continue;
            RealType realResult = (RealType)result;
            if (prop.getName().equals("minM")) {
                realResult.setMinMantissa(Long.parseLong(prop.getValue()));
                continue;
            }
            if (prop.getName().equals("maxM")) {
                realResult.setMaxMantissa(Long.parseLong(prop.getValue()));
                continue;
            }
            if (prop.getName().equals("minE")) {
                realResult.setMinExponent(Long.parseLong(prop.getValue()));
                continue;
            }
            if (!prop.getName().equals("maxE")) continue;
            realResult.setMaxExponent(Long.parseLong(prop.getValue()));
        }
        return result;
    }

    private SimpleType createInstance(Schema schema, String builtInTypeName) {
        SimpleType result;
        Type type = this.getType(builtInTypeName);
        String derivation = type.getDerivedBy();
        ListType resultList = null;
        if (derivation != null && derivation.equals("list")) {
            try {
                resultList = new ListType(schema);
            }
            catch (SchemaException sx) {
                throw new SimpleTypesFactoryException(sx);
            }
        }
        Class implClass = null;
        while (type != null) {
            if (type.getImplClass() != null) {
                implClass = type.getImplClass();
                break;
            }
            type = this.getType(type.getBase());
        }
        if (implClass == null) {
            return null;
        }
        if (implClass.isAssignableFrom(UrType.class)) {
            try {
                result = (UrType)implClass.newInstance();
                result.setSchema(schema);
            }
            catch (Exception e) {
                throw new SimpleTypesFactoryException(e);
            }
        }
        try {
            result = (AtomicType)implClass.newInstance();
            result.setSchema(schema);
        }
        catch (Exception except) {
            except.printStackTrace();
            result = null;
        }
        if (resultList != null) {
            resultList.setItemType(result);
            return resultList;
        }
        return result;
    }

    static {
        _logWriter = new PrintWriter(System.out);
        _builtInSchema = new Schema();
    }
}

