/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.i18n;

import com.cognos.i18n.Calendar;
import com.cognos.i18n.TimeZone;
import com.cognos.i18n.ToolkitResources;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DateTimeFormat {
    protected DateFormat m_pFormat;
    public static final int DATE = 10;
    public static final int DATE_TIME = 11;
    public static final int TIME = 12;
    public static final int SHORT = 3;
    public static final int MEDIUM = 2;
    public static final int LONG = 1;
    public static final int FULL = 0;
    public static final int DEFAULT = 2;
    public static final int I18N_LOCATION_NONE = 0;
    public static final int I18N_LOCATION_LEFT = 1;
    public static final int I18N_LOCATION_RIGHT = 2;
    private static int m_objCacheSize = 0;
    private static final int m_objCacheSizeCap = 1000;
    private static Map m_objCache = null;

    private static synchronized void initObjCache() {
        if (m_objCache == null) {
            m_objCache = new ConcurrentHashMap(12);
        }
    }

    private static void addToObjCache(DateFormat dtInstance, String objectType) {
        if (m_objCacheSize == 1000) {
            m_objCache.clear();
            m_objCacheSize = 0;
        }
        m_objCache.put(objectType, dtInstance);
        ++m_objCacheSize;
    }

    private static DateFormat getFromObjCache(ULocale locale, int type, int dateStyle, int timeStyle) {
        StringBuffer objectType = new StringBuffer(locale.getName());
        objectType.append(type);
        objectType.append(dateStyle);
        objectType.append(timeStyle);
        DateFormat dtInstance = null;
        dtInstance = (DateFormat)m_objCache.get(objectType.toString());
        if (dtInstance == null) {
            switch (type) {
                case 11: {
                    dtInstance = DateFormat.getDateTimeInstance((int)dateStyle, (int)timeStyle, (ULocale)locale);
                    break;
                }
                case 12: {
                    dtInstance = DateFormat.getTimeInstance((int)timeStyle, (ULocale)locale);
                    break;
                }
                default: {
                    dtInstance = DateFormat.getDateInstance((int)dateStyle, (ULocale)locale);
                }
            }
            DateTimeFormat.addToObjCache(dtInstance, objectType.toString());
        }
        return (DateFormat)dtInstance.clone();
    }

    private static DateFormat getFromObjCache(String pattern, ULocale locale) {
        StringBuffer objectType = new StringBuffer(locale.getName());
        objectType.append(pattern);
        DateFormat dtInstance = null;
        dtInstance = (DateFormat)m_objCache.get(objectType.toString());
        if (dtInstance == null) {
            dtInstance = new SimpleDateFormat(pattern, locale);
            DateTimeFormat.addToObjCache(dtInstance, objectType.toString());
        }
        return (DateFormat)dtInstance.clone();
    }

    private static DateFormat getFromObjCache(String pattern) {
        DateFormat dtInstance = null;
        dtInstance = (DateFormat)m_objCache.get(pattern);
        if (dtInstance == null) {
            dtInstance = new SimpleDateFormat(pattern);
            DateTimeFormat.addToObjCache(dtInstance, pattern);
        }
        return (DateFormat)dtInstance.clone();
    }

    public DateTimeFormat(Locale locale, int type, int dateStyle, int timeStyle) {
        ULocale theDefaultLocale = null;
        theDefaultLocale = locale == null || locale.getLanguage().length() == 0 ? ToolkitResources.getICUDefaultLocaleForCurrentLocale("") : ToolkitResources.getICUDefaultLocaleForCurrentLocale(locale.toString());
        if (m_objCache == null) {
            DateTimeFormat.initObjCache();
        }
        this.m_pFormat = DateTimeFormat.getFromObjCache(theDefaultLocale, type, dateStyle, timeStyle);
    }

    public DateTimeFormat(Locale locale, int type) {
        this(locale, type, 2, 2);
    }

    public DateTimeFormat(String pattern) {
        if (m_objCache == null) {
            DateTimeFormat.initObjCache();
        }
        this.m_pFormat = DateTimeFormat.getFromObjCache(pattern);
    }

    public DateTimeFormat(String pattern, Locale locale) {
        ULocale theDefaultLocale = null;
        theDefaultLocale = locale == null || locale.getLanguage().length() == 0 ? ToolkitResources.getICUDefaultLocaleForCurrentLocale("") : ToolkitResources.getICUDefaultLocaleForCurrentLocale(locale.toString());
        if (m_objCache == null) {
            DateTimeFormat.initObjCache();
        }
        this.m_pFormat = DateTimeFormat.getFromObjCache(pattern, theDefaultLocale);
    }

    public void setTimeZone(TimeZone timeZone) {
        this.m_pFormat.setTimeZone(com.ibm.icu.util.TimeZone.getTimeZone((String)timeZone.getID()));
    }

    public String format(Calendar calendar) {
        return this.m_pFormat.format((Object)calendar.m_calendar);
    }

    public String format(Date date) {
        return this.m_pFormat.format(date);
    }

    public Calendar parse(String text) throws Exception {
        Calendar calend = new Calendar();
        calend.setTime(this.m_pFormat.parse(text));
        return calend;
    }

    public int getAMPMLocation() {
        int withClock = 104;
        int ampm = 97;
        SimpleDateFormat smplFormatObj = (SimpleDateFormat)this.m_pFormat;
        String pattern = smplFormatObj.toPattern();
        int amInd = pattern.indexOf(ampm);
        if (amInd < 0) {
            return 0;
        }
        int hInd = pattern.indexOf(withClock);
        if (hInd < 0) {
            return 0;
        }
        if (hInd < amInd) {
            return 2;
        }
        return 1;
    }

    public String[] getAmPmStrings() {
        DateFormatSymbols dfs = ((SimpleDateFormat)this.m_pFormat).getDateFormatSymbols();
        return dfs.getAmPmStrings();
    }

    public String[] getEras() {
        DateFormatSymbols dfs = ((SimpleDateFormat)this.m_pFormat).getDateFormatSymbols();
        return dfs.getEras();
    }

    public String[] getMonths() {
        DateFormatSymbols dfs = ((SimpleDateFormat)this.m_pFormat).getDateFormatSymbols();
        return dfs.getMonths();
    }

    public String[] getShortMonths() {
        DateFormatSymbols dfs = ((SimpleDateFormat)this.m_pFormat).getDateFormatSymbols();
        return dfs.getShortMonths();
    }

    public String[] getWeekdays() {
        DateFormatSymbols dfs = ((SimpleDateFormat)this.m_pFormat).getDateFormatSymbols();
        return dfs.getWeekdays();
    }

    public String[] getShortWeekdays() {
        DateFormatSymbols dfs = ((SimpleDateFormat)this.m_pFormat).getDateFormatSymbols();
        return dfs.getShortWeekdays();
    }

    public void setAmPmStrings(String[] newAmpms) {
        DateFormatSymbols dfs = ((SimpleDateFormat)this.m_pFormat).getDateFormatSymbols();
        dfs.setAmPmStrings(newAmpms);
        ((SimpleDateFormat)this.m_pFormat).setDateFormatSymbols(dfs);
    }

    public void setEras(String[] newEras) {
        DateFormatSymbols dfs = ((SimpleDateFormat)this.m_pFormat).getDateFormatSymbols();
        dfs.setAmPmStrings(newEras);
        ((SimpleDateFormat)this.m_pFormat).setDateFormatSymbols(dfs);
    }

    public void setMonths(String[] newMonths) {
        DateFormatSymbols dfs = ((SimpleDateFormat)this.m_pFormat).getDateFormatSymbols();
        dfs.setAmPmStrings(newMonths);
        ((SimpleDateFormat)this.m_pFormat).setDateFormatSymbols(dfs);
    }

    public void setShortMonths(String[] newShortMonths) {
        DateFormatSymbols dfs = ((SimpleDateFormat)this.m_pFormat).getDateFormatSymbols();
        dfs.setAmPmStrings(newShortMonths);
        ((SimpleDateFormat)this.m_pFormat).setDateFormatSymbols(dfs);
    }

    public void setWeekdays(String[] newWeekdays) {
        DateFormatSymbols dfs = ((SimpleDateFormat)this.m_pFormat).getDateFormatSymbols();
        dfs.setAmPmStrings(newWeekdays);
        ((SimpleDateFormat)this.m_pFormat).setDateFormatSymbols(dfs);
    }

    public void setShortWeekdays(String[] newShortWeekdays) {
        DateFormatSymbols dfs = ((SimpleDateFormat)this.m_pFormat).getDateFormatSymbols();
        dfs.setAmPmStrings(newShortWeekdays);
        ((SimpleDateFormat)this.m_pFormat).setDateFormatSymbols(dfs);
    }

    public String getPattern() {
        return ((SimpleDateFormat)this.m_pFormat).toPattern();
    }
}

