/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.jsr286;

import java.util.Arrays;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CAMDetailHandler
extends DefaultHandler {
    private static final String BUS_NAMESPACE = "http://developer.cognos.com/schemas/bibus/3/";
    private final List<String> messages;
    private final List<String> names;
    private final int[] errorcode;
    private boolean inmessage = false;
    private boolean inname = false;
    private boolean incode = false;
    private boolean inCAM = false;

    public CAMDetailHandler(int[] errorcode, List<String> messages, List<String> names) {
        this.messages = messages;
        this.names = names;
        this.errorcode = errorcode;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inmessage) {
            this.messages.add(new String(Arrays.copyOfRange(ch, start, start + length)));
        } else if (this.inname) {
            this.names.add(new String(Arrays.copyOfRange(ch, start, start + length)));
        } else if (this.incode) {
            this.errorcode[0] = Integer.decode(new String(Arrays.copyOfRange(ch, start, start + length)));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.inmessage = false;
        this.inname = false;
        this.incode = false;
        if (localName.equals("CAM")) {
            this.inCAM = false;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (BUS_NAMESPACE.equals(uri) || "".equals(uri)) {
            if (this.inCAM) {
                if ("messageString".equals(localName)) {
                    this.inmessage = true;
                } else if ("name".equals(localName)) {
                    this.inname = true;
                } else if ("errorCode".equals(localName)) {
                    this.incode = true;
                }
            } else if (localName.equals("CAM")) {
                this.inCAM = true;
            }
        }
    }
}

