/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.jsr286;

import com.cognos.cps.common.ExceptionExtension;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.wsrp.v1.types.BlockingInteractionResponse;
import com.cognos.cps.services.wsrp.v1.types.MarkupContext;
import com.cognos.cps.services.wsrp.v1.types.MarkupResponse;
import com.cognos.cps.services.wsrp.v1.types.UpdateResponse;
import com.cognos.cps.wsrp.consumer.CSSClassSubstituter;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionException;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionHandler;
import com.cognos.cps.wsrp.consumer.ConsumerException;
import com.cognos.cps.wsrp.consumer.ErrorPage;
import com.cognos.cps.wsrp.consumer.FixHelper;
import com.cognos.cps.wsrp.consumer.RequestContext;
import com.cognos.cps.wsrp.consumer.RequestHelper;
import com.cognos.cps.wsrp.consumer.RequestHelperFactory;
import com.cognos.cps.wsrp.consumer.URLRewriteException;
import com.cognos.cps.wsrp.consumer.helpers.CSSClassSubstitutionHandlerImpl;
import com.cognos.cps.wsrp.consumer.impls.jsr286.ApplicationSettings;
import com.cognos.cps.wsrp.consumer.impls.jsr286.ApplicationSettingsFactory;
import com.cognos.cps.wsrp.consumer.impls.jsr286.FixHelperImpl;
import com.cognos.cps.wsrp.consumer.impls.jsr286.HttpSOAPConnectionImpl;
import com.cognos.cps.wsrp.consumer.impls.jsr286.RequestContextImpl;
import com.cognos.cps.wsrp.consumer.impls.jsr286.ServiceLoggerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import javax.portlet.WindowState;

public class Consumer
extends GenericPortlet {
    private static final long serialVersionUID = 1L;
    public static final String BLOCKING_INTERACTION_RESPONSE = "BlockingInteractionResponse";
    public static final String EXCEPTION = "ConsumerException";
    public static final String PORTAL_VERSION = "PortalVersion";
    public static final String CONSUMER_REQUESTED_ENCODING = "UTF-8";
    private static final String CSS_MAPPINGS_FILE60 = "/WEB-INF/classes/cssmappings60.properties";
    private ApplicationSettings m_appSettings;
    private ServiceLogger m_logger = null;
    private CSSClassSubstitutionHandler m_cssNameHandler = null;
    private Integer m_portalVersion;

    public void init(PortletConfig portletConfig) throws UnavailableException, PortletException {
        super.init(portletConfig);
        this.m_appSettings = ApplicationSettingsFactory.getInstance().createApplicationSettings(portletConfig);
        this.m_logger = new ServiceLoggerImpl(this.getPortletLog(portletConfig), "[" + this.getPortletName() + "-" + System.currentTimeMillis() + "]");
        this.m_logger.debug("init() called.");
        String containterInfo = this.getPortletContext().getServerInfo();
        this.m_logger.info("Portal version: " + containterInfo);
        this.m_portalVersion = new Integer("61");
        HttpSOAPConnectionImpl.init(portletConfig, this.m_logger);
        this.loadCSSMappings(this.getPortletContext());
        this.m_logger.debug("initConcrete() called.");
        this.initConcrete(this.getPortletContext());
    }

    public void initConcrete(PortletContext settings) throws UnavailableException {
        this.m_logger.debug("initConcrete() called.");
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.m_logger.debug("doView() called.");
        this.handleMarkupRequest((PortletRequest)request, (PortletResponse)response);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.m_logger.debug("doEdit() called.");
        this.handleMarkupRequest((PortletRequest)request, (PortletResponse)response);
    }

    public void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.m_logger.debug("doHelp() called.");
        this.handleMarkupRequest((PortletRequest)request, (PortletResponse)response);
    }

    @RenderMode(name="edit_defaults")
    public void doConfigure(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.m_logger.debug("doConfigure() called.");
        this.handleMarkupRequest((PortletRequest)request, (PortletResponse)response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.actionPerformed(request, response);
    }

    private void actionPerformed(ActionRequest request, ActionResponse response) throws PortletException {
        block5: {
            this.m_logger.debug("actionPerformed() called.");
            request.setAttribute(PORTAL_VERSION, (Object)this.m_portalVersion);
            try {
                String actionString = request.getParameter("javax.portlet.action");
                if (actionString == null || !actionString.equals("performBlockingInteraction")) break block5;
                RequestContextImpl requestContext = new RequestContextImpl((PortletRequest)request, (PortletResponse)response, this.getPortletConfig(), this.m_logger, this.m_cssNameHandler, this.getWsdlUrlValue((PortletRequest)request), this.m_appSettings);
                RequestHelper requestHelper = this.getRequestHelper((RequestContext)requestContext, (PortletRequest)request);
                BlockingInteractionResponse blockingInteractionResponse = null;
                try {
                    blockingInteractionResponse = requestHelper.performBlockingInteraction((RequestContext)requestContext);
                }
                catch (Exception e) {
                    this.m_logger.error("Exception occurred while doing a performBlockingInteraction", (Throwable)e);
                    throw new ConsumerException("cps.consumer.wsrp.operationfailed", new Object[]{"performBlockingInteraction"}, (Throwable)e);
                }
                String portletId = response.getNamespace();
                request.getPortletSession().setAttribute(portletId + "." + BLOCKING_INTERACTION_RESPONSE, (Object)blockingInteractionResponse);
                String[] wsrpModes = request.getParameterValues("wsrp-mode");
                if (wsrpModes != null && wsrpModes.length > 0) {
                    String wsrpMode = wsrpModes[0];
                    response.setPortletMode(this.wsrpToPortalMode(wsrpMode));
                }
            }
            catch (Throwable e) {
                this.m_logger.error("Exception occurred in actionPerformed()", e);
                request.setAttribute(EXCEPTION, (Object)new ConsumerException("cps.ws.savestatefailed", e));
            }
        }
    }

    public void login(PortletRequest request) throws PortletException {
        this.m_logger.debug("login() called.");
    }

    public void logout(PortletSession session) throws PortletException {
        this.m_logger.debug("logout() called.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMarkupRequest(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        this.m_logger.debug("handleMarkupRequest() called1.");
        long start = 0L;
        if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
            start = System.currentTimeMillis();
        }
        request.setAttribute(PORTAL_VERSION, (Object)this.m_portalVersion);
        if (request.getAttribute(EXCEPTION) != null) {
            this.renderErrorPage((ConsumerException)request.getAttribute(EXCEPTION), request, response);
            return;
        }
        if (request.getWindowState() != null && request.getWindowState() == WindowState.MINIMIZED && response instanceof MimeResponse) {
            ((MimeResponse)response).getWriter().write("<!-- minimized state -->");
            return;
        }
        try {
            String preferredTitle;
            MarkupContext markupContext;
            UpdateResponse updateResponse;
            RequestContextImpl requestContext = new RequestContextImpl(request, response, this.getPortletConfig(), this.m_logger, this.m_cssNameHandler, this.getWsdlUrlValue(request), this.m_appSettings);
            RequestHelper requestHelper = this.getRequestHelper((RequestContext)requestContext, request);
            String portletId = response.getNamespace();
            BlockingInteractionResponse blockingInteractionResponse = (BlockingInteractionResponse)request.getPortletSession().getAttribute(portletId + "." + BLOCKING_INTERACTION_RESPONSE);
            boolean urlTypeIndicated = false;
            String urlType = request.getParameter("wsrp-urlType");
            if (urlType != null && urlType.equals("blockingAction")) {
                urlTypeIndicated = true;
            }
            if (blockingInteractionResponse == null && urlTypeIndicated) {
                try {
                    blockingInteractionResponse = requestHelper.performBlockingInteraction((RequestContext)requestContext);
                }
                catch (Exception e) {
                    this.m_logger.error("Exception occurred while doing a performBlockingInteraction (from handleMarkupRequest)", (Throwable)e);
                    throw new ConsumerException("cps.consumer.wsrp.operationfailed", new Object[]{"performBlockingInteraction"}, (Throwable)e);
                }
                request.getPortletSession().setAttribute(portletId + "." + BLOCKING_INTERACTION_RESPONSE, (Object)blockingInteractionResponse);
            }
            if (blockingInteractionResponse != null && (updateResponse = blockingInteractionResponse.getUpdateResponse()) != null && (markupContext = updateResponse.getMarkupContext()) != null) {
                requestHelper.processMarkupContext((RequestContext)requestContext, markupContext);
                String navigationalState = updateResponse.getNavigationalState();
                request.getPortletSession(true).setAttribute("NavigationalState", (Object)navigationalState);
                return;
            }
            MarkupResponse markupResponse = requestHelper.getMarkup((RequestContext)new RequestContextImpl(request, response, this.getPortletConfig(), this.m_logger, this.m_cssNameHandler, this.getWsdlUrlValue(request), this.m_appSettings));
            if (request.getPortletMode() == PortletMode.VIEW && markupResponse != null && markupResponse.getMarkupContext() != null && (preferredTitle = markupResponse.getMarkupContext().getPreferredTitle()) != null && !"".equals(preferredTitle) && response instanceof RenderResponse) {
                ((RenderResponse)response).setTitle(preferredTitle);
            }
        }
        catch (CSSClassSubstitutionException e) {
            this.m_logger.error("Exception occurred while handling markup request.", (Throwable)e);
            this.renderErrorPage(new ConsumerException("cps.consumer.cssclasssubstitution", null, (Throwable)e), request, response);
        }
        catch (URLRewriteException e) {
            this.m_logger.error("Exception occurred while handling markup request.", (Throwable)e);
            this.renderErrorPage(new ConsumerException("cps.consumer.rewritefailed", null, (Throwable)e), request, response);
        }
        catch (Throwable e) {
            this.m_logger.error("Exception occurred while handling markup request.", e);
            this.renderErrorPage(new ConsumerException("cps.consumer.wsrp.operationfailed", new Object[]{"getMarkup"}, e), request, response);
        }
        finally {
            if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
                long end = System.currentTimeMillis();
                this.m_logger.info("handleMarkupRequest for Portlet mode '" + request.getPortletMode().toString() + "' took: " + (end - start) + "ms.");
            }
        }
    }

    private void loadCSSMappings(PortletContext portletContext) throws UnavailableException {
        this.m_logger.debug("loadCSSMappings() called.");
        String mappingFile = CSS_MAPPINGS_FILE60;
        InputStream in = portletContext.getResourceAsStream(mappingFile);
        if (in == null) {
            throw new UnavailableException(MessagesManager.getInstance().getMessage(Locale.getDefault(), "cps.ws.loadcssmappingsfailed", new Object[]{mappingFile}));
        }
        Properties cssMappings = new Properties();
        try {
            cssMappings.load(in);
        }
        catch (IOException e) {
            this.m_logger.error("Exception occurred while loading CSS mappings.", (Throwable)e);
            throw new UnavailableException(MessagesManager.getInstance().getMessage(Locale.getDefault(), "cps.ws.readcssmappingsfailed", new Object[]{mappingFile, e.getMessage()}));
        }
        this.m_cssNameHandler = new CSSClassSubstitutionHandlerImpl(cssMappings);
    }

    private RequestHelper getRequestHelper(RequestContext requestContext, PortletRequest request) throws IOException, ConsumerException, ServiceException {
        this.m_logger.debug("getRequestHelper() called.");
        String wsdlLocation = this.getWsdlUrlValue(request);
        if (wsdlLocation == null || wsdlLocation.length() == 0) {
            throw new ConsumerException(MessagesManager.getInstance().getMessage(request.getLocale(), "cps.ws.missingapplicationparam", new Object[]{this.getPortletName(), "IBM Cognos WSRP WSDL Location"}));
        }
        String portletHandle = this.m_appSettings.getPortletHandle();
        if (portletHandle == null || portletHandle.length() == 0) {
            throw new ConsumerException(MessagesManager.getInstance().getMessage(request.getLocale(), "cps.ws.missingconfigparam", new Object[]{this.getPortletName(), "Portlet Handle"}));
        }
        return RequestHelperFactory.newInstance().createRequestHelper(requestContext, new URL(wsdlLocation), portletHandle);
    }

    private String getWsdlUrlValue(PortletRequest request) {
        String wsdlLocation = this.m_appSettings.getWsrpWsdlLocation();
        StringBuffer wsdlLocationDecoded = new StringBuffer(wsdlLocation.length());
        EncodingUtils.xmldecode((String)wsdlLocation, (StringBuffer)wsdlLocationDecoded);
        return wsdlLocationDecoded.toString();
    }

    private void renderErrorPage(ConsumerException exception, PortletRequest request, PortletResponse response) throws IOException, PortletException {
        this.m_logger.error("Exception encountered, rendering error page", (Throwable)exception);
        try {
            FixHelperImpl fixHelper = null;
            if (this.m_appSettings.showErrorsDetail()) {
                fixHelper = new FixHelperImpl(request, this.m_appSettings);
            }
            CSSClassSubstituter classSubstituter = new CSSClassSubstituter(this.m_cssNameHandler, this.m_logger);
            if (response instanceof MimeResponse) {
                classSubstituter.substitute(ErrorPage.render((ExceptionExtension)exception, (Locale)request.getLocale(), (String)response.encodeURL(request.getContextPath() + "/"), (FixHelper)fixHelper), (Writer)((MimeResponse)response).getWriter());
            }
        }
        catch (Throwable e) {
            this.m_logger.error("Failed to render CPS error page.", e);
            throw new PortletException(MessagesManager.getInstance().getMessage(request.getLocale(), "cps.ws.requestfailed", new Object[]{this.getPortletName()}), (Throwable)exception);
        }
    }

    private PortletContext getPortletLog(PortletConfig portletConfig) {
        return this.getPortletContext();
    }

    protected PortletMode wsrpToPortalMode(String wsrpMode) {
        if (wsrpMode.equals("wsrp:view")) {
            return PortletMode.VIEW;
        }
        if (wsrpMode.equals("wsrp:edit")) {
            return PortletMode.EDIT;
        }
        if (wsrpMode.equals("wsrp:help")) {
            return PortletMode.HELP;
        }
        if (wsrpMode.equals("cps:config")) {
            return new PortletMode("edit_defaults");
        }
        return null;
    }

    static {
        ArrayList<String> msgFileList = new ArrayList<String>();
        msgFileList.add("cpsconsumermsgs");
        msgFileList.add("cpsservicemsgs");
        msgFileList.add("cpssoapmsgs");
        MessagesManager.getInstance().initialize(msgFileList);
    }
}

