/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.jsr286;

import com.cognos.cps.common.sax.SAXUtils;
import com.cognos.cps.services.wsrp.v1.types.Fault;
import com.cognos.cps.wsrp.consumer.FixHelperDefault;
import com.cognos.cps.wsrp.consumer.impls.jsr286.ApplicationSettings;
import com.cognos.cps.wsrp.consumer.impls.jsr286.CAMDetailHandler;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class FixHelperImpl
extends FixHelperDefault {
    static final String LTPA_TOKEN = "LtpaToken";
    static final String NAME_CAMNAMESPACE = "CAMNamespace";
    static final String NAME_CAMNAMESPACEDISPLAYNAME = "CAMNamespaceDisplayName";
    static final String NAME_CAMUSERNAME = "CAMUsername";
    static final String NAME_CAMPASSWORD = "CAMPassword";
    static final List<String> NO_DEFAULT_NS_NAMES = new ArrayList<String>();
    static final List<String> BAD_USERNAME_NAMES = new ArrayList<String>();
    private ApplicationSettings m_appSettings;
    private PortletRequest m_request;

    public FixHelperImpl(PortletRequest request, ApplicationSettings appSettigns) {
        this.m_request = request;
        this.m_appSettings = appSettigns;
    }

    private List<String> getLtpaTokenIDs(Throwable exception) {
        String detail;
        ArrayList<String> fixes = new ArrayList<String>();
        if (exception instanceof IOException) {
            fixes.add("cps.fixes.badltpaparams");
        } else if (exception instanceof Fault && (detail = ((Fault)exception).getDetail()) != null && detail.length() > 0 && detail.startsWith("<")) {
            try {
                ArrayList<String> messages = new ArrayList<String>();
                ArrayList<String> names = new ArrayList<String>();
                int[] errorcode = new int[]{0};
                CAMDetailHandler detailHandler = new CAMDetailHandler(errorcode, messages, names);
                XMLReader reader = SAXUtils.getSAXParser().getXMLReader();
                reader.setContentHandler(detailHandler);
                reader.parse(new InputSource(new StringReader(detail)));
                if (errorcode[0] == -36 && messages.isEmpty() && names.containsAll(BAD_USERNAME_NAMES)) {
                    fixes.add("cps.fixes.userinns");
                } else if (errorcode[0] == -36 && messages.isEmpty() && names.containsAll(NO_DEFAULT_NS_NAMES)) {
                    fixes.add("cps.fixes.choosedefaultns");
                } else if (errorcode[0] == -36 && messages.size() >= 1) {
                    fixes.add("cps.fixes.ssotrustusernames");
                } else if (errorcode[0] == -38) {
                    fixes.add("cps.fixes.badnsused");
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return fixes;
    }

    public String[] getMessageIDs(Throwable exception) {
        String[] ret = new String[]{};
        ArrayList<Object> fixes = new ArrayList();
        String activeCredentialType = this.m_appSettings.getActiveCredentialType();
        if (activeCredentialType == null || activeCredentialType.length() == 0 || "(none)".equals(activeCredentialType)) {
            fixes = new ArrayList(this.getSharedSecretIDs(exception));
        } else if (LTPA_TOKEN.equals(activeCredentialType)) {
            fixes = new ArrayList<String>(this.getLtpaTokenIDs(exception));
        }
        return fixes.toArray(ret);
    }

    static {
        NO_DEFAULT_NS_NAMES.add(NAME_CAMNAMESPACE);
        BAD_USERNAME_NAMES.add(NAME_CAMNAMESPACE);
        BAD_USERNAME_NAMES.add(NAME_CAMNAMESPACEDISPLAYNAME);
        BAD_USERNAME_NAMES.add(NAME_CAMUSERNAME);
        BAD_USERNAME_NAMES.add(NAME_CAMPASSWORD);
    }
}

