/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.jsr286;

import com.cognos.cps.common.io.EnhancedIOException;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.CookieUtils;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.cps.soap.helpers.SOAPConnectionImpl;
import com.cognos.cps.wsrp.consumer.HttpSOAPConnection;
import com.cognos.cps.wsrp.consumer.impls.jsr286.ApplicationSettings;
import com.cognos.cps.wsrp.consumer.impls.jsr286.credentials.ActiveCredentialHelper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.Cookie;

public class HttpSOAPConnectionImpl
extends SOAPConnectionImpl
implements HttpSOAPConnection {
    private static final String NO_AUTH = "";
    static final String LTPA_TOKEN = "LtpaToken";
    static final String SITE_MINDER_TOKEN = "SiteMinderToken";
    static final String WEB_SEAL_TOKEN = "WebSealToken";
    private static boolean m_initialized = false;
    private PortletRequest m_request = null;
    private PortletResponse m_response = null;
    private String m_namespaceId;
    private static Map<String, Object> m_credentialHelpers = new HashMap<String, Object>();
    private Cookie[] m_requestCookies = null;
    private Cookie[] m_responseCookies = null;
    private ApplicationSettings m_appSettings;

    public static synchronized void init(PortletConfig config, ServiceLogger logger) {
        if (m_initialized) {
            return;
        }
        logger.debug("HttpSOAPConnectionImpl.init() called.");
        m_initialized = true;
    }

    public HttpSOAPConnectionImpl(PortletRequest request, PortletResponse response, SOAPObjectHandler objectHandler, String namespaceId, ServiceLogger logger, ApplicationSettings appSettings) {
        super(objectHandler, logger);
        this.m_logger = logger;
        this.m_request = request;
        this.m_response = response;
        this.m_namespaceId = namespaceId;
        this.m_appSettings = appSettings;
    }

    public void setRequestCookies(Cookie[] cookies) {
        this.m_requestCookies = cookies;
    }

    public void addRequestCookies(Cookie[] cookies) {
        this.m_requestCookies = CookieUtils.addCookies((Cookie[])this.m_requestCookies, (Cookie[])cookies);
    }

    public void addRequestCookie(Cookie cookie) {
        this.m_requestCookies = CookieUtils.addCookie((Cookie[])this.m_requestCookies, (Cookie)cookie);
    }

    public Cookie[] getResponseCookies() {
        return this.m_responseCookies;
    }

    public HttpURLConnection openConnection(URL url) throws IOException {
        this.m_logger.debug("HttpSOAPConnectionImpl.openConnection(URL) called.");
        this.m_connection = this.getNonAuthenticatedHttpConnection(url.toExternalForm());
        if (this.m_namespaceId != null && !"(none)".equals(this.m_namespaceId) && this.m_namespaceId.length() > 0) {
            this.m_connection.setRequestProperty("CAM-Namespace", this.m_namespaceId);
        }
        CookieUtils.addCookies((HttpURLConnection)this.m_connection, (Cookie[])this.m_requestCookies);
        this.m_connection.setRequestProperty("Accept-Language", this.m_request.getLocale().toString() + ",en-us;q=0.5");
        return this.m_connection;
    }

    private HttpURLConnection getNonAuthenticatedHttpConnection(String url) throws IOException {
        return this.getHttpConnectionFromFactory(new URL(url));
    }

    public void disconnect() {
        this.m_logger.debug("disconnect() called.");
        if (this.m_connection != null) {
            this.m_responseCookies = CookieUtils.getSetCookies((HttpURLConnection)this.m_connection);
            if (this.m_responseCookies != null) {
                this.m_logger.debug("Cookies returned in response: ");
                for (int i = 0; i < this.m_responseCookies.length; ++i) {
                    this.m_logger.debug("Cookie: " + this.m_responseCookies[i].getName());
                }
            } else {
                this.m_logger.debug("No cookies returned in response.");
            }
        }
    }

    private HttpURLConnection getHttpConnectionFromFactory(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    private ActiveCredentialHelper getCredentialHelper(PortletRequest request) throws IOException {
        String activeCredentialType = this.m_appSettings.getActiveCredentialType();
        if (activeCredentialType == null) {
            activeCredentialType = NO_AUTH;
        } else if (!m_credentialHelpers.containsKey(activeCredentialType)) {
            throw new EnhancedIOException("cps.ws.unsupportedcredentialtype", new Object[]{activeCredentialType});
        }
        return (ActiveCredentialHelper)m_credentialHelpers.get(activeCredentialType);
    }

    static {
        m_credentialHelpers.put(NO_AUTH, null);
    }
}

