/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.jsr286;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.Base64;
import com.cognos.cps.common.utils.GetVersion;
import com.cognos.cps.common.utils.XMLUtils;
import com.cognos.cps.services.pagelet.objects.v1.types.PortalContext;
import com.cognos.cps.services.wsrp.v1.types.BlockingInteractionResponse;
import com.cognos.cps.services.wsrp.v1.types.ClientData;
import com.cognos.cps.services.wsrp.v1.types.Extension;
import com.cognos.cps.services.wsrp.v1.types.InteractionParams;
import com.cognos.cps.services.wsrp.v1.types.MarkupParams;
import com.cognos.cps.services.wsrp.v1.types.NamedString;
import com.cognos.cps.services.wsrp.v1.types.PortletContext;
import com.cognos.cps.services.wsrp.v1.types.RuntimeContext;
import com.cognos.cps.services.wsrp.v1.types.StateChange;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import com.cognos.cps.services.wsrp.v1.types.UpdateResponse;
import com.cognos.cps.services.wsrp.v1.types.UserContext;
import com.cognos.cps.wsrp.consumer.ConsumerException;
import com.cognos.cps.wsrp.consumer.ObjectHandlerDefault;
import com.cognos.cps.wsrp.consumer.helpers.ExtensionHelper;
import com.cognos.cps.wsrp.consumer.impls.jsr286.ApplicationSettings;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;

public class ObjectHandlerImpl
extends ObjectHandlerDefault {
    private static final String SOLO_STATE = "Solo";
    private static final String PORTLET_SETTINGS_PORTLET_STATE = "CPS-PortletState";
    private static final String PORTLET_SETTINGS_PORTLET_HANDLE = "CPS-PortletHandle";
    protected static final String PORTLET_DATA_PORTLET_CONTEXT = "CPS-PortletContext";
    public static final String NAVIGATIONAL_STATE = "NavigationalState";
    private static final String[] m_packages = new String[]{"com.cognos.cps.common", "com.cognos.cps.wsrp.consumer.impls.websphere", "javax.xml.parsers", "javax.xml.transform", "org.xml.sax", "java.lang"};
    private static final String[] m_supportedModes = new String[]{"wsrp:view", "wsrp:edit", "wsrp:preview", "wsrp:help", "cps:config"};
    private static final String[] m_supportedWindowStates = new String[]{"wsrp:normal", "wsrp:maximized", "wsrp:minimized"};
    private PortletRequest m_request = null;
    private String m_portletId = "";
    private MarkupParams m_markupParams = null;
    private ApplicationSettings m_appSettings;

    public ObjectHandlerImpl(PortletRequest request, PortletResponse response, PortletConfig config, ServiceLogger logger, ApplicationSettings appSettings) {
        this.m_request = request;
        this.m_logger = logger;
        this.m_portletId = response.getNamespace();
        this.m_appSettings = appSettings;
        this.m_includeVersionInfo = this.m_request.getPortletMode().toString().equals("edit_defaults");
    }

    public PortletContext getPortletContext(String hashkey, String initialPortletHandle) throws ConsumerException {
        this.m_logger.debug("getPortletContext() called.");
        PortletContext portletContext = null;
        if (this.m_request.getPortletMode().toString().equals("edit_defaults")) {
            this.m_logger.debug("Returning admin level PortletContext.");
            portletContext = this.getAdminLevelPortletContext(initialPortletHandle);
        } else {
            this.m_logger.debug("Returning user level PortletContext.");
            portletContext = TypeFactory.newInstance().createPortletContext();
            String portletHandle = this.m_request.getPreferences().getValue(PORTLET_SETTINGS_PORTLET_HANDLE, null);
            if (portletHandle == null) {
                portletContext.setPortletHandle(initialPortletHandle);
            } else {
                portletContext.setPortletHandle(portletHandle);
            }
            String portletState = this.m_request.getPreferences().getValue(PORTLET_SETTINGS_PORTLET_STATE, null);
            if (portletState != null) {
                portletContext.setPortletState(Base64.decode((String)portletState));
            }
        }
        return portletContext;
    }

    private PortletContext getAdminLevelPortletContext(String initialPortletHandle) throws ConsumerException {
        PortletContext portletContext = TypeFactory.newInstance().createPortletContext();
        String portletHandle = this.m_request.getPreferences().getValue(PORTLET_SETTINGS_PORTLET_HANDLE, null);
        if (portletHandle == null) {
            portletContext.setPortletHandle(initialPortletHandle);
            return portletContext;
        }
        portletContext.setPortletHandle(portletHandle);
        String portletState = this.m_request.getPreferences().getValue(PORTLET_SETTINGS_PORTLET_STATE, null);
        if (portletState != null) {
            portletContext.setPortletState(Base64.decode((String)portletState));
        }
        return portletContext;
    }

    public void storePortletContext(String hashkey, PortletContext portletContext) throws ConsumerException {
        this.m_logger.debug("storePortletContext() called.");
        try {
            if (this.m_request.getPortletMode().toString().equals("edit_defaults")) {
                this.m_logger.debug("Storing admin level PortletContext.");
                this.m_request.getPreferences().setValue(PORTLET_SETTINGS_PORTLET_HANDLE, portletContext.getPortletHandle());
                byte[] portletState = portletContext.getPortletState();
                if (portletState != null) {
                    this.m_request.getPreferences().getValue(PORTLET_SETTINGS_PORTLET_STATE, Base64.encode((byte[])portletState));
                }
                this.m_request.getPreferences().store();
            } else if (this.m_request.getPortletMode() == PortletMode.EDIT) {
                this.m_logger.debug("User level PortletContext.");
                this.m_request.getPreferences().setValue(PORTLET_SETTINGS_PORTLET_HANDLE, portletContext.getPortletHandle());
                byte[] portletState = portletContext.getPortletState();
                if (portletState != null) {
                    this.m_request.getPreferences().setValue(PORTLET_SETTINGS_PORTLET_STATE, Base64.encode((byte[])portletState));
                }
                this.m_request.getPreferences().store();
            }
        }
        catch (Exception e) {
            Object[] args = new String[]{"PortletContext"};
            throw new ConsumerException("cps.ws.objectstoragefailed", args, (Throwable)e);
        }
    }

    public RuntimeContext createRuntimeContext(String hashkey) throws ConsumerException {
        this.m_logger.debug("createRuntimeContext() called.");
        RuntimeContext runtimeContext = TypeFactory.newInstance().createRuntimeContext();
        runtimeContext.setUserAuthentication("wsrp:password");
        String portletInstanceKey = this.m_request.getParameter("wsrp-portletInstanceKey");
        if (portletInstanceKey != null) {
            runtimeContext.setPortletInstanceKey(portletInstanceKey);
        } else {
            runtimeContext.setPortletInstanceKey("p" + Integer.toString(new Object().hashCode()));
        }
        runtimeContext.setNamespacePrefix("p" + Integer.toString(new Object().hashCode()));
        return runtimeContext;
    }

    public UserContext createUserContext(String hashkey) throws ConsumerException {
        this.m_logger.debug("createUserContext() called.");
        UserContext userContext = TypeFactory.newInstance().createUserContext();
        Map userInfo = (Map)this.m_request.getAttribute("javax.portlet.userinfo");
        String userId = null;
        if (userInfo != null && (userId = (String)userInfo.get(PortletRequest.P3PUserInfos.USER_LOGIN_ID.toString())) == null) {
            userId = (String)userInfo.get(PortletRequest.P3PUserInfos.USER_NAME_NICKNAME.toString());
        }
        userContext.setUserContextKey(userId);
        return userContext;
    }

    public MarkupParams createMarkupParams(String hashkey) throws ConsumerException {
        BlockingInteractionResponse blockingInteractionResponse;
        this.m_logger.debug("createMarkupParams() called.");
        if (this.m_markupParams != null) {
            return this.m_markupParams;
        }
        this.m_markupParams = TypeFactory.newInstance().createMarkupParams();
        String mode = this.getWSRPMode();
        String windowState = this.getWSRPWindowState();
        if (this.m_request.getParameter("wsrp-mode") != null) {
            mode = this.m_request.getParameter("wsrp-mode");
        }
        if (this.m_request.getParameter("wsrp-windowState") != null) {
            windowState = this.m_request.getParameter("wsrp-windowState");
        }
        if (this.m_request.getParameter("wsrp-navigationalState") != null) {
            this.m_request.getPortletSession(true).setAttribute(NAVIGATIONAL_STATE, (Object)this.m_request.getParameter("wsrp-navigationalState"));
        }
        if ((blockingInteractionResponse = (BlockingInteractionResponse)this.m_request.getPortletSession().getAttribute(this.m_portletId + "." + "BlockingInteractionResponse")) != null) {
            this.m_request.getPortletSession().setAttribute(this.m_portletId + "." + "BlockingInteractionResponse", null);
            UpdateResponse updateResponse = blockingInteractionResponse.getUpdateResponse();
            if (updateResponse != null) {
                String newWindowState;
                String newMode = updateResponse.getNewMode();
                if (newMode != null) {
                    mode = newMode;
                }
                if ((newWindowState = updateResponse.getNewWindowState()) != null) {
                    windowState = newWindowState;
                }
                this.m_request.getPortletSession(true).setAttribute(NAVIGATIONAL_STATE, (Object)updateResponse.getNavigationalState());
            }
        }
        String navigationalState = (String)this.m_request.getPortletSession().getAttribute(NAVIGATIONAL_STATE);
        this.m_markupParams.setMode(mode);
        this.m_markupParams.setWindowState(windowState);
        this.m_markupParams.setNavigationalState(navigationalState);
        Vector<Locale> locales = new Vector<Locale>();
        locales.add(this.m_request.getLocale());
        Enumeration localesEnum = this.m_request.getLocales();
        while (localesEnum.hasMoreElements()) {
            locales.add((Locale)localesEnum.nextElement());
        }
        this.m_markupParams.setLocales(this.convertLocalesEnum(locales.elements()));
        if (this.m_request instanceof ClientDataRequest) {
            this.m_markupParams.addMimeTypes(((ClientDataRequest)this.m_request).getContentType());
        }
        this.m_markupParams.setSecureClientCommunication(false);
        this.m_markupParams.setMarkupCharacterSets(new String[]{"UTF-8"});
        this.m_markupParams.addValidNewModes("wsrp:view");
        if (!mode.equals("wsrp:view")) {
            this.m_markupParams.addValidNewModes(mode);
        }
        for (int i = 0; i < m_supportedWindowStates.length; ++i) {
            this.m_markupParams.addValidNewWindowStates(m_supportedWindowStates[i]);
        }
        if (this.m_includeVersionInfo) {
            Extension versions = TypeFactory.newInstance().createExtension();
            versions.setAnyW3CElement(XMLUtils.parse((String)GetVersion.getVersion((String[])m_packages, (boolean)false)));
            this.m_markupParams.addExtensions(versions);
        }
        ClientData clientData = TypeFactory.newInstance().createClientData();
        String userAgent = (String)this.m_request.getAttribute("User-Agent");
        if (userAgent == null || "".equals(userAgent)) {
            userAgent = "MSIE";
        }
        clientData.setUserAgent(userAgent);
        this.m_markupParams.setClientData(clientData);
        Extension portalContextExtension = ExtensionHelper.createPortalContextExtension((PortalContext)this.createPortalContext());
        this.m_markupParams.addExtensions(portalContextExtension);
        return this.m_markupParams;
    }

    public InteractionParams createInteractionParams(String hashkey) throws ConsumerException {
        this.m_logger.debug("createInteractionParams() called.");
        InteractionParams interactionParams = TypeFactory.newInstance().createInteractionParams();
        interactionParams.setPortletStateChange(StateChange.READWRITE);
        String interactionState = this.m_request.getParameter("wsrp-interactionState");
        if (interactionState != null) {
            interactionParams.setInteractionState(this.m_request.getParameter("wsrp-interactionState"));
        }
        NamedString formParameter = null;
        Enumeration paramsEnum = this.m_request.getParameterNames();
        String name = null;
        String[] values = null;
        while (paramsEnum.hasMoreElements()) {
            name = (String)paramsEnum.nextElement();
            if (name.startsWith("wsrp-")) continue;
            values = this.m_request.getParameterValues(name);
            for (int i = 0; i < values.length; ++i) {
                formParameter = TypeFactory.newInstance().createNamedString();
                formParameter.setName(name);
                formParameter.setValue(values[i]);
                interactionParams.addFormParameters(formParameter);
            }
        }
        return interactionParams;
    }

    private String getWSRPMode() throws ConsumerException {
        PortletMode mode = this.m_request.getPortletMode();
        if (mode == PortletMode.VIEW) {
            return "wsrp:view";
        }
        if (mode == PortletMode.EDIT) {
            return "wsrp:edit";
        }
        if (mode == PortletMode.HELP) {
            return "wsrp:help";
        }
        if ("edit_defaults".equals(mode.toString())) {
            return "cps:config";
        }
        Object[] args = new String[]{mode.toString()};
        throw new ConsumerException("cps.ws.invalidmode", args);
    }

    private String getWSRPWindowState() throws ConsumerException {
        WindowState windowState = this.m_request.getWindowState();
        if (windowState == WindowState.NORMAL) {
            return "wsrp:normal";
        }
        if (windowState == WindowState.MAXIMIZED) {
            return "wsrp:maximized";
        }
        if (windowState == WindowState.MINIMIZED) {
            return "wsrp:minimized";
        }
        if ("DETACHED".equals(windowState.toString()) || SOLO_STATE.equals(windowState.toString())) {
            return "wsrp:solo";
        }
        if ("exclusive".equals(windowState.toString())) {
            return "wsrp:normal";
        }
        Object[] args = new String[]{windowState.toString()};
        throw new ConsumerException("cps.ws.invalidwindowstate", args);
    }

    public String getConfigProperty(String name) {
        return this.m_appSettings.getProperty(name);
    }

    protected String getPortalAgent() {
        return "JSR286 Container";
    }

    protected String getConsumerAgent() {
        return "Liferay.6.2";
    }

    protected String[] getSupportedModes() {
        return m_supportedModes;
    }

    protected String[] getSupportedWindowStates() {
        return m_supportedWindowStates;
    }

    protected Enumeration<String> getRequestParameterNames() {
        return this.m_request.getParameterNames();
    }

    protected String[] getRequestParameterValues(String name) {
        return this.m_request.getParameterValues(name);
    }

    public String getPropertyWebcontentUrl() {
        return "_webcontentURL";
    }

    public String getPropertyGatewayUrl() {
        return "_gatewayURL";
    }
}

