/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.jsr286;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionHandler;
import com.cognos.cps.wsrp.consumer.CacheHandler;
import com.cognos.cps.wsrp.consumer.ConsumerException;
import com.cognos.cps.wsrp.consumer.HttpSOAPConnection;
import com.cognos.cps.wsrp.consumer.ObjectHandler;
import com.cognos.cps.wsrp.consumer.PropylaealetSession;
import com.cognos.cps.wsrp.consumer.RequestContextDefault;
import com.cognos.cps.wsrp.consumer.URLRewriteHandler;
import com.cognos.cps.wsrp.consumer.helpers.CacheHandlerImpl;
import com.cognos.cps.wsrp.consumer.impls.jsr286.ApplicationSettings;
import com.cognos.cps.wsrp.consumer.impls.jsr286.HttpSOAPConnectionImpl;
import com.cognos.cps.wsrp.consumer.impls.jsr286.ObjectHandlerImpl;
import com.cognos.cps.wsrp.consumer.impls.jsr286.PortletSessionImpl;
import com.cognos.cps.wsrp.consumer.impls.jsr286.URLRewriterImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class RequestContextImpl
extends RequestContextDefault {
    private ApplicationSettings m_appSettings;
    private static final String CPS_AUTH_COOKIE = "cps_auth_user";
    private PortletRequest m_request = null;
    private PortletResponse m_response = null;
    private PortletConfig m_config = null;
    private PropylaealetSession session = null;
    private HttpServletResponse servletResponse;
    private String m_gatewayHostSessionKey = null;

    private RequestContextImpl() {
    }

    public RequestContextImpl(PortletRequest request, PortletResponse response, PortletConfig config, ServiceLogger logger, CSSClassSubstitutionHandler cssClassSubstitutionHandler, String wsdlUrl, ApplicationSettings appSettings) throws ConsumerException {
        this.m_request = request;
        this.m_response = response;
        this.m_config = config;
        this.m_logger = logger;
        this.m_cssClassSubstitutionHandler = cssClassSubstitutionHandler;
        this.m_wsdlUrl = wsdlUrl;
        this.m_appSettings = appSettings;
    }

    public ObjectHandler getObjectHandler() {
        if (this.m_objectHandler == null) {
            this.m_objectHandler = new ObjectHandlerImpl(this.m_request, this.m_response, this.m_config, this.m_logger, this.m_appSettings);
        }
        return this.m_objectHandler;
    }

    public CacheHandler getCacheHandler() {
        if (this.m_cacheHandler == null) {
            int maxCachedPagesInt = this.m_appSettings.getMaximumCachedPages();
            this.m_logger.debug("Cached pages set to: " + maxCachedPagesInt);
            this.m_cacheHandler = new CacheHandlerImpl(this.m_logger, this.getSession(), maxCachedPagesInt);
        }
        return this.m_cacheHandler;
    }

    public URLRewriteHandler getURLRewriteHandler() {
        if (this.m_urlRewriteHandler == null && this.m_request instanceof RenderRequest && this.m_response instanceof RenderResponse) {
            this.m_urlRewriteHandler = new URLRewriterImpl((RenderRequest)this.m_request, (RenderResponse)this.m_response);
        }
        return this.m_urlRewriteHandler;
    }

    public String getGatewayUrlPropertyName() {
        return "_gatewayURL";
    }

    private String getGatewayHostSessionKey() {
        if (this.m_gatewayHostSessionKey == null) {
            String key = this.m_wsdlUrl;
            String gatewayValue = this.getObjectHandler().getConfigProperty(this.getGatewayUrlPropertyName());
            if (gatewayValue != null) {
                key = key + gatewayValue;
            }
            this.m_gatewayHostSessionKey = "gt" + key.hashCode();
        }
        return this.m_gatewayHostSessionKey;
    }

    public Writer getResultWriter() throws IOException {
        if (this.servletResponse != null) {
            return new OutputStreamWriter((OutputStream)this.servletResponse.getOutputStream());
        }
        if (this.m_response instanceof MimeResponse) {
            return ((MimeResponse)this.m_response).getWriter();
        }
        return null;
    }

    public HttpSOAPConnection createHttpSOAPConnection() {
        String namespaceId = this.m_appSettings.getCpsAuthNamespace();
        return new HttpSOAPConnectionImpl(this.m_request, this.m_response, (SOAPObjectHandler)TypeFactory.newInstance(), namespaceId, this.m_logger, this.m_appSettings);
    }

    public HttpURLConnection createHttpURLConnection(URL url) throws IOException {
        String namespaceId = this.m_appSettings.getCpsAuthNamespace();
        HttpSOAPConnectionImpl connectionGenerator = new HttpSOAPConnectionImpl(this.m_request, this.m_response, null, namespaceId, this.m_logger, this.m_appSettings);
        return connectionGenerator.openConnection(url);
    }

    public PropylaealetSession getSession() {
        if (this.session == null) {
            this.session = new PortletSessionImpl(this.m_request.getPortletSession(true));
            String key = this.getGatewayHostSessionKey();
            this.session.applyPropertyByNameAndScope(key, (Object)this.getGatewayHostValue(), 9);
        }
        return this.session;
    }

    public Cookie getAuthCookie() {
        this.m_logger.debug("getAuthCookie() called.");
        Cookie cookie = null;
        Map userInfo = (Map)this.m_request.getAttribute("javax.portlet.userinfo");
        String userId = null;
        if (userInfo != null && (userId = (String)userInfo.get(PortletRequest.P3PUserInfos.USER_LOGIN_ID.toString())) == null) {
            userId = (String)userInfo.get(PortletRequest.P3PUserInfos.USER_NAME_NICKNAME.toString());
        }
        if (userId != null) {
            String secret = this.m_appSettings.getCpsAuthSecret();
            if (secret != null && "(none)".equals(secret)) {
                secret = null;
            }
            return this.getAuthCookie(userId, secret, CPS_AUTH_COOKIE);
        }
        return cookie;
    }

    void setHttpServletResponse(HttpServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }
}

