/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.jsr286;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.wsrp.consumer.ConsumerException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.portlet.PortletContext;

public class ServiceLoggerImpl
implements ServiceLogger {
    private PortletContext m_log = null;
    private String m_loggingPrefix = null;

    public ServiceLoggerImpl(PortletContext log, String loggingPrefix) {
        this.m_log = log;
        this.m_loggingPrefix = loggingPrefix;
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.m_log.log(this.m_loggingPrefix + "[info]: " + message);
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.m_log.log(this.m_loggingPrefix + "[warning]: " + message);
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.m_log.log(this.m_loggingPrefix + "[error]: " + message);
        }
    }

    public void error(String message, Throwable e) {
        if (this.isErrorEnabled()) {
            StringWriter tmp = new StringWriter();
            PrintWriter pwrt = new PrintWriter(tmp);
            while (e instanceof ConsumerException && ((ConsumerException)e).getRootCause() != null) {
                e.printStackTrace(pwrt);
                e = ((ConsumerException)e).getRootCause();
            }
            this.m_log.log(this.m_loggingPrefix + "[error]: " + message + "\nStacktrace: " + tmp.toString(), e);
        }
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.m_log.log(this.m_loggingPrefix + "[debug]: " + message);
        }
    }

    public void enter(String method) {
        this.m_log.log(this.m_loggingPrefix + "[enter]: " + method);
    }

    public void enter(String method, Object[] objects) {
        this.m_log.log(this.m_loggingPrefix + "[enter]: " + method + " " + objects.toString());
    }

    public void exit(String method) {
        this.m_log.log(this.m_loggingPrefix + "[exit]: " + method);
    }

    public void exit(String method, Object[] objects) {
        this.m_log.log(this.m_loggingPrefix + "[exit]: " + method + " " + objects.toString());
    }

    public ServiceLogger cloneForClass(Class className) {
        try {
            return (ServiceLogger)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public String getLoggingPrefix() {
        return this.m_loggingPrefix;
    }

    public boolean isAuditLevelEnabled(int level) {
        return false;
    }

    public void logAudit(int level, int operation, String message) {
    }

    public boolean isPerfLevelEnabled(int level) {
        return false;
    }

    public Object startTimer(int level, String method, String description, Object obj) {
        return null;
    }

    public void stopTimer(Object timer) {
    }
}

