/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.jsr286;

import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.cps.wsrp.consumer.URLRewriteException;
import com.cognos.cps.wsrp.consumer.URLRewriteHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class URLRewriterImpl
implements URLRewriteHandler {
    public static final String PORTLET_ACTION_BLOCKINGINTERACTION = "performBlockingInteraction";
    private RenderResponse response = null;
    private RenderRequest request = null;

    private URLRewriterImpl() {
    }

    public URLRewriterImpl(RenderRequest request, RenderResponse response) {
        this.request = request;
        this.response = response;
    }

    public void generateURL(Map urlParams, Writer result, String rewriteFlags) throws URLRewriteException {
        PortletURL portletURI = null;
        String urlType = (String)urlParams.get("wsrp-urlType");
        if (urlType == null) {
            urlType = "render";
        }
        if ("resource".equals(urlType)) {
            this.writeResourceUrl(urlParams, result);
        } else {
            try {
                boolean addViewModeParams = false;
                if ("blockingAction".equals(urlType)) {
                    portletURI = this.response.createActionURL();
                    portletURI.setParameter("javax.portlet.action", PORTLET_ACTION_BLOCKINGINTERACTION);
                } else {
                    portletURI = this.response.createRenderURL();
                    portletURI.setPortletMode(PortletMode.VIEW);
                }
                if (urlParams.size() == 0) {
                    portletURI.setPortletMode(PortletMode.VIEW);
                } else {
                    String mode = (String)urlParams.get("wsrp-mode");
                    if (PortletMode.VIEW != this.request.getPortletMode() && mode == null || "wsrp:view".equals(mode)) {
                        if (mode == null) {
                            addViewModeParams = true;
                        }
                    } else {
                        String windowState = (String)urlParams.get("wsrp-windowState");
                        if (windowState != null && windowState.length() > 0) {
                            portletURI.setWindowState(this.getWSWindowState(windowState));
                        }
                    }
                }
                Map.Entry pair2 = null;
                for (Map.Entry pair2 : urlParams.entrySet()) {
                    String value = this.decodeParamValue((String)pair2.getValue());
                    portletURI.setParameter((String)pair2.getKey(), value);
                }
                if (addViewModeParams) {
                    portletURI.setParameter("wsrp-mode", "wsrp:view");
                }
                result.write(portletURI.toString());
            }
            catch (PortletModeException e) {
                throw new URLRewriteException("cps.consumer.rewritefailed", (Throwable)e);
            }
            catch (WindowStateException e) {
                throw new URLRewriteException("cps.consumer.rewritefailed", (Throwable)e);
            }
            catch (IOException e) {
                throw new URLRewriteException("cps.consumer.rewritefailed", (Throwable)e);
            }
        }
    }

    private String decodeParamValue(String value) throws URLRewriteException {
        try {
            String valueDecoded = EncodingUtils.urlDecode((String)value, (String)"UTF-8");
            return valueDecoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new URLRewriteException("cps.consumer.rewritefailed", (Throwable)e);
        }
    }

    private void writeResourceUrl(Map urlParams, Writer result) throws URLRewriteException {
        try {
            ResourceURL resourceURI = null;
            resourceURI = this.response.createResourceURL();
            result.write(resourceURI.toString());
        }
        catch (IOException e) {
            throw new URLRewriteException("cps.consumer.rewritefailed", (Throwable)e);
        }
    }

    public void generateUniquePortletId(Writer result) throws URLRewriteException {
        try {
            result.write("p" + Integer.toString(this.hashCode()).replace("-", "_"));
        }
        catch (IOException e) {
            throw new URLRewriteException("cps.consumer.rewritefailed", (Throwable)e);
        }
    }

    WindowState getWSWindowState(String wsrpWindowState) throws URLRewriteException {
        WindowState state = null;
        if (wsrpWindowState.equals("wsrp:normal")) {
            state = WindowState.NORMAL;
        } else if (wsrpWindowState.equals("wsrp:maximized")) {
            state = WindowState.MAXIMIZED;
        } else if (wsrpWindowState.equals("wsrp:minimized")) {
            state = WindowState.MINIMIZED;
        } else {
            Object[] args = new String[]{wsrpWindowState};
            throw new URLRewriteException("cps.ws.invalidwindowstate", args);
        }
        return state;
    }
}

