/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.soap;

import com.cognos.cps.common.sax.EnhancedSAXException;
import com.cognos.cps.soap.PrefixNamespaceMapping;
import com.cognos.cps.soap.SOAPFault;
import com.cognos.cps.soap.helpers.QNameFactory;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class SOAPFaultContentHandler
extends DefaultHandler {
    private List m_nsInScopeFaultPrefixes = new ArrayList();
    private List m_nsPrefixes = new ArrayList();
    private QName m_faultcode = null;
    private String m_faultstring = null;
    private String m_faultactor = null;
    private String m_detail = null;
    private StringBuffer m_currentBuf = null;
    private int m_detailDepth = 0;

    public boolean collectingDetails() {
        return this.m_detailDepth != 0;
    }

    public Object getObject() {
        SOAPFault fault = new SOAPFault(this.m_faultcode, this.m_faultstring);
        fault.setFaultActor(this.m_faultactor);
        if (this.m_detail != null) {
            fault.setDetail(this.m_detail.trim());
        }
        return fault;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equals("faultcode") && this.m_detailDepth == 0) {
            this.m_currentBuf = new StringBuffer();
        } else if (localName.equals("faultstring") && this.m_detailDepth == 0) {
            this.m_currentBuf = new StringBuffer();
        } else if (localName.equals("faultactor") && this.m_detailDepth == 0) {
            this.m_currentBuf = new StringBuffer();
        } else if (localName.equals("detail") && this.m_detailDepth == 0) {
            this.m_currentBuf = new StringBuffer();
            ++this.m_detailDepth;
        } else if (this.m_detailDepth > 0) {
            if (this.m_currentBuf != null) {
                PrefixNamespaceMapping prefixUriMapping;
                int i;
                this.m_currentBuf.append('<');
                this.m_currentBuf.append(qName);
                if (this.m_detailDepth == 1) {
                    for (i = 0; i < this.m_nsInScopeFaultPrefixes.size(); ++i) {
                        prefixUriMapping = (PrefixNamespaceMapping)this.m_nsInScopeFaultPrefixes.get(i);
                        if (this.m_nsPrefixes.contains(prefixUriMapping)) continue;
                        this.printNamespace(prefixUriMapping);
                    }
                }
                for (i = 0; i < this.m_nsPrefixes.size(); ++i) {
                    prefixUriMapping = (PrefixNamespaceMapping)this.m_nsPrefixes.get(i);
                    this.printNamespace(prefixUriMapping);
                }
                this.m_nsPrefixes.clear();
                for (i = 0; i < atts.getLength(); ++i) {
                    this.m_currentBuf.append(' ');
                    this.m_currentBuf.append(atts.getQName(i));
                    this.m_currentBuf.append("=\"");
                    this.m_currentBuf.append(atts.getValue(i));
                    this.m_currentBuf.append('\"');
                }
                this.m_currentBuf.append('>');
            }
            ++this.m_detailDepth;
        } else {
            throw new EnhancedSAXException("cps.soap.invalidfaultelement", new String[]{localName});
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("faultcode") && this.m_detailDepth == 0) {
            String faultcode = this.m_currentBuf.toString();
            String faultcodePrefix = null;
            String faultcodeURI = null;
            int colonPos = faultcode.indexOf(58);
            if (colonPos != -1) {
                faultcodePrefix = faultcode.substring(0, colonPos);
                faultcode = faultcode.substring(colonPos + 1);
                faultcodeURI = this.getURIFromPrefixStack(faultcodePrefix);
                if (faultcodeURI == null) {
                    throw new EnhancedSAXException("cps.soap.couldnotresolvefaultcodeprefix", new String[]{faultcodePrefix});
                }
            } else {
                faultcodePrefix = "";
                faultcodeURI = this.getURIFromPrefixStack(faultcodePrefix);
                if (faultcodeURI == null) {
                    faultcodeURI = "";
                }
            }
            this.m_faultcode = QNameFactory.createQName(faultcodeURI, faultcode, faultcodePrefix);
        } else if (localName.equals("faultstring") && this.m_detailDepth == 0) {
            this.m_faultstring = this.m_currentBuf.toString();
        } else if (localName.equals("faultactor") && this.m_detailDepth == 0) {
            this.m_faultactor = this.m_currentBuf.toString();
        } else if (localName.equals("detail") && this.m_detailDepth == 1) {
            this.m_detail = this.m_currentBuf.toString();
            --this.m_detailDepth;
        } else if (this.m_detailDepth > 0) {
            if (this.m_currentBuf != null) {
                this.m_currentBuf.append("</");
                this.m_currentBuf.append(qName);
                this.m_currentBuf.append('>');
            }
            --this.m_detailDepth;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_currentBuf != null) {
            this.m_currentBuf.append(ch, start, length);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.m_detailDepth == 0) {
            this.m_nsInScopeFaultPrefixes.add(new PrefixNamespaceMapping(prefix, uri));
        } else {
            this.m_nsPrefixes.add(new PrefixNamespaceMapping(prefix, uri));
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.m_detailDepth == 0) {
            this.m_nsInScopeFaultPrefixes.remove(this.m_nsInScopeFaultPrefixes.size() - 1);
        } else if (!this.m_nsPrefixes.isEmpty()) {
            this.m_nsPrefixes.remove(this.m_nsPrefixes.size() - 1);
        }
    }

    private String getURIFromPrefixStack(String prefix) {
        PrefixNamespaceMapping mapping2 = null;
        for (PrefixNamespaceMapping mapping2 : this.m_nsInScopeFaultPrefixes) {
            if (!mapping2.getPrefix().equals(prefix)) continue;
            return mapping2.getURI();
        }
        return null;
    }

    private void printNamespace(PrefixNamespaceMapping prefixUriMapping) {
        this.m_currentBuf.append(" xmlns");
        if (prefixUriMapping.getPrefix().length() > 0) {
            this.m_currentBuf.append(':');
            this.m_currentBuf.append(prefixUriMapping.getPrefix());
        }
        this.m_currentBuf.append("=\"");
        this.m_currentBuf.append(prefixUriMapping.getURI());
        this.m_currentBuf.append('\"');
    }
}

