/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.io;

import java.io.IOException;
import java.io.Reader;

public class StringArrayReader
extends Reader {
    private String[] strings;
    private int index = 0;
    private int charPos = 0;

    public StringArrayReader(String[] strings) {
        this.strings = strings;
    }

    @Override
    public void close() throws IOException {
        this.strings = null;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.strings == null) {
            throw new IOException("Reader closed");
        }
        if (this.index >= this.strings.length) {
            return -1;
        }
        int charsInBuf = 0;
        int maxCount = len;
        while (this.index < this.strings.length && charsInBuf < maxCount) {
            int charsLeft = this.strings[this.index].length() - this.charPos;
            if (charsLeft > len) {
                this.strings[this.index].getChars(this.charPos, this.charPos + len, cbuf, off);
                this.charPos += len;
                charsInBuf += len;
                continue;
            }
            this.strings[this.index++].getChars(this.charPos, this.charPos + charsLeft, cbuf, off);
            off += charsLeft;
            len -= charsLeft;
            this.charPos = 0;
            charsInBuf += charsLeft;
        }
        return charsInBuf;
    }
}

