/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.sax;

import com.cognos.cps.common.ExceptionExtension;
import com.cognos.cps.common.message.MessagesManager;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Locale;
import org.xml.sax.SAXException;

public class EnhancedSAXException
extends SAXException
implements ExceptionExtension {
    private final String m_key;
    private final Object[] m_args;
    private final Exception m_rootCause;

    public EnhancedSAXException(String key) {
        super(key);
        this.m_key = key;
        this.m_args = null;
        this.m_rootCause = null;
    }

    public EnhancedSAXException(String key, Exception rootCause) {
        super(key, rootCause);
        this.m_key = key;
        this.m_args = null;
        this.m_rootCause = rootCause;
    }

    public EnhancedSAXException(String key, Object[] args) {
        super(key);
        this.m_key = key;
        this.m_args = args;
        this.m_rootCause = null;
    }

    public EnhancedSAXException(String key, Object[] args, Exception rootCause) {
        super(key);
        this.m_key = key;
        this.m_args = args;
        this.m_rootCause = rootCause;
    }

    @Override
    public Throwable getRootCause() {
        return this.m_rootCause;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMsgString(Locale.getDefault());
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this.m_rootCause != null) {
            this.m_rootCause.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.m_rootCause != null) {
            this.m_rootCause.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.m_rootCause != null) {
            this.m_rootCause.printStackTrace(s);
        }
    }

    @Override
    public String getLocalizedMsgString(Locale locale) {
        if (this.m_key == null) {
            return "";
        }
        if (this.m_args == null) {
            return MessagesManager.getInstance().getMessage(locale, this.m_key);
        }
        return MessagesManager.getInstance().getMessage(locale, this.m_key, this.m_args);
    }

    @Override
    public String getKey() {
        return this.m_key;
    }
}

