/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.services.wsdl;

import com.cognos.cps.services.wsdl.BindingOperation;
import com.cognos.cps.services.wsdl.ExtensibleDocumented;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;

public class Binding
extends ExtensibleDocumented
implements Serializable {
    private String _name;
    private String _type;
    private ArrayList _operationList = new ArrayList();

    public void addOperation(BindingOperation vOperation) throws IndexOutOfBoundsException {
        this._operationList.add(vOperation);
    }

    public void addOperation(int index, BindingOperation vOperation) throws IndexOutOfBoundsException {
        this._operationList.add(index, vOperation);
    }

    public void clearOperation() {
        this._operationList.clear();
    }

    public Enumeration enumerateOperation() {
        return new IteratorEnumeration(this._operationList.iterator());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof Binding) {
            Binding temp = (Binding)obj;
            if (this._name != null) {
                if (temp._name == null) {
                    return false;
                }
                if (!this._name.equals(temp._name)) {
                    return false;
                }
            } else if (temp._name != null) {
                return false;
            }
            if (this._type != null) {
                if (temp._type == null) {
                    return false;
                }
                if (!this._type.equals(temp._type)) {
                    return false;
                }
            } else if (temp._type != null) {
                return false;
            }
            if (this._operationList != null) {
                if (temp._operationList == null) {
                    return false;
                }
                if (!this._operationList.equals(temp._operationList)) {
                    return false;
                }
            } else if (temp._operationList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getName() {
        return this._name;
    }

    public BindingOperation getOperation(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._operationList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (BindingOperation)this._operationList.get(index);
    }

    public BindingOperation[] getOperation() {
        int size = this._operationList.size();
        BindingOperation[] mArray = new BindingOperation[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (BindingOperation)this._operationList.get(index);
        }
        return mArray;
    }

    public int getOperationCount() {
        return this._operationList.size();
    }

    public String getType() {
        return this._type;
    }

    @Override
    public int hashCode() {
        int _hashCode = super.hashCode();
        if (this._name != null) {
            _hashCode = 37 * _hashCode + this._name.hashCode();
        }
        if (this._type != null) {
            _hashCode = 37 * _hashCode + this._type.hashCode();
        }
        if (this._operationList != null) {
            _hashCode = 37 * _hashCode + this._operationList.hashCode();
        }
        return _hashCode;
    }

    public boolean removeOperation(BindingOperation vOperation) {
        boolean removed = this._operationList.remove(vOperation);
        return removed;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setOperation(int index, BindingOperation vOperation) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._operationList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._operationList.set(index, vOperation);
    }

    public void setOperation(BindingOperation[] operationArray) {
        this._operationList.clear();
        for (int i = 0; i < operationArray.length; ++i) {
            this._operationList.add(operationArray[i]);
        }
    }

    public void setType(String type) {
        this._type = type;
    }
}

