/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.persist.cache.AbstractBaseCache;
import org.exolab.castor.persist.cache.Cache;

public class TimeLimited
extends AbstractBaseCache
implements Cache {
    private static Log _log = LogFactory.getFactory().getInstance(TimeLimited.class);
    private static final int TICK_DELAY = 1;
    private static final int DEFAULT_PRECISION = 1000;
    private static TickThread timer = new TickThread(1000);
    public static final int DEFAULT_INTERVAL = 30;
    private int interval;
    private int tailtime;
    private QueueItem head;
    private QueueItem tail;
    private Hashtable map = new Hashtable();

    public TimeLimited() {
        this.init(30);
        _log.debug((Object)("Successfully initialized instance of " + this.getClass().getName()));
    }

    public TimeLimited(int interval) {
        this.init(interval);
    }

    protected void init(int interval) {
        this.map = new Hashtable();
        timer.addTickerTask(this);
    }

    public synchronized Object put(Object key, Object value) {
        QueueItem oldItem = (QueueItem)this.map.get(key);
        if (oldItem != null) {
            if (_log.isDebugEnabled()) {
                _log.trace((Object)("TimeLimitedLRU: update(" + value + ")"));
            }
            Object oldObject = oldItem.value;
            oldItem.value = value;
            oldItem.time = this.interval;
            return oldObject;
        }
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("TimeLimitedLRU: put(" + value + ")"));
        }
        QueueItem newitem = new QueueItem(key, value);
        newitem.time = this.interval;
        this.map.put(key, newitem);
        return null;
    }

    public synchronized Object get(Object key) {
        Object o = this.map.get(key);
        if (o == null) {
            return null;
        }
        return ((QueueItem)o).value;
    }

    public void setCapacity(int capacity) {
        super.setCapacity(capacity);
        ++this.interval;
    }

    public synchronized Object remove(Object key) {
        QueueItem queueItem = (QueueItem)this.map.remove(key);
        if (queueItem == null) {
            if (_log.isDebugEnabled()) {
                _log.trace((Object)("TimeLimitedLRU: not in cache ... remove(" + key + ")"));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("TimeLimitedLRU: remove(" + key + ") = " + queueItem.value));
        }
        return queueItem.value;
    }

    public synchronized Enumeration elements() {
        return new ValuesEnumeration(this.map.values());
    }

    public void expire(Object key) {
        this.remove(key);
        this.dispose(key);
    }

    public boolean contains(Object key) {
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("Testing for entry for key " + key));
        }
        return this.map.containsKey(key);
    }

    protected void dispose(Object o) {
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("Disposing " + o));
        }
    }

    private synchronized void tick() {
        if (!this.map.isEmpty()) {
            Iterator iter = this.map.values().iterator();
            while (iter.hasNext()) {
                QueueItem queueItem = (QueueItem)iter.next();
                Object value = queueItem.value;
                if (queueItem.time <= 0) {
                    iter.remove();
                    this.dispose(value);
                    continue;
                }
                queueItem.time -= 1;
            }
        }
    }

    private static class TickThread
    extends Thread {
        private long lastTime;
        private ArrayList list = new ArrayList();
        private int tick;

        public TickThread(int tick) {
            super("Time-limited cache daemon");
            this.tick = tick;
            this.setDaemon(true);
            this.setPriority(1);
            this.start();
        }

        void addTickerTask(TimeLimited cache) {
            this.list.add(cache);
        }

        public void run() {
            try {
                block2: while (true) {
                    long time;
                    if ((time = System.currentTimeMillis()) - this.lastTime < (long)this.tick) {
                        TickThread.sleep((long)this.tick - (time - this.lastTime));
                    }
                    this.lastTime = System.currentTimeMillis();
                    int i = 0;
                    while (true) {
                        if (i >= this.list.size()) continue block2;
                        ((TimeLimited)this.list.get(i)).tick();
                        ++i;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private class QueueItem {
        private Object key;
        private int time;
        private Object value;

        private QueueItem(Object key, Object item) {
            this.key = key;
            this.value = item;
        }
    }

    private class ValuesEnumeration
    implements Enumeration {
        private Enumeration theEnum;

        private ValuesEnumeration(Collection coll) {
            this.theEnum = new Vector(coll).elements();
        }

        public boolean hasMoreElements() {
            return this.theEnum.hasMoreElements();
        }

        public Object nextElement() throws NoSuchElementException {
            return ((QueueItem)this.theEnum.nextElement()).value;
        }
    }
}

