/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import org.exolab.castor.net.URIResolver;
import org.exolab.castor.net.util.URIResolverImpl;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.ScopableResolver;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComplexTypeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.ElementUnmarshaller;
import org.exolab.castor.xml.schema.reader.ImportUnmarshaller;
import org.exolab.castor.xml.schema.reader.IncludeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ModelGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.exolab.castor.xml.schema.reader.UnknownUnmarshaller;
import org.exolab.castor.xml.util.AttributeSetImpl;

public class SchemaUnmarshaller
extends ComponentReader {
    public static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String[] UNSUPPORTED_NAMESPACES = new String[]{"http://www.w3.org/2000/10/XMLSchema", "http://www.w3.org/1999/XMLSchema"};
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_PREFIX = "xmlns:";
    private static final String XML_PREFIX = "xml";
    private boolean _include = false;
    private ComponentReader unmarshaller;
    private int _annotationDepth = 0;
    private int depth = 0;
    boolean skipAll = false;
    Resolver _resolver = null;
    Schema _schema = new Schema();
    private boolean foundSchemaDef = false;
    private String defaultNS = null;
    private SchemaUnmarshallerState _state = null;
    private RemappedPrefixes _prefixMappings = null;
    static /* synthetic */ Class class$org$exolab$castor$xml$schema$reader$SchemaUnmarshaller;

    public SchemaUnmarshaller() throws XMLException {
        this(null, null, null);
        this.foundSchemaDef = false;
    }

    public SchemaUnmarshaller(SchemaUnmarshallerState state) throws XMLException {
        this(null, null, null);
        this._state = state;
        this.foundSchemaDef = false;
    }

    public SchemaUnmarshaller(boolean include, SchemaUnmarshallerState state, URIResolver uriResolver) throws XMLException {
        this(null, null, uriResolver);
        this._state = state;
        this._include = include;
        this.foundSchemaDef = false;
    }

    public SchemaUnmarshaller(AttributeSet atts, Resolver resolver) throws XMLException {
        this(atts, resolver, null);
    }

    public SchemaUnmarshaller(AttributeSet atts, Resolver resolver, URIResolver uriResolver) throws XMLException {
        this._schema.removeNamespace("");
        this.setResolver(resolver);
        if (uriResolver == null) {
            uriResolver = new URIResolverImpl();
        }
        this.setURIResolver(uriResolver);
        this.foundSchemaDef = true;
        this._state = new SchemaUnmarshallerState();
        this.init(atts);
    }

    public Schema getSchema() {
        return this._schema;
    }

    public void setSchema(Schema schema) {
        this._schema = schema;
    }

    public Object getObject() {
        return this.getSchema();
    }

    public String elementName() {
        return "schema";
    }

    private void init(AttributeSet atts) throws XMLException {
        String form;
        if (atts == null) {
            return;
        }
        String attValue = null;
        String nsURI = atts.getValue("targetNamespace");
        if (nsURI != null && nsURI.length() == 0) {
            throw new SchemaException("empty string is not a legal namespace.");
        }
        if (nsURI != null && nsURI.length() > 0) {
            if (this._include && !this._schema.getTargetNamespace().equals(nsURI)) {
                throw new SchemaException("The target namespace of the included components must be the same as the target namespace of the including schema");
            }
            this._schema.setTargetNamespace(nsURI);
        }
        this._schema.setId(atts.getValue("id"));
        this._schema.setVersion(atts.getValue("version"));
        if (!this._include) {
            this._schema.setSchemaLocation(this.getDocumentLocator().getSystemId());
        }
        if ((form = atts.getValue("attributeFormDefault")) != null) {
            this._schema.setAttributeFormDefault(Form.valueOf(form));
        }
        if ((form = atts.getValue("elementFormDefault")) != null) {
            this._schema.setElementFormDefault(Form.valueOf(form));
        }
        if ((attValue = atts.getValue("blockDefault")) != null) {
            this._schema.setBlockDefault(attValue);
        }
        if ((attValue = atts.getValue("finalDefault")) != null) {
            this._schema.setFinalDefault(attValue);
        }
        if ((attValue = atts.getValue("version")) != null) {
            this._schema.setVersion(attValue);
        }
    }

    private void handleNamespaces(Namespaces namespaces) throws XMLException {
        if (namespaces == null) {
            return;
        }
        Enumeration theEnum = namespaces.getLocalNamespaces();
        while (theEnum.hasMoreElements()) {
            String ns = (String)theEnum.nextElement();
            String[] prefixes = namespaces.getNamespacePrefixes(ns, true);
            if (prefixes.length == 0) {
                String error = "unexpected error processing the following namespace: '" + ns + "'; the prefix could not be resolved.";
                throw new XMLException(error);
            }
            boolean hasCollisions = false;
            for (int pIdx = 0; pIdx < prefixes.length; ++pIdx) {
                String prefix = prefixes[pIdx];
                String tmpURI = this._schema.getNamespace(prefix);
                if (tmpURI != null && this.foundSchemaDef) {
                    if (!tmpURI.equals(ns)) {
                        if (!hasCollisions) {
                            hasCollisions = true;
                            this._prefixMappings = this._prefixMappings == null ? new RemappedPrefixes() : this._prefixMappings.newRemappedPrefixes();
                        }
                        if (prefix.length() == 0) {
                            prefix = "ns";
                        }
                        int count = 1;
                        String newPrefix = prefix + count;
                        tmpURI = this._schema.getNamespace(newPrefix);
                        while (tmpURI != null && !tmpURI.equals(ns)) {
                            newPrefix = prefix + ++count;
                            tmpURI = this._schema.getNamespace(newPrefix);
                        }
                        this._prefixMappings.addMapping(prefix, newPrefix);
                        prefix = newPrefix;
                    } else if (this._prefixMappings != null && this._prefixMappings.isRemappedPrefix(prefix)) {
                        this._prefixMappings.addMapping(prefix, prefix);
                    }
                }
                if (prefix.length() == 0) {
                    this.defaultNS = ns;
                    this._schema.addNamespace("", this.defaultNS);
                    continue;
                }
                for (int nsIdx = 0; nsIdx < UNSUPPORTED_NAMESPACES.length; ++nsIdx) {
                    if (!ns.equals(UNSUPPORTED_NAMESPACES[nsIdx])) continue;
                    this.error("The following namespace \"" + ns + "\" is no longer supported. Please update to " + " the W3C XML Schema Recommendation.");
                }
                this._schema.addNamespace(prefix, ns);
            }
        }
    }

    private void handleRemapping(String name, String namespace, AttributeSetImpl atts) {
        if (this._prefixMappings == null) {
            return;
        }
        ++this._prefixMappings.depth;
        String[] remapAtts = (String[])RemappedPrefixes.QNAME_TABLE.get(name);
        if (remapAtts != null) {
            for (int i = 0; i < remapAtts.length; ++i) {
                String value = atts.getValue(remapAtts[i]);
                if (value == null) continue;
                value = this._prefixMappings.remapQName(value);
                atts.setAttribute(remapAtts[i], value);
            }
        }
    }

    public void setResolver(Resolver resolver) {
        if (resolver == null) {
            resolver = new ScopableResolver();
        }
        super.setResolver(resolver);
        this._resolver = resolver;
    }

    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.skipAll) {
            return;
        }
        if (this._annotationDepth == 0) {
            this.handleNamespaces(nsDecls);
        }
        if (!this.foundSchemaDef && namespace == null && this.defaultNS == null) {
            this.defaultNS = XSD_NAMESPACE;
            namespace = XSD_NAMESPACE;
            System.out.println("No namespace declaration has been found for " + name);
            System.out.print("   * assuming default namespace of ");
            System.out.println(XSD_NAMESPACE);
        }
        if (namespace == null) {
            namespace = this.defaultNS;
        }
        if (name.equals("annotation")) {
            ++this._annotationDepth;
        }
        if (!XSD_NAMESPACE.equals(namespace) && this._annotationDepth == 0) {
            this.error("'" + name + "' has not been declared in the XML " + "Schema namespace.");
        }
        if (this._annotationDepth == 0 && this._prefixMappings != null) {
            this.handleRemapping(name, namespace, (AttributeSetImpl)atts);
        }
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if (name.equals("schema")) {
            if (this.foundSchemaDef) {
                this.illegalElement(name);
            }
            this.foundSchemaDef = true;
            this.init(atts);
            return;
        }
        if (name.equals("annotation")) {
            this.unmarshaller = new AnnotationUnmarshaller(atts);
        } else if (name.equals("attribute")) {
            this.unmarshaller = new AttributeUnmarshaller(this._schema, atts, this.getResolver());
        } else if (name.equals("attributeGroup")) {
            this.unmarshaller = new AttributeGroupUnmarshaller(this._schema, atts);
        } else if (name.equals("complexType")) {
            this.unmarshaller = new ComplexTypeUnmarshaller(this._schema, atts, this._resolver);
        } else if (name.equals("element")) {
            this.unmarshaller = new ElementUnmarshaller(this._schema, atts, this._resolver);
        } else if (name.equals("simpleType")) {
            this.unmarshaller = new SimpleTypeUnmarshaller(this._schema, atts);
        } else if (name.equals("group")) {
            this.unmarshaller = new ModelGroupUnmarshaller(this._schema, atts, this._resolver);
        } else if (name.equals("include")) {
            this.unmarshaller = new IncludeUnmarshaller(this._schema, atts, this._resolver, this.getURIResolver(), this.getDocumentLocator(), this._state);
        } else if (name.equals("import")) {
            this.unmarshaller = new ImportUnmarshaller(this._schema, atts, this._resolver, this.getURIResolver(), this.getDocumentLocator(), this._state);
        } else {
            System.out.print('<');
            System.out.print(name);
            System.out.print("> elements are either currently unsupported ");
            System.out.println("or non-valid schema elements.");
            this.unmarshaller = new UnknownUnmarshaller(name);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String name, String namespace) throws XMLException {
        if (this.skipAll) {
            return;
        }
        if (namespace == null) {
            namespace = this.defaultNS;
        }
        if (name.equals("annotation")) {
            --this._annotationDepth;
        }
        if (this._prefixMappings != null) {
            if (this._prefixMappings.depth == 0) {
                this._prefixMappings = this._prefixMappings.getParent();
            } else {
                --this._prefixMappings.depth;
            }
        }
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        if ((name = name.intern()) == "schema") {
            return;
        }
        if (this.unmarshaller != null) {
            if (!name.equals(this.unmarshaller.elementName())) {
                String err = "error: missing end element for ";
                err = err + this.unmarshaller.elementName();
                throw new SchemaException(err);
            }
        } else {
            String err = "error: missing start element for " + name;
            throw new SchemaException(err);
        }
        this.unmarshaller.finish();
        if (name.equals("annotation")) {
            this._schema.addAnnotation((Annotation)this.unmarshaller.getObject());
        } else if (name.equals("attribute")) {
            this._schema.addAttribute((AttributeDecl)this.unmarshaller.getObject());
        } else if (name.equals("attributeGroup")) {
            Object obj = this.unmarshaller.getObject();
            try {
                this._schema.addAttributeGroup((AttributeGroupDecl)obj);
            }
            catch (ClassCastException ex) {
                String err = "Top-level AttributeGroups must be defining AttributeGroups and not referring AttributeGroups.";
                this.error(err);
            }
        } else if (name.equals("complexType")) {
            ComplexType complexType = null;
            complexType = ((ComplexTypeUnmarshaller)this.unmarshaller).getComplexType();
            this._schema.addComplexType(complexType);
            if (complexType.getName() != null) {
                this._resolver.addResolvable(complexType.getReferenceId(), complexType);
            } else {
                System.out.println("warning: top-level complexType with no name.");
            }
        } else if (name.equals("simpleType")) {
            SimpleType simpleType = null;
            simpleType = ((SimpleTypeUnmarshaller)this.unmarshaller).getSimpleType();
            this._schema.addSimpleType(simpleType);
            this._resolver.addResolvable(simpleType.getReferenceId(), simpleType);
        } else if (name.equals("element")) {
            ElementDecl element = null;
            element = ((ElementUnmarshaller)this.unmarshaller).getElement();
            this._schema.addElementDecl(element);
        } else if (name.equals("group")) {
            ModelGroup group = null;
            group = ((ModelGroupUnmarshaller)this.unmarshaller).getGroup();
            this._schema.addModelGroup(group);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }

    static class RemappedPrefixes {
        public static final String RESOURCE_NAME = "prefixremap.properties";
        public static final String RESOURCE_LOCATION = "/org/exolab/castor/xml/schema/reader/";
        public static final HashMap QNAME_TABLE = new HashMap();
        private static boolean initialized = false;
        private HashMap _prefixes = null;
        private RemappedPrefixes _parent = null;
        int depth = 0;

        RemappedPrefixes() {
        }

        public boolean isRemappedPrefix(String prefix) {
            if (prefix == null) {
                prefix = "";
            }
            if (this._prefixes != null && this._prefixes.get(prefix) != null) {
                return true;
            }
            if (this._parent != null) {
                return this._parent.isRemappedPrefix(prefix);
            }
            return false;
        }

        public RemappedPrefixes getParent() {
            return this._parent;
        }

        public String getPrefixMapping(String oldPrefix) {
            String newPrefix;
            if (this._prefixes != null && (newPrefix = (String)this._prefixes.get(oldPrefix)) != null) {
                return newPrefix;
            }
            if (this._parent != null) {
                return this._parent.getPrefixMapping(oldPrefix);
            }
            return oldPrefix;
        }

        public RemappedPrefixes newRemappedPrefixes() {
            RemappedPrefixes rp = new RemappedPrefixes();
            rp._parent = this;
            return rp;
        }

        public void addMapping(String oldPrefix, String newPrefix) {
            if (this._prefixes == null) {
                this._prefixes = new HashMap();
            }
            this._prefixes.put(oldPrefix, newPrefix);
        }

        public String remapQName(String value) {
            if (value == null) {
                return null;
            }
            int idx = value.indexOf(58);
            String prefix = "";
            if (idx >= 0) {
                prefix = value.substring(0, idx);
            } else {
                idx = -1;
            }
            String newPrefix = this.getPrefixMapping(prefix);
            if (!prefix.equals(newPrefix)) {
                value = newPrefix.length() == 0 ? value.substring(idx + 1) : newPrefix + ":" + value.substring(idx + 1);
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            HashMap hashMap = QNAME_TABLE;
            synchronized (hashMap) {
                if (!initialized) {
                    initialized = true;
                    QNAME_TABLE.put("attribute", new String[]{"ref", "type"});
                    QNAME_TABLE.put("attributeGroup", new String[]{"ref"});
                    QNAME_TABLE.put("element", new String[]{"ref", "type"});
                    QNAME_TABLE.put("extension", new String[]{"base"});
                    QNAME_TABLE.put("group", new String[]{"ref"});
                    QNAME_TABLE.put("restriction", new String[]{"base"});
                    String filename = "/org/exolab/castor/xml/schema/reader/prefixremap.properties";
                    InputStream is = (class$org$exolab$castor$xml$schema$reader$SchemaUnmarshaller == null ? (class$org$exolab$castor$xml$schema$reader$SchemaUnmarshaller = SchemaUnmarshaller.class$("org.exolab.castor.xml.schema.reader.SchemaUnmarshaller")) : class$org$exolab$castor$xml$schema$reader$SchemaUnmarshaller).getResourceAsStream(filename);
                    Properties props = new Properties();
                    if (is != null) {
                        try {
                            props.load(is);
                        }
                        catch (IOException iox) {
                            // empty catch block
                        }
                    }
                    Enumeration<?> keys = props.propertyNames();
                    while (keys.hasMoreElements()) {
                        String name = (String)keys.nextElement();
                        StringTokenizer st = new StringTokenizer(props.getProperty(name), ",");
                        String[] atts = new String[st.countTokens()];
                        int index = 0;
                        while (st.hasMoreTokens()) {
                            atts[index++] = st.nextToken();
                        }
                        QNAME_TABLE.put(name, atts);
                    }
                }
            }
        }
    }
}

