/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.plumtree;

import com.cognos.cps.common.ExceptionExtension;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.wsrp.v1.types.BlockingInteractionResponse;
import com.cognos.cps.services.wsrp.v1.types.MarkupContext;
import com.cognos.cps.services.wsrp.v1.types.UpdateResponse;
import com.cognos.cps.wsrp.consumer.CSSClassSubstituter;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionException;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionHandler;
import com.cognos.cps.wsrp.consumer.ConsumerException;
import com.cognos.cps.wsrp.consumer.ErrorPage;
import com.cognos.cps.wsrp.consumer.RequestContext;
import com.cognos.cps.wsrp.consumer.RequestHelper;
import com.cognos.cps.wsrp.consumer.RequestHelperFactory;
import com.cognos.cps.wsrp.consumer.URLRewriteException;
import com.cognos.cps.wsrp.consumer.URLRewriter;
import com.cognos.cps.wsrp.consumer.helpers.ApplicationSessionManager;
import com.cognos.cps.wsrp.consumer.helpers.CSSClassSubstitutionHandlerImpl;
import com.cognos.cps.wsrp.consumer.impls.plumtree.GDKRequest;
import com.cognos.cps.wsrp.consumer.impls.plumtree.GDKResponse;
import com.cognos.cps.wsrp.consumer.impls.plumtree.GDKSettings;
import com.cognos.cps.wsrp.consumer.impls.plumtree.RequestContextImpl;
import com.cognos.cps.wsrp.consumer.impls.plumtree.ServiceLoggerImpl;
import com.cognos.cps.wsrp.consumer.impls.plumtree.WSRPParams;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;

public class Consumer {
    private static final String BLOCKING_INTERACTION_RESPONSE = "BlockingInteractionResponse";
    private static final String PACKAGE_MARKER = "[package]";
    private static final String PMODE = "pmode";
    private static final String PMODE_VIEW = "view";
    private static final String PMODE_EDIT = "edit";
    private static final String PMODE_CONFIGURE = "configure";
    private static final String PMODE_CONFIG = "config";
    private static final String PMODE_HELP = "help";
    private static final String PROPERTY_CPS_ENDPOINT = "cps_endpoint";
    private static final String PROPERTY_LOGGING_LEVEL = "logging_level";
    private static final String PROPERTY_IMAGES_PATH = "images_path";
    private static final String PROPERTY_MAX_CACHED_PAGES = "max_cached_pages";
    private static final String EXCEPTION = "ConsumerException";
    private static final String WSRP_WSDL_LOCATION = "_crn-wsrp-wsdl-location";
    private CSSClassSubstitutionHandler m_cssNameHandler;
    private ServiceLoggerImpl m_logger;
    private int m_maxCachedPages = 0;

    public Consumer(ServiceLoggerImpl logger) {
        try {
            Properties cssMappings = new Properties();
            cssMappings.load(GDKSettings.class.getClassLoader().getResourceAsStream("cpsaluiCSSMappings.properties"));
            this.m_cssNameHandler = new CSSClassSubstitutionHandlerImpl(cssMappings);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        String loggingLevel = GDKSettings.getConsumerProperty(PROPERTY_LOGGING_LEVEL, "ERROR");
        this.m_logger = new ServiceLoggerImpl(logger, "[Consumer]", loggingLevel);
        String maxCachedPages = GDKSettings.getConsumerProperty(PROPERTY_MAX_CACHED_PAGES, "0");
        if (maxCachedPages != null && maxCachedPages.length() > 0) {
            try {
                this.m_maxCachedPages = Integer.parseInt(maxCachedPages);
            }
            catch (NumberFormatException e) {
                this.m_logger.error("Exception occurred while converting 'max_cached_pages' to an integer.", e);
            }
        }
    }

    private WSRPParams createWSRPParams(GDKRequest request) throws ServletException {
        int indexOfSlash;
        String pathInfo;
        int startIndex = (pathInfo = request.getHttpServletRequest().getPathInfo()).startsWith("/") ? 1 : 0;
        String portletPackagePart = pathInfo.substring(startIndex, indexOfSlash = pathInfo.indexOf(47, startIndex));
        if (portletPackagePart.length() == 0) {
            this.m_logger.error(MessagesManager.getInstance().getMessage(request.getHttpServletRequest().getLocale(), "cps.alui.missingportletpackage"));
            throw new ServletException(MessagesManager.getInstance().getMessage(request.getHttpServletRequest().getLocale(), "cps.alui.missingportletpackage"));
        }
        String portletHandlePart = pathInfo.substring(indexOfSlash + 1);
        if (portletHandlePart.length() == 0) {
            this.m_logger.error(MessagesManager.getInstance().getMessage(request.getHttpServletRequest().getLocale(), "cps.alui.missingportlethandle"));
            throw new ServletException(MessagesManager.getInstance().getMessage(request.getHttpServletRequest().getLocale(), "cps.alui.missingportlethandle"));
        }
        if (portletPackagePart.equals("portlets")) {
            if (portletHandlePart.equals("cws")) {
                portletPackagePart = "sdk";
                portletHandlePart = "remote";
            } else if (portletHandlePart.equals("navigator") || portletHandlePart.equals("search") || portletHandlePart.equals("viewer")) {
                portletPackagePart = "nav";
            }
        }
        WSRPParams wsrp = new WSRPParams();
        wsrp.registrationHandle = portletPackagePart;
        wsrp.portletHandle = portletHandlePart;
        return wsrp;
    }

    public void dispatch(GDKRequest request, GDKResponse response) throws ServletException {
        WSRPParams wsrp = this.createWSRPParams(request);
        String pmode = request.getParameter(PMODE);
        String wsrpUrlType = request.getParameter("wsrp-urlType");
        if (pmode != null && pmode.length() != 0) {
            this.dispatchPlumtreeRequest(pmode, wsrp, request, response);
            return;
        }
        if (wsrpUrlType != null && wsrpUrlType.length() != 0) {
            if ("resource".equals(wsrpUrlType)) {
                this.dispatchWSRPResource(wsrp, request, response);
                return;
            }
            this.dispatchWSRPUrlRequest(wsrpUrlType, wsrp, request, response);
            return;
        }
        this.redirectToImgServer(request, response);
    }

    private void dispatchWSRPResource(WSRPParams wsrp, GDKRequest request, GDKResponse response) throws ServletException {
        HttpServletResponse servletResponse = response.getHttpServletResponse();
        try {
            String wsrpUrl = request.getParameter("wsrp-url");
            if (wsrpUrl != null) {
                StringBuffer urlString = new StringBuffer();
                String anchor = null;
                int anchorIndex = wsrpUrl.indexOf(35);
                if (anchorIndex != -1) {
                    anchor = wsrpUrl.substring(anchorIndex);
                    urlString.append(wsrpUrl.substring(0, anchorIndex));
                } else {
                    urlString.append(wsrpUrl);
                }
                boolean isFirst = true;
                Enumeration enumeration = request.getParameterNames();
                while (enumeration.hasMoreElements()) {
                    String name = (String)enumeration.nextElement();
                    if (name.startsWith("wsrp-")) continue;
                    if (name.equals("cognosPortletIds")) {
                        this.synchronizePortletsSessions(request);
                        continue;
                    }
                    if (isFirst) {
                        isFirst = false;
                        if (wsrpUrl.indexOf(63) == -1) {
                            urlString.append('?');
                        } else {
                            urlString.append('&');
                        }
                    } else {
                        urlString.append('&');
                    }
                    urlString.append(name);
                    urlString.append("=");
                    String value = request.getParameter(name);
                    if (value == null) continue;
                    urlString.append(EncodingUtils.urlEncode((String)value, (String)"UTF-8", (boolean)false));
                }
                if (anchor != null) {
                    urlString.append(anchor);
                }
                String requiresRewrite = request.getParameter("wsrp-requiresRewrite");
                RequestContextImpl requestContext = new RequestContextImpl(request, response, wsrp, this.m_logger, this.m_maxCachedPages, this.m_cssNameHandler, this.getWsdlUrlValue(wsrp, request));
                RequestHelper requestHelper = this.getRequestHelper(wsrp, (RequestContext)requestContext, request);
                requestHelper.getResource(urlString.toString(), (RequestContext)requestContext, servletResponse, "POST".equals(request.getHttpServletRequest().getMethod()), requiresRewrite != null && "true".equals(requiresRewrite));
            } else {
                servletResponse.sendError(400, "missing 'wsrp-url' param");
            }
        }
        catch (Throwable e) {
            if (this.m_logger.isErrorEnabled()) {
                this.m_logger.error("An exception occurred while retrieving resource ", e);
            }
            StringWriter error = new StringWriter();
            e.printStackTrace(new PrintWriter(error));
            try {
                servletResponse.sendError(500, error.getBuffer().toString());
            }
            catch (IOException e1) {
                throw new ServletException(e1.getMessage());
            }
        }
    }

    private void dispatchPlumtreeRequest(String pmode, WSRPParams wsrp, GDKRequest request, GDKResponse response) throws ServletException {
        wsrp.navigationalState = this.retrieveWSRPNavigationalState(request);
        String handle = wsrp.portletHandle;
        this.m_logger.debug("in dispatchplutreerequest handle is " + handle + "pmode is " + pmode);
        if (wsrp.navigationalState == null) {
            wsrp.navigationalState = "";
        }
        if (pmode.equals(PMODE_VIEW)) {
            if (request.isPreviewMode()) {
                this.m_logger.debug("doPreview() called.");
                wsrp.mode = "wsrp:preview";
            } else {
                this.m_logger.debug("doView() called.");
                wsrp.mode = "wsrp:view";
            }
            wsrp.windowState = "wsrp:normal";
            this.handleMarkupRequest(wsrp, request, response);
        } else if (pmode.equals(PMODE_EDIT)) {
            this.m_logger.debug("doEdit() called.");
            wsrp.mode = "wsrp:edit";
            boolean singleAggregationMode = request.isSingleAggregationMode();
            if (singleAggregationMode) {
                wsrp.windowState = "wsrp:solo";
                String title = MessagesManager.getInstance().getMessage(request.getHttpServletRequest().getLocale(), "cps.alui.editpagetitle", null);
                this.handleMarkupRequestAsSolo(title, wsrp, request, response);
            } else {
                wsrp.windowState = "wsrp:maximized";
                response.setHostedDisplayMode();
                this.handleMarkupRequest(wsrp, request, response);
            }
        } else if (pmode.equals(PMODE_HELP)) {
            this.m_logger.debug("doHelp() called.");
            wsrp.mode = "wsrp:help";
            wsrp.windowState = "wsrp:solo";
            this.handleMarkupRequest(wsrp, request, response);
        } else if (pmode.equals(PMODE_CONFIGURE) || pmode.equals(PMODE_CONFIG)) {
            this.m_logger.debug("doConfigure() called.");
            wsrp.mode = "cps:config";
            wsrp.windowState = "wsrp:solo";
            String title = MessagesManager.getInstance().getMessage(request.getHttpServletRequest().getLocale(), "cps.alui.configpagetitle", null);
            this.handleMarkupRequestAsSolo(title, wsrp, request, response);
        } else {
            throw new ServletException(MessagesManager.getInstance().getMessage(request.getHttpServletRequest().getLocale(), "cps.alui.invalidmode", new Object[]{pmode}));
        }
    }

    private void dispatchWSRPUrlRequest(String wsrpUrlType, WSRPParams wsrp, GDKRequest request, GDKResponse response) throws ServletException {
        wsrp.mode = request.getParameter("wsrp-mode");
        this.m_logger.debug("in dispatchWSRPUrlRequest mode is " + wsrp.mode);
        if (wsrp.mode == null || wsrp.mode.length() == 0) {
            wsrp.mode = "wsrp:view";
        }
        wsrp.windowState = request.getParameter("wsrp-windowState");
        if (wsrp.windowState == null || wsrp.windowState.length() == 0) {
            wsrp.windowState = "wsrp:normal";
        }
        if (wsrpUrlType.equals("blockingAction")) {
            this.doPerformBlockingInteraction(wsrp, request, response);
        } else if (wsrpUrlType.equals("render")) {
            this.doRender(wsrp, request, response);
        } else {
            throw new ServletException(MessagesManager.getInstance().getMessage(request.getHttpServletRequest().getLocale(), "cps.alui.invalidurltype", new Object[]{wsrpUrlType}));
        }
        boolean singleAggregationMode = request.isSingleAggregationMode();
        if (wsrp.mode.equals("wsrp:help") || wsrp.mode.equals("wsrp:edit") && !singleAggregationMode || wsrp.windowState.equals("wsrp:maximized")) {
            response.setHostedDisplayMode();
            this.handleMarkupRequest(wsrp, request, response);
        } else if (wsrp.mode.equals("cps:config") || wsrp.mode.equals("wsrp:edit") || wsrp.windowState.equals("wsrp:solo")) {
            String title = null;
            title = wsrp.mode.equals("wsrp:edit") ? MessagesManager.getInstance().getMessage(request.getHttpServletRequest().getLocale(), "cps.alui.editpagetitle", null) : MessagesManager.getInstance().getMessage(request.getHttpServletRequest().getLocale(), "cps.alui.configpagetitle", null);
            this.handleMarkupRequestAsSolo(title, wsrp, request, response);
        } else {
            this.redirectToReturnURI(request, response);
        }
    }

    private void redirectToReturnURI(GDKRequest request, GDKResponse response) throws ServletException {
        String url = request.getReturnURI();
        String gadgetId = request.getGadgetId();
        try {
            response.getHttpServletResponse().sendRedirect(response.getHttpServletResponse().encodeRedirectURL(url + "#" + gadgetId));
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void redirectToImgServer(GDKRequest request, GDKResponse response) throws ServletException {
        int end;
        String imgServer = request.getImageServerURI();
        String imgPath = GDKSettings.getConsumerProperty(PROPERTY_IMAGES_PATH, "");
        String pathInfo = request.getHttpServletRequest().getPathInfo();
        int start = imgServer.endsWith("/") && imgPath.startsWith("/") ? 1 : 0;
        int n = end = imgPath.length() > 1 && imgPath.endsWith("/") && pathInfo.startsWith("/") ? imgPath.length() - 1 : 0;
        if (start != 0 || end != imgPath.length()) {
            imgPath = imgPath.substring(start, end);
        }
        try {
            response.getHttpServletResponse().sendRedirect(response.getHttpServletResponse().encodeRedirectURL(imgServer + imgPath + pathInfo));
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void doRender(WSRPParams wsrp, GDKRequest request, GDKResponse response) {
        wsrp.navigationalState = request.getParameter("wsrp-navigationalState");
        if (wsrp.navigationalState != null) {
            this.storeWSRPNavigationalState(wsrp.navigationalState, request);
        }
    }

    private void doPerformBlockingInteraction(WSRPParams wsrp, GDKRequest request, GDKResponse response) {
        wsrp.navigationalState = request.getParameter("wsrp-navigationalState");
        if (wsrp.navigationalState != null) {
            this.storeWSRPNavigationalState(wsrp.navigationalState, request);
        }
        wsrp.interactionState = request.getParameter("wsrp-interactionState");
        try {
            RequestContextImpl requestContext = new RequestContextImpl(request, response, wsrp, this.m_logger, this.m_maxCachedPages, this.getWsdlUrlValue(wsrp, request));
            this.synchronizePortletsSessions(request);
            RequestHelper requestHelper = this.getRequestHelper(wsrp, (RequestContext)requestContext, request);
            try {
                BlockingInteractionResponse blockingInteractionResponse = requestHelper.performBlockingInteraction((RequestContext)requestContext);
                UpdateResponse updateResponse = blockingInteractionResponse.getUpdateResponse();
                if (updateResponse != null) {
                    String newWindowState;
                    String newMode = updateResponse.getNewMode();
                    if (newMode != null) {
                        wsrp.mode = newMode;
                    }
                    if ((newWindowState = updateResponse.getNewWindowState()) != null) {
                        wsrp.windowState = newWindowState;
                    }
                    wsrp.navigationalState = updateResponse.getNavigationalState();
                    if (wsrp.navigationalState != null && wsrp.mode.equals("wsrp:view")) {
                        this.storeWSRPNavigationalState(wsrp.navigationalState, request);
                    }
                }
                String previousMode = request.getParameter("prevMode");
                if ("wsrp:view".equals(wsrp.mode) && ("wsrp:edit".equals(previousMode) || "cps:config".equals(previousMode)) && "wsrp:solo".equals(wsrp.windowState)) {
                    wsrp.windowState = "wsrp:normal";
                } else {
                    request.getHttpServletRequest().getSession(true).setAttribute(BLOCKING_INTERACTION_RESPONSE, (Object)blockingInteractionResponse);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ConsumerException("cps.alui.wsrp.operationfailed", new Object[]{"performBlockingInteraction"}, (Throwable)e);
            }
        }
        catch (Exception e) {
            this.storeException(e, request);
        }
    }

    private void synchronizePortletsSessions(GDKRequest request) {
        String cognosPortletIds = request.getParameter("cognosPortletIds");
        if (cognosPortletIds != null) {
            StringTokenizer tokenizer = new StringTokenizer(cognosPortletIds, "_");
            ArrayList<String> sessions = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                sessions.add(tokenizer.nextToken());
            }
            ApplicationSessionManager.synchronizeSessions(sessions);
        }
    }

    private void handleMarkupRequestAsSolo(String title, WSRPParams wsrp, GDKRequest request, GDKResponse response) {
        try {
            PrintWriter writer = response.getHttpServletResponse().getWriter();
            ((Writer)writer).write("<html>");
            ((Writer)writer).write("<head>");
            ((Writer)writer).write("<title>");
            ((Writer)writer).write(title);
            ((Writer)writer).write("</title>");
            ((Writer)writer).write("<link REL=\"STYLESHEET\" HREF=\"" + request.getCurrentStyleSheet() + "\" TYPE=\"text/css\">");
            ((Writer)writer).write("</head> ");
            this.handleMarkupRequest(wsrp, request, response);
            ((Writer)writer).write("</html> ");
        }
        catch (IOException e) {
            this.renderErrorPage(new ConsumerException("cps.alui.getmarkupfailed", null, (Throwable)e), request, response);
        }
    }

    private void handleMarkupRequest(WSRPParams wsrp, GDKRequest request, GDKResponse response) {
        this.m_logger.debug("handleMarkupRequest() called.");
        Exception retrievedException = this.retrieveException(request);
        if (retrievedException != null) {
            if (retrievedException instanceof ConsumerException) {
                this.renderErrorPage((ConsumerException)((Object)retrievedException), request, response);
            } else {
                this.renderErrorPage(new ConsumerException("cps.alui.getmarkupfailed", null, (Throwable)retrievedException), request, response);
            }
            return;
        }
        long start = 0L;
        if (this.m_logger.isInfoEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            InputStream is;
            RequestContextImpl requestContext = new RequestContextImpl(request, response, wsrp, this.m_logger, this.m_maxCachedPages, this.m_cssNameHandler, this.getWsdlUrlValue(wsrp, request));
            if (wsrp.mode == "wsrp:view" && (is = this.getClass().getResourceAsStream("synch.js")) != null) {
                InputStreamReader reader = new InputStreamReader(is);
                CharArrayWriter bufwriter = new CharArrayWriter();
                char[] buf = new char[4096];
                int charsread = reader.read(buf);
                while (charsread != -1) {
                    bufwriter.write(buf, 0, charsread);
                    charsread = reader.read(buf);
                }
                URLRewriter rewriter = new URLRewriter(requestContext.getURLRewriteHandler(), (ServiceLogger)this.m_logger);
                Writer outputWriter = requestContext.getResultWriter();
                outputWriter.write("<script language=\"JavaScript\" type=\"text/javascript\">\n<!--\n");
                rewriter.rewrite(bufwriter.toCharArray(), outputWriter);
                outputWriter.write("\n//-->\n</script>\n");
            }
            RequestHelper requestHelper = this.getRequestHelper(wsrp, (RequestContext)requestContext, request);
            boolean isMarkupProcessed = false;
            BlockingInteractionResponse blockingInteractionResponse = (BlockingInteractionResponse)request.getHttpServletRequest().getSession(true).getAttribute(BLOCKING_INTERACTION_RESPONSE);
            if (blockingInteractionResponse != null) {
                MarkupContext markupContext;
                request.getHttpServletRequest().getSession(true).removeAttribute(BLOCKING_INTERACTION_RESPONSE);
                UpdateResponse updateResponse = blockingInteractionResponse.getUpdateResponse();
                if (updateResponse != null && (markupContext = updateResponse.getMarkupContext()) != null) {
                    requestHelper.processMarkupContext((RequestContext)requestContext, markupContext);
                    isMarkupProcessed = true;
                }
            }
            if (!isMarkupProcessed) {
                requestHelper.getMarkup((RequestContext)requestContext);
            }
        }
        catch (CSSClassSubstitutionException e) {
            this.renderErrorPage(new ConsumerException("cps.alui.cssclasssubstitution", null, (Throwable)e), request, response);
        }
        catch (URLRewriteException e) {
            this.renderErrorPage(new ConsumerException("cps.alui.rewritefailed", null, (Throwable)e), request, response);
        }
        catch (ConsumerException e) {
            this.renderErrorPage(new ConsumerException("cps.alui.getmarkupfailed", null, (Throwable)e), request, response);
        }
        catch (IOException e) {
            this.renderErrorPage(new ConsumerException("cps.alui.getmarkupfailed", null, (Throwable)e), request, response);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.renderErrorPage(new ConsumerException("cps.alui.getmarkupfailed", null, e), request, response);
        }
        if (this.m_logger.isInfoEnabled()) {
            long end = System.currentTimeMillis();
            this.m_logger.info("handleMarkupRequest for Portlet mode '" + wsrp.mode + "' took: " + (end - start) + "ms.");
        }
    }

    private Exception retrieveException(GDKRequest request) {
        Exception e = (Exception)request.getHttpServletRequest().getSession(true).getAttribute(EXCEPTION);
        request.getHttpServletRequest().getSession(true).removeAttribute(EXCEPTION);
        return e;
    }

    private void storeException(Exception exception, GDKRequest request) {
        request.getHttpServletRequest().getSession(true).setAttribute(EXCEPTION, (Object)exception);
    }

    private void storeWSRPNavigationalState(String navigationalState, GDKRequest request) {
        this.m_logger.debug("storeWSRPNavigationalState() called.");
        request.getHttpServletRequest().getSession(true).setAttribute("wsrp-navigationalState", (Object)navigationalState);
    }

    private String retrieveWSRPNavigationalState(GDKRequest request) {
        this.m_logger.debug("retrieveWSRPNavigationalState() called.");
        return (String)request.getHttpServletRequest().getSession(true).getAttribute("wsrp-navigationalState");
    }

    private RequestHelper getRequestHelper(WSRPParams params, RequestContext requestContext, GDKRequest request) throws IOException, ConsumerException, ServiceException {
        this.m_logger.debug("getRequestHelper() called.");
        String wsdlLocation = this.getWsdlUrlValue(params, request);
        String portletHandle = params.portletHandle;
        if (portletHandle == null || portletHandle.length() == 0) {
            this.m_logger.error(MessagesManager.getInstance().getMessage(request.getHttpServletRequest().getLocale(), "cps.alui.missingportlethandle"));
            throw new ConsumerException(MessagesManager.getInstance().getMessage(request.getHttpServletRequest().getLocale(), "cps.alui.missingportlethandle"));
        }
        return RequestHelperFactory.newInstance().createRequestHelper(requestContext, new URL(wsdlLocation), portletHandle);
    }

    private String getWsdlUrlValue(WSRPParams params, GDKRequest request) throws ConsumerException {
        String wsdlLocation = GDKSettings.getConsumerProperty(PROPERTY_CPS_ENDPOINT);
        if (wsdlLocation == null) {
            throw new ConsumerException(MessagesManager.getInstance().getMessage(request.getHttpServletRequest().getLocale(), "cps.ws.missingapplicationparam", new Object[]{WSRP_WSDL_LOCATION}));
        }
        if (wsdlLocation.length() == 0) {
            throw new ConsumerException(MessagesManager.getInstance().getMessage(request.getHttpServletRequest().getLocale(), "cps.ws.emptyapplicationparam", new Object[]{WSRP_WSDL_LOCATION}));
        }
        int index = wsdlLocation.indexOf(PACKAGE_MARKER);
        if (index != -1) {
            StringBuffer modifiedWsdlLocation = new StringBuffer(512);
            modifiedWsdlLocation.append(wsdlLocation.substring(0, index));
            modifiedWsdlLocation.append(params.registrationHandle);
            modifiedWsdlLocation.append(wsdlLocation.substring(index + PACKAGE_MARKER.length(), wsdlLocation.length()));
            wsdlLocation = modifiedWsdlLocation.toString();
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("Calculating wsdl url: ");
                this.m_logger.debug("Package part is: " + params.registrationHandle);
                this.m_logger.debug("new wsdl location is: " + wsdlLocation);
            }
        }
        return wsdlLocation;
    }

    private void renderErrorPage(ConsumerException exception, GDKRequest request, GDKResponse response) {
        this.m_logger.error("renderErrorPage() called.", exception);
        try {
            String imgBaseURL = request.getHttpServletRequest().getContextPath() + GDKSettings.getConsumerProperty(PROPERTY_IMAGES_PATH, "");
            CSSClassSubstituter classSubstituter = new CSSClassSubstituter(this.m_cssNameHandler, (ServiceLogger)this.m_logger);
            classSubstituter.substitute(ErrorPage.render((ExceptionExtension)exception, (Locale)request.getHttpServletRequest().getLocale(), (String)imgBaseURL), (Writer)response.getHttpServletResponse().getWriter());
        }
        catch (Throwable e) {
            this.m_logger.error("Failed to render CPS error page.", e);
            try {
                response.getHttpServletResponse().getWriter().write("<tr><td>&nbsp;</td><td><b>" + exception.getMessage() + "</b></td><td><font color=\"red\">ERROR</font></td></tr>");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

