/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.plumtree;

import com.cognos.cps.wsrp.consumer.impls.plumtree.GDKSettings;
import com.plumtree.remote.portlet.UserInterface;
import com.plumtree.remote.portlet.xp.IXPSettingsManager;
import com.plumtree.remote.util.RequestParameterParser;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GDKRequest {
    private static final String PLUMTREE_GUEST_ID = "2";
    private static final String CSP_AGGREGATION_MODE = "CSP-Aggregation-Mode";
    private static final String AGGREGATION_MODE_SINGLE = "Single";
    private GDKSettings m_settings;
    private HttpServletRequest m_request;
    private RequestParameterParser m_requestParameterParser;

    public GDKRequest(HttpServletRequest request, GDKSettings settings, IXPSettingsManager gsServices, HttpServletResponse response) throws UnsupportedEncodingException {
        this.m_request = request;
        this.m_settings = settings;
        this.m_requestParameterParser = new RequestParameterParser(request, response);
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.m_request;
    }

    public String getParameter(String string) {
        return this.m_requestParameterParser.getParameter(string);
    }

    public Enumeration getParameterNames() {
        return this.m_requestParameterParser.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.m_requestParameterParser.getParameterValues(name);
    }

    public String getRequestedMimeType() {
        String userInterfaceType = this.m_settings.getGSServices().GetUserInterface();
        if (userInterfaceType.equals(UserInterface.Standard)) {
            return "text/html; charset=utf-8";
        }
        if (userInterfaceType.equals(UserInterface.HDML)) {
            return "text/x-hdml; charset=utf-8";
        }
        if (userInterfaceType.equals(UserInterface.PDA)) {
            return "text/html; charset=utf-8";
        }
        if (userInterfaceType.equals(UserInterface.WML)) {
            return "text/vnd.wap.wml; charset=utf-8";
        }
        if (userInterfaceType.equals(UserInterface.Accessible)) {
            return "text/html; charset=utf-8";
        }
        return "text/html; charset=utf-8";
    }

    public Map getAdminSettings() {
        return this.m_settings.getAdminSettings();
    }

    public Map getGadgetSettings() {
        return this.m_settings.getGadgetSettings();
    }

    public Map getGatewaySpecificConfig() {
        return this.m_settings.getGatewaySpecificConfig();
    }

    public String getReturnURI() {
        return (String)this.getGatewaySpecificConfig().get("PT-Return-URI");
    }

    public String getImageServerURI() {
        return (String)this.getGatewaySpecificConfig().get("PT-Imageserver-URI");
    }

    public String getGadgetId() {
        return (String)this.m_settings.getGatewaySpecificConfig().get("PT-Gadget-ID");
    }

    public String getUserId() {
        return (String)this.m_settings.getGatewaySpecificConfig().get("PT-User-ID");
    }

    public String getGadgetSessionId() {
        return this.m_request.getSession(true).getId();
    }

    public String getPortalUserName() {
        return (String)this.getGatewaySpecificConfig().get("PT-User-Name");
    }

    public boolean isSingleAggregationMode() {
        String mode = this.getHttpServletRequest().getHeader(CSP_AGGREGATION_MODE);
        return mode != null && mode.equals(AGGREGATION_MODE_SINGLE);
    }

    public boolean isGuestUser() {
        String userId = (String)this.getGatewaySpecificConfig().get("PT-User-ID");
        return userId.equals(PLUMTREE_GUEST_ID);
    }

    public boolean isPreviewMode() {
        return this.m_settings.getGSServices().GetGadgetMode() == 2;
    }

    public String getRequestPath() {
        return this.m_request.getContextPath() + this.m_request.getServletPath() + this.m_request.getPathInfo();
    }

    public String getTimeZoneId() {
        return this.m_settings.getGSServices().GetTimeZone().GetTZName();
    }

    public String getCurrentStyleSheet() {
        return (String)this.getGatewaySpecificConfig().get("PT-Stylesheet-URI");
    }
}

