/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.plumtree;

import com.cognos.cps.common.message.MessagesManager;
import com.cognos.cps.wsrp.consumer.impls.plumtree.Consumer;
import com.cognos.cps.wsrp.consumer.impls.plumtree.GDKRequest;
import com.cognos.cps.wsrp.consumer.impls.plumtree.GDKResponse;
import com.cognos.cps.wsrp.consumer.impls.plumtree.GDKSettings;
import com.cognos.cps.wsrp.consumer.impls.plumtree.ServiceLoggerImpl;
import com.plumtree.openfoundation.web.IXPRequest;
import com.plumtree.openfoundation.web.IXPResponse;
import com.plumtree.openfoundation.web.XPRequest;
import com.plumtree.openfoundation.web.XPResponse;
import com.plumtree.remote.portlet.xp.IXPSettingsManager;
import com.plumtree.remote.portlet.xp.XPSettingsFactory;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GDKServlet
extends HttpServlet {
    private static final long serialVersionUID = -6946560166546234658L;
    private Consumer m_consumer;
    private static final String MSG_FILE = "cpsconsumermsgs";
    private ServiceLoggerImpl m_logger;

    public void init() {
        ArrayList<String> msgFileList = new ArrayList<String>();
        msgFileList.add(MSG_FILE);
        MessagesManager.getInstance().initialize(msgFileList);
        this.m_logger = new ServiceLoggerImpl(this.getServletContext(), "[" + this.getServletName() + "-" + System.currentTimeMillis() + "]", "ERROR");
        this.m_consumer = new Consumer(this.m_logger);
        this.m_logger.debug("init() called.");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.handleRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.handleRequest(request, response);
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        IXPSettingsManager gsServices = XPSettingsFactory.getXPSettingsManager((IXPRequest)new XPRequest(request, false), (IXPResponse)new XPResponse(response));
        if (!gsServices.IsGatewayedRequest()) {
            this.m_logger.error(MessagesManager.getInstance().getMessage(request.getLocale(), "cps.alui.requestnotgatewayed"));
            throw new ServletException(MessagesManager.getInstance().getMessage(request.getLocale(), "cps.alui.requestnotgatewayed"));
        }
        GDKSettings settings = new GDKSettings(gsServices);
        try {
            GDKRequest gdkRequest = new GDKRequest(request, settings, gsServices, response);
            response.setContentType(gdkRequest.getRequestedMimeType());
            this.m_consumer.dispatch(gdkRequest, new GDKResponse(response, settings));
        }
        catch (UnsupportedEncodingException e) {
            this.m_logger.error(MessagesManager.getInstance().getMessage(request.getLocale(), "cps.alui.unsupportedencoding", new Object[]{request.getCharacterEncoding()}));
            throw new ServletException(MessagesManager.getInstance().getMessage(request.getLocale(), "cps.alui.unsupportedencoding", new Object[]{request.getCharacterEncoding()}));
        }
    }
}

