/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.plumtree;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.CookieUtils;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.cps.soap.helpers.SOAPConnectionImpl;
import com.cognos.cps.wsrp.consumer.HttpSOAPConnection;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import javax.servlet.http.Cookie;

public class HttpSOAPConnectionImpl
extends SOAPConnectionImpl
implements HttpSOAPConnection {
    private static final String AUTH_HEADER = "Authorization";
    private Cookie[] m_requestCookies = null;
    private Cookie[] m_responseCookies = null;
    private final Cookie[] m_requestCookiesToAlwaysInclude;
    private String m_authHeader;
    private String m_namespaceId;
    private Locale m_locale;

    public HttpSOAPConnectionImpl(Cookie[] requestCookiesToAlwaysInclude, SOAPObjectHandler objectHandler, String namespaceId, String authHeader, ServiceLogger logger, Locale locale) {
        super(objectHandler, logger);
        this.m_authHeader = authHeader;
        this.m_requestCookiesToAlwaysInclude = requestCookiesToAlwaysInclude;
        this.m_logger = logger;
        this.m_locale = locale;
        this.m_namespaceId = namespaceId;
    }

    public void setRequestCookies(Cookie[] cookies) {
        this.m_requestCookies = cookies;
    }

    public void addRequestCookies(Cookie[] cookies) {
        this.m_requestCookies = CookieUtils.addCookies((Cookie[])this.m_requestCookies, (Cookie[])cookies);
    }

    public void addRequestCookie(Cookie cookie) {
        this.m_requestCookies = CookieUtils.addCookie((Cookie[])this.m_requestCookies, (Cookie)cookie);
    }

    public Cookie[] getResponseCookies() {
        return this.m_responseCookies;
    }

    public HttpURLConnection openConnection(URL url) throws IOException {
        this.m_logger.debug("openConnection() called.");
        this.m_connection = (HttpURLConnection)url.openConnection();
        if (this.m_authHeader != null && this.m_authHeader.length() > 0) {
            this.m_connection.setRequestProperty(AUTH_HEADER, this.m_authHeader);
        }
        if (this.m_namespaceId != null && this.m_namespaceId.length() > 0) {
            this.m_connection.setRequestProperty("CAM-Namespace", this.m_namespaceId);
        }
        CookieUtils.addCookies((HttpURLConnection)this.m_connection, (Cookie[])CookieUtils.addCookies((Cookie[])this.m_requestCookiesToAlwaysInclude, (Cookie[])this.m_requestCookies));
        this.m_connection.setRequestProperty("Accept-Language", this.m_locale.toString() + ",en-us;q=0.5");
        return this.m_connection;
    }

    public void disconnect() {
        this.m_logger.debug("disconnect() called.");
        this.m_responseCookies = CookieUtils.getSetCookies((HttpURLConnection)this.m_connection);
        if (this.m_responseCookies != null) {
            this.m_logger.debug("Cookies returned in response: ");
            for (int i = 0; i < this.m_responseCookies.length; ++i) {
                this.m_logger.debug("Cookie: " + this.m_responseCookies[i].getName());
            }
        } else {
            this.m_logger.debug("No cookies returned in response.");
        }
    }
}

