/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.plumtree;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.Base64;
import com.cognos.cps.common.utils.GetVersion;
import com.cognos.cps.common.utils.XMLUtils;
import com.cognos.cps.services.pagelet.objects.v1.types.PortalContext;
import com.cognos.cps.services.wsrp.v1.types.ClientData;
import com.cognos.cps.services.wsrp.v1.types.Extension;
import com.cognos.cps.services.wsrp.v1.types.InteractionParams;
import com.cognos.cps.services.wsrp.v1.types.MarkupParams;
import com.cognos.cps.services.wsrp.v1.types.NamedString;
import com.cognos.cps.services.wsrp.v1.types.PortletContext;
import com.cognos.cps.services.wsrp.v1.types.RuntimeContext;
import com.cognos.cps.services.wsrp.v1.types.StateChange;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import com.cognos.cps.services.wsrp.v1.types.UserContext;
import com.cognos.cps.wsrp.consumer.ConsumerException;
import com.cognos.cps.wsrp.consumer.ObjectHandlerDefault;
import com.cognos.cps.wsrp.consumer.helpers.ExtensionHelper;
import com.cognos.cps.wsrp.consumer.impls.plumtree.GDKRequest;
import com.cognos.cps.wsrp.consumer.impls.plumtree.GDKResponse;
import com.cognos.cps.wsrp.consumer.impls.plumtree.GDKSettings;
import com.cognos.cps.wsrp.consumer.impls.plumtree.WSRPParams;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectHandlerImpl
extends ObjectHandlerDefault {
    private WSRPParams m_wsrp;
    protected GDKResponse m_response;
    protected GDKRequest m_request;
    protected List m_forwardCookies;
    protected static final String[] VERSION_PACKAGES = new String[]{"com.cognos.cps.common", "com.cognos.cps.consumer.plumtree", "javax.xml.parsers", "javax.xml.transform", "org.xml.sax", "java.lang"};
    private static final String[] m_supportedModes = new String[]{"wsrp:view", "wsrp:edit", "wsrp:preview", "wsrp:help", "cps:config"};
    private static final String[] m_supportedWindowStates = new String[]{"wsrp:normal", "wsrp:maximized", "wsrp:minimized"};
    protected static final String COOKIES = "Cookies";
    protected static final String NAVIGATIONAL_STATE = "wsrp-navigationalState";
    protected static final String PORTLET_DATA_PORTLET_STATE = "PortletState";
    protected static final String PORTLET_SETTINGS_REGISTRATION_CONTEXT_REGISTRATION_EXTENSIONS = "RegistrationContext_extensions";
    protected static final String PORTLET_SETTINGS_REGISTRATION_CONTEXT_REGISTRATION_HANDLE = "RegistrationContext_registrationHandle";
    protected static final String PORTLET_SETTINGS_REGISTRATION_CONTEXT_REGISTRATION_STATE = "RegistrationContext_registrationState";

    public ObjectHandlerImpl(GDKRequest request, GDKResponse response, WSRPParams wsrp, List forwardCookies, ServiceLogger logger) {
        this.m_request = request;
        this.m_response = response;
        this.m_wsrp = wsrp;
        this.m_logger = logger;
        this.m_forwardCookies = forwardCookies;
        if ("cps:config".equals(this.m_wsrp.mode)) {
            this.m_includeVersionInfo = true;
        }
    }

    public PortletContext getPortletContext(String hashkey, String initialPortletHandle) throws ConsumerException {
        this.m_logger.debug("getPortletContext() called.");
        PortletContext portletContext = TypeFactory.newInstance().createPortletContext();
        portletContext.setPortletHandle(this.m_wsrp.portletHandle);
        if ("cps:config".equals(this.m_wsrp.mode) || "cps:config".equals(this.m_request.getParameter("prevMode"))) {
            Map portletData = this.m_request.getAdminSettings();
            String state = (String)portletData.get(hashkey + PORTLET_DATA_PORTLET_STATE);
            if (state != null) {
                portletContext.setPortletState(Base64.decode((String)state));
            }
        } else {
            Map portletData = this.m_request.getGadgetSettings();
            String portletState = (String)portletData.get(hashkey + PORTLET_DATA_PORTLET_STATE);
            if (portletState == null || portletState.length() == 0) {
                this.m_logger.debug("Using admin level PortletContext.");
                Map settings = this.m_request.getAdminSettings();
                portletState = (String)settings.get(hashkey + PORTLET_DATA_PORTLET_STATE);
            }
            if (portletState != null) {
                portletContext.setPortletState(Base64.decode((String)portletState));
            }
        }
        return portletContext;
    }

    public void storePortletContext(String hashkey, PortletContext portletContext) throws ConsumerException {
        this.m_logger.debug("storePortletContext() called.");
        HashMap<String, String> portletData = new HashMap<String, String>();
        if ("cps:config".equals(this.m_wsrp.mode) || "cps:config".equals(this.m_request.getParameter("prevMode"))) {
            portletData.put(hashkey + PORTLET_DATA_PORTLET_STATE, Base64.encode((byte[])portletContext.getPortletState()));
            this.m_response.addAdminSettings(portletData);
        } else {
            portletData.put(hashkey + PORTLET_DATA_PORTLET_STATE, Base64.encode((byte[])portletContext.getPortletState()));
            this.m_response.addGadgetSettings(portletData);
        }
    }

    public RuntimeContext createRuntimeContext(String hashkey) throws ConsumerException {
        this.m_logger.debug("createRuntimeContext() called.");
        RuntimeContext runtimeContext = TypeFactory.newInstance().createRuntimeContext();
        runtimeContext.setUserAuthentication("wsrp:password");
        String portletInstanceKey = this.m_request.getGadgetSessionId();
        runtimeContext.setPortletInstanceKey("p" + portletInstanceKey);
        runtimeContext.setNamespacePrefix("ns" + portletInstanceKey);
        return runtimeContext;
    }

    public UserContext createUserContext(String hashkey) throws ConsumerException {
        this.m_logger.debug("createUserContext() called.");
        UserContext userContext = TypeFactory.newInstance().createUserContext();
        userContext.setUserContextKey(this.m_request.getPortalUserName());
        return userContext;
    }

    public MarkupParams createMarkupParams(String hashKey) throws ConsumerException {
        this.m_logger.debug("createMarkupParams() called.");
        MarkupParams markupParams = TypeFactory.newInstance().createMarkupParams();
        String navigationalState = this.m_wsrp.navigationalState;
        if (navigationalState == null) {
            navigationalState = (String)this.m_request.getHttpServletRequest().getSession().getAttribute(NAVIGATIONAL_STATE);
        }
        markupParams.setMode(this.m_wsrp.mode);
        markupParams.setWindowState(this.m_wsrp.windowState);
        markupParams.setNavigationalState(navigationalState);
        markupParams.setLocales(this.convertLocalesEnum(this.m_request.getHttpServletRequest().getLocales()));
        markupParams.addMimeTypes(this.m_request.getRequestedMimeType());
        markupParams.setSecureClientCommunication(false);
        markupParams.setMarkupCharacterSets(new String[]{"UTF-8"});
        ClientData clientData = TypeFactory.newInstance().createClientData();
        clientData.setUserAgent(this.m_request.getHttpServletRequest().getHeader("User-Agent"));
        markupParams.setClientData(clientData);
        markupParams.addValidNewModes("wsrp:view");
        if (!"wsrp:view".equals(this.m_wsrp.mode)) {
            markupParams.addValidNewModes(this.m_wsrp.mode);
        }
        for (int i = 0; i < m_supportedWindowStates.length; ++i) {
            markupParams.addValidNewWindowStates(m_supportedWindowStates[i]);
        }
        if (this.m_includeVersionInfo) {
            Extension versions = TypeFactory.newInstance().createExtension();
            versions.setAnyW3CElement(XMLUtils.parse((String)GetVersion.getVersion((String[])VERSION_PACKAGES, (boolean)false)));
            markupParams.addExtensions(versions);
        }
        Extension portalContextExtension = ExtensionHelper.createPortalContextExtension((PortalContext)this.createPortalContext());
        markupParams.addExtensions(portalContextExtension);
        return markupParams;
    }

    public InteractionParams createInteractionParams(String HashKey) throws ConsumerException {
        this.m_logger.debug("createInteractionParams() called.");
        InteractionParams interactionParams = TypeFactory.newInstance().createInteractionParams();
        interactionParams.setPortletStateChange(StateChange.READWRITE);
        interactionParams.setInteractionState(this.m_wsrp.interactionState);
        Enumeration paramsEnum = this.m_request.getParameterNames();
        while (paramsEnum.hasMoreElements()) {
            String name = (String)paramsEnum.nextElement();
            if (name.startsWith("wsrp-") || name.equals("prevMode")) continue;
            String[] values = this.m_request.getParameterValues(name);
            for (int i = 0; i < values.length; ++i) {
                NamedString formParameter = TypeFactory.newInstance().createNamedString();
                formParameter.setName(name);
                formParameter.setValue(values[i]);
                interactionParams.addFormParameters(formParameter);
            }
        }
        return interactionParams;
    }

    public String getConfigProperty(String name) {
        return GDKSettings.getConsumerProperty(name);
    }

    protected String getPortalAgent() {
        return "Plumtree";
    }

    protected String getConsumerAgent() {
        return "Plumtree.5.0";
    }

    protected String[] getSupportedModes() {
        return m_supportedModes;
    }

    protected String[] getSupportedWindowStates() {
        return m_supportedWindowStates;
    }

    protected Enumeration getRequestParameterNames() {
        return this.m_request.getParameterNames();
    }

    protected String[] getRequestParameterValues(String name) {
        return this.m_request.getParameterValues(name);
    }
}

