/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.plumtree;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.wsrp.consumer.helpers.ApplicationSession;
import com.cognos.cps.wsrp.consumer.helpers.PortletSessionImpl;
import javax.servlet.http.HttpSession;

public class PtPortletSessionImpl
extends PortletSessionImpl {
    private String userId;
    private ServiceLogger logger;

    public PtPortletSessionImpl(HttpSession session, String userId, ServiceLogger logger) {
        super(session);
        this.userId = userId;
        this.logger = logger;
    }

    protected ApplicationSession getApplicationSession() {
        ApplicationSession appSession = (ApplicationSession)this.fetchPropertyByName("ApplicationSession");
        if (appSession == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("creating application scope session for session with ids: " + this.fetchMyUniqueId() + ", " + this.userId);
            }
            appSession = new ApplicationSession("p" + this.userId);
            this.applyPropertyByName("ApplicationSession", appSession);
        }
        return appSession;
    }

    public void setProperty(String name, Object value, int scope) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Setting session attribute: " + name + " with value [" + value + "] and scope=" + scope);
        }
        super.applyPropertyByNameAndScope(name, value, scope);
    }
}

