/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.plumtree;

import com.cognos.cps.common.utils.CookieUtils;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionHandler;
import com.cognos.cps.wsrp.consumer.CacheHandler;
import com.cognos.cps.wsrp.consumer.HttpSOAPConnection;
import com.cognos.cps.wsrp.consumer.ObjectHandler;
import com.cognos.cps.wsrp.consumer.PropylaealetSession;
import com.cognos.cps.wsrp.consumer.RequestContextDefault;
import com.cognos.cps.wsrp.consumer.URLRewriteHandler;
import com.cognos.cps.wsrp.consumer.helpers.CacheHandlerImpl;
import com.cognos.cps.wsrp.consumer.impls.plumtree.GDKRequest;
import com.cognos.cps.wsrp.consumer.impls.plumtree.GDKResponse;
import com.cognos.cps.wsrp.consumer.impls.plumtree.GDKSettings;
import com.cognos.cps.wsrp.consumer.impls.plumtree.HttpSOAPConnectionImpl;
import com.cognos.cps.wsrp.consumer.impls.plumtree.ObjectHandlerImpl;
import com.cognos.cps.wsrp.consumer.impls.plumtree.PtPortletSessionImpl;
import com.cognos.cps.wsrp.consumer.impls.plumtree.ServiceLoggerImpl;
import com.cognos.cps.wsrp.consumer.impls.plumtree.URLRewriterImpl;
import com.cognos.cps.wsrp.consumer.impls.plumtree.WSRPParams;
import java.io.IOException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;

public class RequestContextImpl
extends RequestContextDefault {
    private static final String PROPERTY_FORWARD_COOKIES = "forward_cookies";
    private static final String CPS_AUTH_COOKIE = "cps_auth_user";
    private static final String PROPERTY_SECRET = "cps_auth_secret";
    private static final String PROPERTY_NAMESPACE = "cps_auth_namespace";
    private static final List g_forwardCookies;
    private GDKRequest m_request;
    private GDKResponse m_response;
    private WSRPParams m_wsrp;
    private int m_maxCachedPages;

    private RequestContextImpl() {
    }

    public RequestContextImpl(GDKRequest request, GDKResponse response, WSRPParams wsrp, ServiceLoggerImpl logger, int maxCachedPages, String wsdlUrl) {
        this.m_request = request;
        this.m_response = response;
        this.m_wsrp = wsrp;
        this.m_logger = logger;
        this.m_maxCachedPages = maxCachedPages;
        this.m_wsdlUrl = wsdlUrl;
    }

    public RequestContextImpl(GDKRequest request, GDKResponse response, WSRPParams wsrp, ServiceLoggerImpl logger, int maxCachedPages, CSSClassSubstitutionHandler cssClassSubstitutionHandler, String wsdlUrl) {
        this(request, response, wsrp, logger, maxCachedPages, wsdlUrl);
        this.m_cssClassSubstitutionHandler = cssClassSubstitutionHandler;
    }

    public ObjectHandler getObjectHandler() {
        if (this.m_objectHandler == null) {
            this.m_objectHandler = new ObjectHandlerImpl(this.m_request, this.m_response, this.m_wsrp, g_forwardCookies, this.m_logger);
        }
        return this.m_objectHandler;
    }

    public CacheHandler getCacheHandler() {
        if (this.m_cacheHandler == null) {
            this.m_cacheHandler = new CacheHandlerImpl(this.m_logger, this.getSession(), this.m_maxCachedPages);
        }
        return this.m_cacheHandler;
    }

    public URLRewriteHandler getURLRewriteHandler() {
        if (this.m_urlRewriteHandler == null) {
            this.m_urlRewriteHandler = new URLRewriterImpl(this.m_request, this.m_wsrp.mode);
        }
        return this.m_urlRewriteHandler;
    }

    public Writer getResultWriter() throws IOException {
        return this.m_response.getHttpServletResponse().getWriter();
    }

    public HttpSOAPConnection createHttpSOAPConnection() {
        String authorization = this.m_request.getHttpServletRequest().getHeader("Authorization");
        String namespaceId = GDKSettings.getConsumerProperty(PROPERTY_NAMESPACE);
        return new HttpSOAPConnectionImpl(this.getCookies(), (SOAPObjectHandler)TypeFactory.newInstance(), namespaceId, authorization, this.m_logger, this.m_request.getHttpServletRequest().getLocale());
    }

    public HttpURLConnection createHttpURLConnection(URL url) throws IOException {
        String authorization = this.m_request.getHttpServletRequest().getHeader("Authorization");
        String namespaceId = GDKSettings.getConsumerProperty(PROPERTY_NAMESPACE);
        HttpSOAPConnectionImpl connectionGenerator = new HttpSOAPConnectionImpl(this.getCookies(), (SOAPObjectHandler)TypeFactory.newInstance(), namespaceId, authorization, this.m_logger, this.m_request.getHttpServletRequest().getLocale());
        return connectionGenerator.openConnection(url);
    }

    public PropylaealetSession getSession() {
        return new PtPortletSessionImpl(this.m_request.getHttpServletRequest().getSession(true), this.m_request.getUserId(), this.m_logger);
    }

    private Cookie[] getCookies() {
        this.m_logger.debug("getCookies() called.");
        Cookie[] cookies = new Cookie[]{};
        Cookie[] requestCookies = this.m_request.getHttpServletRequest().getCookies();
        if (requestCookies != null) {
            for (int i = 0; i < requestCookies.length; ++i) {
                Cookie c = requestCookies[i];
                if (!g_forwardCookies.contains(c.getName())) continue;
                cookies = CookieUtils.addCookie((Cookie[])cookies, (Cookie)c);
            }
        }
        return cookies;
    }

    public Cookie getAuthCookie() {
        this.m_logger.debug("getAuthCookie() called.");
        Cookie cookie = null;
        if (!this.m_request.isGuestUser()) {
            String user = this.m_request.getPortalUserName();
            String secret = GDKSettings.getConsumerProperty(PROPERTY_SECRET);
            cookie = this.getAuthCookie(user, secret, CPS_AUTH_COOKIE);
        }
        return cookie;
    }

    static {
        ArrayList<String> forwardCookiesTempList = new ArrayList<String>();
        String forwardCookies = GDKSettings.getConsumerProperty(PROPERTY_FORWARD_COOKIES, "");
        StringTokenizer tokens = new StringTokenizer(forwardCookies, ",");
        while (tokens.hasMoreTokens()) {
            forwardCookiesTempList.add(tokens.nextToken().trim());
        }
        g_forwardCookies = Collections.unmodifiableList(forwardCookiesTempList);
    }
}

