/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.plumtree;

import com.cognos.cps.common.logging.ServiceLogger;
import javax.servlet.ServletContext;

public class ServiceLoggerImpl
implements ServiceLogger,
Cloneable {
    private ServletContext m_servletContext = null;
    private String m_loggingPrefix = null;
    private static final int LOGGING_ERROR = 0;
    private static final int LOGGING_WARN = 1;
    private static final int LOGGING_INFO = 2;
    private static final int LOGGING_DEBUG = 3;
    private int m_loggingLevel;

    public ServiceLoggerImpl(ServletContext servletContext, String loggingPrefix, String loggingLevel) {
        this.m_servletContext = servletContext;
        this.m_loggingPrefix = loggingPrefix;
        String sLoggingLevel = loggingLevel;
        this.m_loggingLevel = sLoggingLevel.equalsIgnoreCase("DEBUG") ? 3 : (sLoggingLevel.equalsIgnoreCase("INFO") ? 2 : (sLoggingLevel.equalsIgnoreCase("WARN") ? 1 : (sLoggingLevel.equalsIgnoreCase("ERROR") ? 0 : 0)));
    }

    public ServiceLoggerImpl(ServiceLoggerImpl logger, String loggingPrefix, String loggingLevel) {
        this(logger.m_servletContext, logger.m_loggingPrefix + loggingPrefix, loggingLevel);
    }

    public ServiceLoggerImpl(ServletContext servletContext, String loggingPrefix) {
        this.m_servletContext = servletContext;
        this.m_loggingPrefix = loggingPrefix;
        this.m_loggingLevel = 0;
    }

    public ServiceLoggerImpl(ServiceLoggerImpl logger, String loggingPrefix) {
        this.m_servletContext = logger.m_servletContext;
        this.m_loggingPrefix = logger.m_loggingPrefix + loggingPrefix;
        this.m_loggingLevel = logger.m_loggingLevel;
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.m_servletContext.log(this.m_loggingPrefix + "[info]: " + message);
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.m_servletContext.log(this.m_loggingPrefix + "[warning]: " + message);
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.m_servletContext.log(this.m_loggingPrefix + "[error]: " + message);
        }
    }

    public void error(String message, Throwable e) {
        if (this.isErrorEnabled()) {
            this.m_servletContext.log(this.m_loggingPrefix + "[error]: " + message, e);
        }
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.m_servletContext.log(this.m_loggingPrefix + "[debug]: " + message);
        }
    }

    public void enter(String method) {
        this.m_servletContext.log(this.m_loggingPrefix + "[enter]: " + method);
    }

    public void enter(String method, Object[] objects) {
        this.m_servletContext.log(this.m_loggingPrefix + "[enter]: " + method + " " + objects.toString());
    }

    public void exit(String method) {
        this.m_servletContext.log(this.m_loggingPrefix + "[exit]: " + method);
    }

    public void exit(String method, Object[] objects) {
        this.m_servletContext.log(this.m_loggingPrefix + "[exit]: " + method + " " + objects.toString());
    }

    public ServiceLogger cloneForClass(Class className) {
        try {
            return (ServiceLogger)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean isInfoEnabled() {
        return this.m_loggingLevel >= 2;
    }

    public boolean isWarnEnabled() {
        return this.m_loggingLevel >= 1;
    }

    public boolean isErrorEnabled() {
        return this.m_loggingLevel >= 0;
    }

    public boolean isDebugEnabled() {
        return this.m_loggingLevel >= 3;
    }

    public boolean isAuditLevelEnabled(int level) {
        return false;
    }

    public void logAudit(int level, int operation, String message) {
    }

    public boolean isPerfLevelEnabled(int level) {
        return false;
    }

    public Object startTimer(int level, String method, String description, Object obj) {
        return null;
    }

    public void stopTimer(Object timer) {
    }
}

